/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.tools;

import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.gef.tools.InlineConnectionCreationTool;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gef.tools.ConnectionDragCreationTool;
import org.eclipse.gef.tools.ConnectionEndpointTracker;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;

public class ScrollingConnectionEndpointTracker
extends ConnectionEndpointTracker {
    private ConnectionDragCreationTool conCreationTool = null;

    public ScrollingConnectionEndpointTracker(ConnectionEditPart cep) {
        super(cep);
    }

    public void mouseDrag(MouseEvent me, EditPartViewer viewer) {
        if (this.conCreationTool != null) {
            this.getCurrentInput().setInput(me);
            this.conCreationTool.mouseDrag(me, viewer);
        } else if ((me.stateMask & SWT.MOD1) != 0) {
            this.startConnCreation();
        } else {
            super.mouseDrag(me, viewer);
        }
    }

    public void keyDown(KeyEvent keyEvent, EditPartViewer viewer) {
        if (this.conCreationTool == null && keyEvent.keyCode == SWT.MOD1) {
            this.startConnCreation();
        } else {
            super.keyDown(keyEvent, viewer);
        }
    }

    private void startConnCreation() {
        EditPart target = this.getCommandName().equals("Reconnection source") ? this.getConnectionEditPart().getTarget() : this.getConnectionEditPart().getSource();
        this.conCreationTool = this.createConnectionCreationTool(target);
        this.updateTarget(this.getStartLocation());
    }

    protected ConnectionDragCreationTool createConnectionCreationTool(EditPart target) {
        return InlineConnectionCreationTool.createInlineConnCreationTool(target, this.getDomain(), this.getCurrentViewer(), this.getLocation());
    }

    private void updateTarget(Point p) {
        ReconnectRequest request = this.getTargetRequest();
        request.setLocation(p);
        EditPart target = this.getCommandName().equals("Reconnection source") ? this.getConnectionEditPart().getSource() : this.getConnectionEditPart().getTarget();
        request.setTargetEditPart(target);
        this.getConnectionEditPart().showSourceFeedback((Request)request);
        this.getConnectionEditPart().showTargetFeedback((Request)request);
    }

    public void keyUp(KeyEvent keyEvent, EditPartViewer viewer) {
        if (this.conCreationTool != null && keyEvent.keyCode == SWT.MOD1) {
            this.deactivateConCreationTool();
            this.updateTarget(this.getLocation());
        }
        super.keyUp(keyEvent, viewer);
    }

    public void mouseMove(MouseEvent me, EditPartViewer viewer) {
        if (this.conCreationTool != null) {
            this.conCreationTool.mouseMove(me, viewer);
        } else {
            super.mouseMove(me, viewer);
        }
    }

    public void mouseUp(MouseEvent me, EditPartViewer viewer) {
        if (this.conCreationTool != null) {
            this.conCreationTool.mouseUp(me, viewer);
            this.deactivateConCreationTool();
            this.handleFinished();
        } else {
            super.mouseUp(me, viewer);
        }
    }

    public void setEditDomain(EditDomain domain) {
        if (this.conCreationTool != null) {
            this.conCreationTool.setEditDomain(domain);
        }
        super.setEditDomain(domain);
    }

    public void setViewer(EditPartViewer viewer) {
        if (this.conCreationTool != null) {
            this.conCreationTool.setViewer(viewer);
        }
        super.setViewer(viewer);
    }

    public void viewerEntered(MouseEvent mouseEvent, EditPartViewer viewer) {
        if (this.conCreationTool != null) {
            this.conCreationTool.viewerEntered(mouseEvent, viewer);
        }
        super.viewerEntered(mouseEvent, viewer);
    }

    public void viewerExited(MouseEvent mouseEvent, EditPartViewer viewer) {
        if (this.conCreationTool != null) {
            this.conCreationTool.viewerExited(mouseEvent, viewer);
        }
        super.viewerExited(mouseEvent, viewer);
    }

    public void setProperties(Map properties) {
        if (this.conCreationTool != null) {
            this.conCreationTool.setProperties(properties);
        }
        super.setProperties(properties);
    }

    public void commitDrag() {
        if (this.conCreationTool != null) {
            this.conCreationTool.commitDrag();
        }
        super.commitDrag();
    }

    public void deactivate() {
        if (this.conCreationTool != null) {
            this.deactivateConCreationTool();
        }
        super.deactivate();
    }

    private void deactivateConCreationTool() {
        this.conCreationTool.deactivate();
        this.conCreationTool = null;
    }
}

