/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.tools;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.gef.tools.FordiacConnectionDragCreationTool;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.swt.events.MouseEvent;

public final class InlineConnectionCreationTool
extends FordiacConnectionDragCreationTool {
    private static final int LEFT_MOUSE = 1;
    private final EditPart sourcePart;
    private EditPart lastConnTarget;
    private boolean startup = true;

    public static InlineConnectionCreationTool createInlineConnCreationTool(EditPart originalSource, EditDomain editDomain, EditPartViewer editPartViewer, Point location) {
        InlineConnectionCreationTool connectionCreationTool = new InlineConnectionCreationTool(originalSource);
        connectionCreationTool.setViewer(editPartViewer);
        connectionCreationTool.setEditDomain(editDomain);
        connectionCreationTool.setInitialViewer(editPartViewer);
        connectionCreationTool.startup(location);
        return connectionCreationTool;
    }

    private InlineConnectionCreationTool(EditPart sourcePart) {
        this.sourcePart = sourcePart;
    }

    private void startup(Point point) {
        this.startup = true;
        this.activate();
        super.handleButtonDown(1);
        this.startup = false;
        this.handleDragStarted();
        this.getCurrentInput().setMouseLocation(point.x, point.y);
        this.handleMove();
    }

    @Override
    public void mouseUp(MouseEvent me, EditPartViewer viewer) {
        super.mouseUp(me, viewer);
        this.lastConnTarget = this.getTargetEditPart();
        this.startup(new Point(me.x, me.y));
    }

    protected EditPart getTargetEditPart() {
        if (this.startup) {
            return this.sourcePart;
        }
        EditPart part = super.getTargetEditPart();
        if (part != null && part.equals(this.lastConnTarget)) {
            part = null;
        }
        return part;
    }
}

