/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.model.commands.change.ReconnectAdapterConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.change.ReconnectDataConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.change.ReconnectEventConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.data.provider.DataItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.provider.LibraryElementItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.model.validation.LinkConstraints;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;

public class ChangeDestinationSourceDialog
extends MessageDialog {
    private static final int NUMBER_OF_COLLUMNS = 1;
    private static final int TABLE_COL_WIDTH = 150;
    private static final String[] BUTTON_LABELS = new String[]{SWT.getMessage((String)"SWT_Cancel")};
    private Connection connection;
    private final IInterfaceElement ieToChange;
    private IInterfaceElement ie;
    private ColumnLabelProvider labelTarget;
    private ColumnLabelProvider labelPin;
    private ColumnLabelProvider labelComment;
    private ComposedAdapterFactory adapterFactory;
    private CommandStack commandStack = null;

    public ChangeDestinationSourceDialog(Shell parentShell, Connection con, IInterfaceElement ie) {
        super(parentShell, Messages.InterfaceElementSection_MessageDialog_TITLE, null, "", 0, 0, BUTTON_LABELS);
        this.connection = con;
        this.ieToChange = ie;
        this.ie = con.getSource().equals(ie) ? this.connection.getDestination() : this.connection.getSource();
    }

    void setConnection(Connection con) {
        this.connection = con;
    }

    void setInterfaceElement(IInterfaceElement ie) {
        this.ie = ie;
    }

    protected Control createCustomArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite fbResultArea = (Composite)WidgetFactory.composite((int)0).create((Widget)parent);
        fbResultArea.setLayout((Layout)new GridLayout(1, true));
        fbResultArea.setLayoutData((Object)new GridData(4, 4, true, true));
        List<IInterfaceElement> result = this.createInputSet();
        if (result.isEmpty()) {
            Label warningLabel = (Label)LabelFactory.newLabel((int)0).create((Widget)fbResultArea);
            warningLabel.setText("No Interface Elements found");
        } else {
            TreeViewer treeViewer = ChangeDestinationSourceDialog.createTreeViewer(fbResultArea);
            this.configureTableViewer(treeViewer);
            treeViewer.setInput((Object)result.toArray());
            GridLayoutFactory.fillDefaults().generateLayout(fbResultArea);
        }
        return parent;
    }

    private List<IInterfaceElement> createInputSet() {
        IEditorPart currentActiveEditor = EditorUtils.getCurrentActiveEditor();
        GraphicalViewer viewer = (GraphicalViewer)currentActiveEditor.getAdapter(GraphicalViewer.class);
        if (viewer != null) {
            this.commandStack = viewer.getEditDomain().getCommandStack();
        }
        if (this.connection != null && this.ie != null && this.connection.getFBNetwork() != null && this.connection.getFBNetwork().getNetworkElements() != null) {
            List<InterfaceList> possibleInterfaceLists;
            EObject eObject;
            if (this.connection.getFBNetwork().isSubApplicationNetwork() && (eObject = this.connection.getFBNetwork().eContainer()) instanceof SubApp) {
                SubApp subapp = (SubApp)eObject;
                possibleInterfaceLists = this.getPossibleInterfaceLists(this.connection.getFBNetwork().getBlockFBNetworkElements(), subapp);
            } else {
                possibleInterfaceLists = this.getPossibleInterfaceLists(this.connection.getFBNetwork().getBlockFBNetworkElements(), null);
            }
            if (!possibleInterfaceLists.isEmpty()) {
                if (this.connection instanceof DataConnection) {
                    return this.getVarDeclarationsFromInterfaceLists(possibleInterfaceLists, this.ie.isIsInput());
                }
                if (this.connection instanceof EventConnection) {
                    return this.getEventFromInterfaceLists(possibleInterfaceLists, this.ie.isIsInput());
                }
                if (this.connection instanceof AdapterConnection) {
                    return this.getAdapterFromInterfaceLists(possibleInterfaceLists, this.ie.isIsInput());
                }
            }
        }
        return Collections.emptyList();
    }

    private List<InterfaceList> getPossibleInterfaceLists(Stream<BlockFBNetworkElement> fbs, SubApp subapp) {
        SubApp subappContainer;
        BlockFBNetworkElement blockFBNetworkElement;
        ArrayList<InterfaceList> possibleInterfaceLists = new ArrayList<InterfaceList>(fbs.filter(currentFb -> !currentFb.getName().equals(this.ie.getBlockFBNetworkElement().getName())).toList().stream().map(BlockFBNetworkElement::getInterface).toList());
        if (!(subapp == null || (blockFBNetworkElement = this.ie.getBlockFBNetworkElement()) instanceof SubApp && (subappContainer = (SubApp)blockFBNetworkElement).equals(subapp))) {
            possibleInterfaceLists.add(subapp.getInterface());
        }
        return possibleInterfaceLists;
    }

    private boolean inputSwap(boolean input, InterfaceList ieList) {
        SubApp subapp;
        SubApp subapp2;
        BlockFBNetworkElement blockFBNetworkElement = this.ie.getBlockFBNetworkElement();
        if (blockFBNetworkElement instanceof SubApp && !(subapp2 = (SubApp)blockFBNetworkElement).isTyped()) {
            SubApp outsideSubApp;
            if (subapp2.getSubAppNetwork().getNetworkElements().contains((Object)ieList.getBlockFBNetworkElement())) {
                return !input;
            }
            FBNetworkElement fBNetworkElement = subapp2.getOuterFBNetworkElement();
            if (fBNetworkElement instanceof SubApp && !(outsideSubApp = (SubApp)fBNetworkElement).isTyped() && !outsideSubApp.getSubAppNetwork().getNetworkElements().contains((Object)ieList.getBlockFBNetworkElement())) {
                return !input;
            }
            return input;
        }
        BlockFBNetworkElement blockFBNetworkElement2 = ieList.getBlockFBNetworkElement();
        if (blockFBNetworkElement2 instanceof SubApp && !(subapp = (SubApp)blockFBNetworkElement2).isTyped()) {
            if (subapp.getSubAppNetwork().getNetworkElements().contains((Object)this.ie.getBlockFBNetworkElement())) {
                return !input;
            }
            return input;
        }
        return input;
    }

    private List<IInterfaceElement> getVarDeclarationsFromInterfaceLists(List<InterfaceList> ieLists, boolean input) {
        ArrayList<IInterfaceElement> varDec = new ArrayList<IInterfaceElement>();
        for (InterfaceList ieList : ieLists) {
            if (this.inputSwap(input, ieList)) {
                varDec.addAll(ieList.getOutputVars().stream().filter(newIE -> newIE != this.ieToChange).filter(newIE -> LinkConstraints.typeCheck((IInterfaceElement)this.ie, (IInterfaceElement)newIE)).toList());
                continue;
            }
            varDec.addAll(ieList.getInputVars().stream().filter(newIE -> newIE != this.ieToChange).filter(newIE -> LinkConstraints.typeCheck((IInterfaceElement)this.ie, (IInterfaceElement)newIE)).filter(newIE -> newIE.getInputConnections().isEmpty()).toList());
        }
        return varDec;
    }

    private List<IInterfaceElement> getEventFromInterfaceLists(List<InterfaceList> ieLists, boolean input) {
        ArrayList<IInterfaceElement> event = new ArrayList<IInterfaceElement>();
        for (InterfaceList ieList : ieLists) {
            if (this.inputSwap(input, ieList)) {
                event.addAll(ieList.getEventOutputs().stream().filter(newIE -> newIE != this.ieToChange).toList());
                continue;
            }
            event.addAll(ieList.getEventInputs().stream().filter(newIE -> newIE != this.ieToChange).toList());
        }
        return event;
    }

    private List<IInterfaceElement> getAdapterFromInterfaceLists(List<InterfaceList> ieLists, boolean input) {
        ArrayList<IInterfaceElement> adapter = new ArrayList<IInterfaceElement>();
        for (InterfaceList ieList : ieLists) {
            if (this.inputSwap(input, ieList)) {
                adapter.addAll(ieList.getPlugs().stream().filter(newIE -> newIE != this.ieToChange).filter(newIE -> newIE.getOutputConnections().isEmpty()).toList());
                continue;
            }
            adapter.addAll(ieList.getSockets().stream().filter(newIE -> newIE != this.ieToChange).filter(newIE -> newIE.getInputConnections().isEmpty()).toList());
        }
        return adapter;
    }

    private static TreeViewer createTreeViewer(Composite parent) {
        return new TreeViewer(parent, 67584);
    }

    private void configureTableViewer(TreeViewer viewer) {
        this.createLabelProviders();
        viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ArrayContentProvider.getInstance().getElements(inputElement);
            }

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }
        });
        Tree table = viewer.getTree();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayout((Layout)ChangeDestinationSourceDialog.createTableLayout());
        table.setSortDirection(1024);
        TreeViewerColumn colTarget = new TreeViewerColumn(viewer, 16384);
        colTarget.getColumn().setText(FordiacMessages.Target);
        colTarget.setLabelProvider((CellLabelProvider)this.labelTarget);
        table.setSortColumn(colTarget.getColumn());
        TreeViewerColumn colPin = new TreeViewerColumn(viewer, 16384);
        colPin.getColumn().setText(FordiacMessages.Pin);
        colPin.setLabelProvider((CellLabelProvider)this.labelPin);
        TreeViewerColumn colName = new TreeViewerColumn(viewer, 16384);
        colName.getColumn().setText(FordiacMessages.Comment);
        colName.setLabelProvider((CellLabelProvider)this.labelComment);
        viewer.addDoubleClickListener((IDoubleClickListener)new DoubleClickListener());
    }

    private void createLabelProviders() {
        final AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.getAdapterFactory());
        this.labelTarget = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IInterfaceElement) {
                    IInterfaceElement ieElement = (IInterfaceElement)element;
                    return ieElement.getBlockFBNetworkElement().getName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof IInterfaceElement) {
                    IInterfaceElement ieElement = (IInterfaceElement)element;
                    return labelProvider.getImage((Object)ieElement.getBlockFBNetworkElement());
                }
                return super.getImage(element);
            }
        };
        this.labelPin = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IInterfaceElement) {
                    IInterfaceElement ieElement = (IInterfaceElement)element;
                    return ieElement.getName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof IInterfaceElement) {
                    IInterfaceElement ieElement = (IInterfaceElement)element;
                    return labelProvider.getImage((Object)ieElement);
                }
                return super.getImage(element);
            }
        };
        this.labelComment = new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IInterfaceElement) {
                    IInterfaceElement ieElement = (IInterfaceElement)element;
                    return ieElement.getComment();
                }
                return super.getText(element);
            }
        };
    }

    private final ComposedAdapterFactory getAdapterFactory() {
        if (this.adapterFactory == null) {
            this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new LibraryElementItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new DataItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        }
        return this.adapterFactory;
    }

    private static TableLayout createTableLayout() {
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(150));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(150));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(150));
        return layout;
    }

    private void createReconnectConnectionCommand(IInterfaceElement pinSelection) {
        ReconnectDataConnectionCommand cmdCommand = null;
        if (pinSelection instanceof VarDeclaration) {
            VarDeclaration varDec = (VarDeclaration)pinSelection;
            cmdCommand = new ReconnectDataConnectionCommand(this.connection, this.connection.getSource().equals(this.ieToChange), (IInterfaceElement)varDec, this.ie.getBlockFBNetworkElement().getFbNetwork());
        }
        if (pinSelection instanceof Event) {
            Event eventPin = (Event)pinSelection;
            cmdCommand = new ReconnectEventConnectionCommand(this.connection, this.connection.getSource().equals(this.ieToChange), (IInterfaceElement)eventPin, this.ie.getBlockFBNetworkElement().getFbNetwork());
        }
        if (pinSelection instanceof AdapterDeclaration) {
            AdapterDeclaration adapter = (AdapterDeclaration)pinSelection;
            cmdCommand = new ReconnectAdapterConnectionCommand(this.connection, this.connection.getSource().equals(this.ieToChange), (IInterfaceElement)adapter, this.ie.getBlockFBNetworkElement().getFbNetwork());
        }
        if (cmdCommand != null && cmdCommand.canExecute() && this.commandStack != null) {
            this.commandStack.execute(cmdCommand);
        }
    }

    private void createNewConnectionCommand(IInterfaceElement pinSelection) {
        DataConnectionCreateCommand createCommand = null;
        if (pinSelection instanceof VarDeclaration) {
            createCommand = new DataConnectionCreateCommand(this.connection.getFBNetwork());
        }
        if (pinSelection instanceof Event) {
            createCommand = new EventConnectionCreateCommand(this.connection.getFBNetwork());
        }
        if (pinSelection instanceof AdapterDeclaration) {
            createCommand = new AdapterConnectionCreateCommand(this.connection.getFBNetwork());
        }
        CompoundCommand cmd = new CompoundCommand();
        cmd.add((Command)new DeleteConnectionCommand(this.connection));
        if (createCommand != null && cmd.canExecute() && this.commandStack != null) {
            if (this.ie.isIsInput()) {
                createCommand.setSource(pinSelection);
                createCommand.setDestination(this.ie);
            } else {
                createCommand.setDestination(pinSelection);
                createCommand.setSource(this.ie);
            }
            cmd.add((Command)createCommand);
            this.commandStack.execute((Command)cmd);
        }
    }

    static enum Case {
        OUTPUT_NOSUBAPP,
        OUTPUT_SUBAPP,
        INPUT_NOSUBAPP,
        INPUT_SUBAPP;

    }

    private class DoubleClickListener
    implements IDoubleClickListener {
        private DoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection == null || selection.isEmpty()) {
                return;
            }
            Object object = selection.getFirstElement();
            if (object instanceof IInterfaceElement) {
                IInterfaceElement ieElement = (IInterfaceElement)object;
                if (ieElement.isIsInput() == ChangeDestinationSourceDialog.this.ie.isIsInput()) {
                    ChangeDestinationSourceDialog.this.createNewConnectionCommand(ieElement);
                } else {
                    ChangeDestinationSourceDialog.this.createReconnectConnectionCommand(ieElement);
                }
            }
            ChangeDestinationSourceDialog.this.close();
        }
    }
}

