/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.nat;

import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.gef.nat.AbstractCommandColumnAccessor;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationTableColumn;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDataTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangePinVisibilityCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeRetainAttributeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeValueCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeVarConfigurationCommand;
import org.eclipse.fordiac.ide.model.datatype.helper.RetainHelper;
import org.eclipse.fordiac.ide.model.edit.helper.CommentHelper;
import org.eclipse.fordiac.ide.model.edit.helper.InitialValueHelper;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.MemberVarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.preferences.PreferenceStoreProvider;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.gef.commands.Command;

public class VarDeclarationColumnAccessor
extends AbstractCommandColumnAccessor<VarDeclaration, VarDeclarationTableColumn> {
    public VarDeclarationColumnAccessor(CommandExecutor commandExecutor) {
        this(commandExecutor, VarDeclarationTableColumn.DEFAULT_COLUMNS);
    }

    public VarDeclarationColumnAccessor(CommandExecutor commandExecutor, List<VarDeclarationTableColumn> columns) {
        super(commandExecutor, columns);
    }

    public Object getDataValue(VarDeclaration rowObject, VarDeclarationTableColumn column) {
        return switch (column) {
            case VarDeclarationTableColumn.NAME -> {
                if (rowObject instanceof MemberVarDeclaration) {
                    MemberVarDeclaration memVar = (MemberVarDeclaration)rowObject;
                    yield memVar.getDisplayName();
                }
                yield rowObject.getName();
            }
            case VarDeclarationTableColumn.TYPE -> rowObject.getFullTypeName();
            case VarDeclarationTableColumn.COMMENT -> CommentHelper.getInstanceComment((INamedElement)rowObject);
            case VarDeclarationTableColumn.INITIAL_VALUE -> VarDeclarationColumnAccessor.getInitialValue(rowObject);
            case VarDeclarationTableColumn.VAR_CONFIG -> rowObject.isVarConfig();
            case VarDeclarationTableColumn.VISIBLE, VarDeclarationTableColumn.VISIBLEIN -> rowObject.isVisible();
            case VarDeclarationTableColumn.RETAIN -> VarDeclarationColumnAccessor.getAttributeValueAsString(rowObject);
            case VarDeclarationTableColumn.VISIBLEOUT -> rowObject.getInOutVarOpposite().isVisible();
            case VarDeclarationTableColumn.FILE_PATH -> EcoreUtil.getURI((EObject)rowObject).toPlatformString(true);
            case VarDeclarationTableColumn.LOCATION -> FordiacMarkerHelper.getLocation((EObject)rowObject);
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)column));
        };
    }

    private static String getAttributeValueAsString(VarDeclaration rowObject) {
        Attribute attribute = rowObject.getAttribute("Retain");
        if (attribute == null) {
            return "";
        }
        return Objects.toString(RetainHelper.deriveTag((String)attribute.getValue()).getString(), "");
    }

    @Override
    public Command createCommand(VarDeclaration rowObject, VarDeclarationTableColumn column, Object newValue) {
        return switch (column) {
            case VarDeclarationTableColumn.NAME -> ChangeNameCommand.forName((INamedElement)rowObject, (String)Objects.toString(newValue, ""));
            case VarDeclarationTableColumn.TYPE -> ChangeDataTypeCommand.forTypeDeclaration((IInterfaceElement)rowObject, (String)Objects.toString(newValue, ""));
            case VarDeclarationTableColumn.COMMENT -> new ChangeCommentCommand((INamedElement)rowObject, Objects.toString(newValue, ""));
            case VarDeclarationTableColumn.INITIAL_VALUE -> new ChangeValueCommand(rowObject, Objects.toString(newValue, ""));
            case VarDeclarationTableColumn.VAR_CONFIG -> new ChangeVarConfigurationCommand(rowObject, Boolean.parseBoolean(Objects.toString(newValue, "")));
            case VarDeclarationTableColumn.VISIBLE, VarDeclarationTableColumn.VISIBLEIN -> new ChangePinVisibilityCommand((IInterfaceElement)rowObject, Boolean.parseBoolean(Objects.toString(newValue, "")));
            case VarDeclarationTableColumn.VISIBLEOUT -> new ChangePinVisibilityCommand((IInterfaceElement)rowObject.getInOutVarOpposite(), Boolean.parseBoolean(Objects.toString(newValue, "")));
            case VarDeclarationTableColumn.RETAIN -> new ChangeRetainAttributeCommand((IInterfaceElement)rowObject, RetainHelper.deriveTag((String)rowObject.getAttributeValue("Retain")), RetainHelper.deriveTag((String)Objects.toString(newValue, "")));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)column));
        };
    }

    public static String getInitialValue(VarDeclaration rowObject) {
        String value = InitialValueHelper.getInitialOrDefaultValue((Object)rowObject);
        TypeLibrary typeLib = TypeLibraryManager.INSTANCE.getTypeLibraryFromContext((EObject)rowObject);
        if (typeLib == null || typeLib.getProject() == null) {
            return value;
        }
        if (value.length() > PreferenceStoreProvider.getStore((String)"org.eclipse.fordiac.ide.gef", (IProject)TypeLibraryManager.INSTANCE.getTypeLibraryFromContext((EObject)rowObject).getProject()).getInt("MaxDefaultValueLength")) {
            return FordiacMessages.ValueTooLarge;
        }
        return value;
    }
}

