/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.policies;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.CreateTransitionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ReconnectTransitionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public class TransitionNodeEditPolicy
extends GraphicalNodeEditPolicy {
    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        if (request.getStartCommand() instanceof CreateTransitionCommand) {
            CreateTransitionCommand command = (CreateTransitionCommand)request.getStartCommand();
            if (this.getHost().getModel() instanceof ECState) {
                Point destination = request.getLocation().getCopy();
                this.getHostFigure().translateToRelative((Translatable)destination);
                command.setDestinationLocation(destination);
                command.setDestination((ECState)this.getHost().getModel());
                return command;
            }
        }
        return null;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        CreateTransitionCommand cmd = new CreateTransitionCommand();
        if (this.getHost().getModel() instanceof ECState) {
            Point source = request.getLocation().getCopy();
            this.getHostFigure().translateToRelative((Translatable)source);
            cmd.setSource((ECState)this.getHost().getModel());
            cmd.setSourceLocation(source);
            cmd.setViewer(this.getHost().getViewer());
        }
        request.setStartCommand((Command)cmd);
        return cmd;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        ECTransition transition = (ECTransition)request.getConnectionEditPart().getModel();
        return transition.getSource().equals(request.getTarget().getModel()) ? null : new ReconnectTransitionCommand(request);
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        ECTransition transition = (ECTransition)request.getConnectionEditPart().getModel();
        return transition.getDestination().equals(request.getTarget().getModel()) ? null : new ReconnectTransitionCommand(request);
    }
}

