/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.editparts;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.AbstractInterfaceElementEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.CommentTypeEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.FBTypeRootEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.InputWithAnchor;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.OutputWithAnchor;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.WithEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.policies.DeleteInterfaceEditPolicy;
import org.eclipse.fordiac.ide.fbtypeeditor.policies.WithNodeEditPolicy;
import org.eclipse.fordiac.ide.gef.annotation.AnnotableGraphicalEditPart;
import org.eclipse.fordiac.ide.gef.annotation.FordiacAnnotationUtil;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationStyles;
import org.eclipse.fordiac.ide.gef.draw2d.ConnectorBorder;
import org.eclipse.fordiac.ide.gef.figures.InteractionStyleFigure;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotationModelEvent;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;

public class InterfaceEditPart
extends AbstractInterfaceElementEditPart
implements NodeEditPart,
AnnotableGraphicalEditPart {
    protected IFigure createFigure() {
        InterfaceFigure fig = new InterfaceFigure();
        fig.addAncestorListener(this.createAncestorListener());
        return fig;
    }

    protected AncestorListener createAncestorListener() {
        return new AncestorListener(){

            public void ancestorRemoved(IFigure ancestor) {
            }

            public void ancestorMoved(IFigure ancestor) {
                InterfaceEditPart.this.refreshVisuals();
            }

            public void ancestorAdded(IFigure ancestor) {
                InterfaceEditPart.this.refreshVisuals();
            }
        };
    }

    @Override
    protected Adapter createAdapter() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                InterfaceEditPart.this.refresh();
                if (LibraryElementPackage.eINSTANCE.getEvent_With().equals(notification.getFeature())) {
                    InterfaceEditPart.this.refreshTypeRoot();
                }
            }
        };
    }

    public void updateAnnotations(GraphicalAnnotationModelEvent event) {
        GraphicalAnnotationStyles.updateAnnotationFeedback((IFigure)this.getFigure(), (Object)this.getModel(), (GraphicalAnnotationModelEvent)event, (Predicate[])new Predicate[]{FordiacAnnotationUtil::showOnTarget, FordiacAnnotationUtil::showOnTargetName});
        CommentTypeEditPart commentTypeEditPart = this.findAssociatedCommentTypeEP();
        if (commentTypeEditPart != null) {
            commentTypeEditPart.updateAnnotations(event);
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.getCastedModel() instanceof Event && this.sourceConnections != null) {
            for (ConnectionEditPart con : this.sourceConnections) {
                WithEditPart with = (WithEditPart)con;
                with.updateWithPos();
            }
        }
        if (this.getCastedModel() instanceof VarDeclaration && this.getFigure() instanceof InterfaceFigure) {
            ((InterfaceFigure)this.getFigure()).updateConnectorColor();
        }
    }

    @Override
    public IInterfaceElement getCastedModel() {
        return (IInterfaceElement)this.getModel();
    }

    @Override
    public void activate() {
        super.activate();
        this.checkAssociatedCommentType();
        this.refreshTypeRoot();
    }

    @Override
    public boolean isConnectable() {
        return true;
    }

    private void refreshTypeRoot() {
        FBTypeRootEditPart typeRootEP = this.getFBTypeRootEP();
        if (typeRootEP != null) {
            typeRootEP.refresh();
            typeRootEP.getChildren().stream().filter(CommentTypeEditPart.class::isInstance).forEach(ep -> ((CommentTypeEditPart)((Object)ep)).refreshVisuals());
        }
    }

    private FBTypeRootEditPart getFBTypeRootEP() {
        for (Object part : this.getRoot().getChildren()) {
            if (!(part instanceof FBTypeRootEditPart)) continue;
            FBTypeRootEditPart fbtRootEP = (FBTypeRootEditPart)((Object)part);
            return fbtRootEP;
        }
        return null;
    }

    public void setInOutConnectionsWith(int with) {
        PolylineConnection plc;
        IFigure iFigure;
        for (ConnectionEditPart cep : this.getSourceConnections()) {
            iFigure = cep.getFigure();
            if (!(iFigure instanceof PolylineConnection)) continue;
            plc = (PolylineConnection)iFigure;
            plc.setLineWidth(with);
        }
        for (ConnectionEditPart cep : this.getTargetConnections()) {
            iFigure = cep.getFigure();
            if (!(iFigure instanceof PolylineConnection)) continue;
            plc = (PolylineConnection)iFigure;
            plc.setLineWidth(with);
        }
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        if (this.isInterfaceEditable()) {
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeleteInterfaceEditPolicy());
            this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new WithNodeEditPolicy());
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            request.setType((Object)"direct edit");
        }
        super.performRequest(request);
    }

    protected List<With> getModelSourceConnections() {
        if (this.isEvent()) {
            return ((Event)this.getModel()).getWith();
        }
        return Collections.emptyList();
    }

    protected List<With> getModelTargetConnections() {
        if (this.isVariable()) {
            return ((VarDeclaration)this.getModel()).getWiths();
        }
        return Collections.emptyList();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        int pos = InterfaceEditPart.calculateWithPos((With)connection.getModel(), this.isInput());
        if (this.isInput()) {
            return new InputWithAnchor(this.getFigure(), pos, (EditPart)this);
        }
        return new OutputWithAnchor(this.getFigure(), pos, (EditPart)this);
    }

    public static int calculateWithPos(With with, boolean isInput) {
        Event event = (Event)with.eContainer();
        InterfaceList interfaceList = (InterfaceList)event.eContainer();
        if (interfaceList != null) {
            return InterfaceEditPart.getnumEventwith((EList<Event>)(isInput ? interfaceList.getEventInputs() : interfaceList.getEventOutputs()), event);
        }
        return 0;
    }

    protected static int getnumEventwith(EList<Event> eList, Event event) {
        int nrOfEventWITH = 0;
        for (Event ele : eList) {
            if (!ele.getWith().isEmpty()) {
                ++nrOfEventWITH;
            }
            if (ele == event) break;
        }
        return nrOfEventWITH;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getSourceConnectionAnchor(connection);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public Label getNameLabel() {
        return (Label)this.getFigure();
    }

    public INamedElement getINamedElement() {
        return this.getCastedModel();
    }

    private void checkAssociatedCommentType() {
        CommentTypeEditPart ep = this.findAssociatedCommentTypeEP();
        if (ep != null && ep.getReferencedInterface() == null) {
            ep.setupReferencedEP();
        }
    }

    private CommentTypeEditPart findAssociatedCommentTypeEP() {
        return this.getViewer().getEditPartRegistry().values().stream().filter(CommentTypeEditPart.class::isInstance).filter(c -> this.getModel().equals(((CommentTypeEditPart)((Object)c)).getInterfaceElement())).findAny().orElse(null);
    }

    public class InterfaceFigure
    extends Label
    implements InteractionStyleFigure {
        public InterfaceFigure() {
            this.setText(InterfaceEditPart.this.getINamedElement().getName());
            this.setBorder((Border)new ConnectorBorder(InterfaceEditPart.this.getCastedModel()));
            this.setOpaque(false);
            if (InterfaceEditPart.this.isInput()) {
                this.setLabelAlignment(1);
                this.setTextAlignment(1);
            } else {
                this.setLabelAlignment(4);
                this.setTextAlignment(4);
            }
        }

        public int getIntersectionStyle(Point location) {
            if (InterfaceEditPart.this.isInput()) {
                Rectangle bounds = this.getBounds().getCopy();
                bounds.width = 5;
                if (bounds.intersects(new Rectangle(location, new Dimension(1, 1)))) {
                    return 0;
                }
                return 1;
            }
            Rectangle bounds = this.getBounds().getCopy();
            bounds.x += bounds.width - 5;
            bounds.width = 5;
            if (bounds.intersects(new Rectangle(location, new Dimension(1, 1)))) {
                return 0;
            }
            return 1;
        }

        public void updateConnectorColor() {
            Border curBorder = this.getBorder();
            if (curBorder instanceof CompoundBorder) {
                CompoundBorder comBorder = (CompoundBorder)curBorder;
                curBorder = comBorder.getOuterBorder();
            }
            if (curBorder instanceof ConnectorBorder) {
                ConnectorBorder conBorder = (ConnectorBorder)curBorder;
                conBorder.updateColor();
            }
        }
    }
}

