/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement;

import java.net.URI;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.library.model.library.Required;
import org.eclipse.fordiac.ide.library.model.util.ManifestHelper;
import org.eclipse.fordiac.ide.systemmanagement.Messages;
import org.eclipse.fordiac.ide.systemmanagement.changelistener.FordiacResourceChangeListener;
import org.eclipse.fordiac.ide.systemmanagement.nature.FordiacNature;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public enum SystemManager {
    INSTANCE;

    public static final String FORDIAC_PROJECT_NATURE_ID = "org.eclipse.fordiac.ide.systemmanagement.FordiacNature";
    public static final String FORDIAC_EXPORT_BUILDER_ID = "org.eclipse.fordiac.ide.export.builder";
    public static final String FORDIAC_LIBRARY_BUILDER_ID = "org.eclipse.fordiac.ide.library.builder";
    public static final String ROBOT_PROJECT_NATURE_ID = "org.robotframework.ide.eclipse.main.plugin.robotNature";
    public static final String OLD_DISTRIBUTED_PROJECT_NATURE_ID = "org.fordiac.systemManagement.DistributedNature";
    public static final String SYSTEM_FILE_ENDING = "sys";
    public static final String SYSTEM_FILE_ENDING_WITH_DOT = ".sys";
    private final IResourceChangeListener fordiacListener = new FordiacResourceChangeListener();

    private SystemManager() {
        this.addFordiacChangeListener();
    }

    public static boolean isSystemFile(Object entry) {
        IFile file;
        IPath path;
        return entry instanceof IPath && SYSTEM_FILE_ENDING.equalsIgnoreCase((path = (IPath)entry).getFileExtension()) || entry instanceof IFile && SYSTEM_FILE_ENDING.equalsIgnoreCase((file = (IFile)entry).getFileExtension());
    }

    public IProject createNew4diacProject(String projectName, IPath location, Map<Required, URI> includedLibraries, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        HashMap includes = new HashMap();
        includedLibraries.forEach((key, value) -> {
            URI uRI = includes.put(key.getSymbolicName(), value);
        });
        if (!Platform.getLocation().equals((Object)location)) {
            description.setLocation(location);
        }
        description.setNatureIds(SystemManager.getNatureIDs());
        List<ICommand> commands = Stream.of(SystemManager.getBuilderIDs()).map(builder -> {
            ICommand command = description.newCommand();
            command.setBuilderName(builder);
            return command;
        }).toList();
        description.setBuildSpec(commands.toArray(new ICommand[commands.size()]));
        project.create(description, monitor);
        project.open(monitor);
        project.getFolder("Type Library").create(true, true, monitor);
        project.getFolder("Standard Libraries").create(8193, true, monitor);
        project.getFolder("External Libraries").create(8193, true, monitor);
        ManifestHelper.createProjectManifest((IProject)project, includedLibraries.keySet());
        project.refreshLocal(1, monitor);
        return project;
    }

    public static String[] getNatureIDs() {
        return new String[]{FORDIAC_PROJECT_NATURE_ID, "org.eclipse.xtext.ui.shared.xtextNature"};
    }

    private static String[] getBuilderIDs() {
        return new String[]{FORDIAC_LIBRARY_BUILDER_ID, "org.eclipse.xtext.ui.shared.xtextBuilder", FORDIAC_EXPORT_BUILDER_ID};
    }

    public void removeFordiacChangeListener() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fordiacListener);
    }

    public void addFordiacChangeListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fordiacListener);
    }

    public static void validateProjectNature(IProject project) {
        try {
            IProjectNature nature;
            if (project != null && project.isAccessible() && (nature = project.getNature(FORDIAC_PROJECT_NATURE_ID)) instanceof FordiacNature) {
                FordiacNature fordiacNature = (FordiacNature)nature;
                fordiacNature.validate();
            }
        }
        catch (CoreException e) {
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.FordiacSystemManagement_ErrorLoadingProjectNature, e.getMessage()), (Throwable)e);
        }
    }
}

