/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.editors;

import java.util.Objects;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.ui.editors.ISubEditorInput;
import org.eclipse.fordiac.ide.model.ui.editors.SubEditorInputFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class SubEditorInput
extends PlatformObject
implements ISubEditorInput,
IPersistableElement {
    private final IEditorInput parent;
    private final EClass elementClass;
    private final String fragment;

    public SubEditorInput(IEditorInput parent, EClass elementClass, String fragment) {
        this.parent = Objects.requireNonNull(parent);
        this.elementClass = Objects.requireNonNull(elementClass);
        this.fragment = Objects.requireNonNull(fragment);
    }

    public SubEditorInput(IEditorInput parent, EObject subElement) {
        this(parent, subElement.eClass(), SubEditorInput.getFragment(subElement));
    }

    @Override
    public IEditorInput getParent() {
        return this.parent;
    }

    @Override
    public EClass getElementClass() {
        return this.elementClass;
    }

    @Override
    public String getFragment() {
        return this.fragment;
    }

    public String getName() {
        return this.parent.getName() + ":" + this.fragment;
    }

    public String getToolTipText() {
        return this.parent.getToolTipText() + ":" + this.fragment;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.parent.getImageDescriptor();
    }

    public boolean exists() {
        return this.parent.exists();
    }

    public int hashCode() {
        return Objects.hash(this.elementClass, this.fragment, this.parent);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubEditorInput other = (SubEditorInput)obj;
        return Objects.equals(this.elementClass, other.elementClass) && Objects.equals(this.fragment, other.fragment) && Objects.equals(this.parent, other.parent);
    }

    public String toString() {
        return String.format("%s [%s:%s, elementClass=%s]", this.getClass().getName(), this.parent, this.fragment, this.elementClass.getName());
    }

    public IPersistableElement getPersistable() {
        return this.getParent().getPersistable() != null ? this : null;
    }

    public void saveState(IMemento memento) {
        SubEditorInputFactory.saveState(memento, this);
    }

    public String getFactoryId() {
        return "org.eclipse.fordiac.ide.model.ui.editors.SubEditorInputFactory";
    }

    protected static String getFragment(EObject subElement) {
        if (subElement instanceof INamedElement) {
            INamedElement namedElement = (INamedElement)subElement;
            return namedElement.getQualifiedName();
        }
        return EcoreUtil.getURI((EObject)subElement).fragment();
    }
}

