/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.editors;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDataTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStructCommand;
import org.eclipse.fordiac.ide.model.commands.change.ConfigureFBCommand;
import org.eclipse.fordiac.ide.model.commands.change.UpdateFBTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.UpdateInternalFBCommand;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.typelibrary.AdapterTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.AttributeTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.InterfaceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SubAppTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.ui.editors.LibraryElementDependencyTracker;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Display;

public class LibraryElementDependencyUpdater
extends LibraryElementDependencyTracker {
    private LibraryElement libraryElement;
    private boolean updating;

    @Override
    public void notifyChanged(Notification notification) {
        Object object = notification.getNotifier();
        if (object instanceof TypeEntry) {
            TypeEntry dependency = (TypeEntry)object;
            if (this.getDependencies().contains(dependency)) {
                if ("TYPE_ENTRY_FILE_CONTENT_FEATURE".equals(notification.getFeature()) || "TYPE_ENTRY_TYPE_LIBRARY".equals(notification.getFeature())) {
                    Display.getDefault().asyncExec(() -> this.updateDependency(dependency, dependency.getFullTypeName()));
                }
                if ("TYPE_ENTRY_FULL_TYPE_NAME_FEATURE".equals(notification.getFeature())) {
                    Display.getDefault().asyncExec(() -> this.updateDependency(dependency, notification.getOldStringValue()));
                }
            }
        } else {
            super.notifyChanged(notification);
        }
    }

    public void updateDependency(TypeEntry dependency, String fullTypeName) {
        TypeLibrary typeLibrary = this.libraryElement.getTypeLibrary();
        if (typeLibrary == null) {
            return;
        }
        if (this.updating) {
            throw new IllegalStateException("Already updating dependencies for " + String.valueOf(this.libraryElement.getTypeEntry().getFile()));
        }
        try {
            this.updating = true;
            TypeEntry typeEntry = dependency;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AttributeTypeEntry.class, DataTypeEntry.class, AdapterTypeEntry.class, InterfaceTypeEntry.class}, (Object)typeEntry, 0)) {
                case 0: {
                    AttributeTypeEntry attributeTypeEntry = (AttributeTypeEntry)typeEntry;
                    this.updateAttributeDependency(attributeTypeEntry, fullTypeName, typeLibrary);
                    break;
                }
                case 1: {
                    DataTypeEntry dataTypeEntry = (DataTypeEntry)typeEntry;
                    this.updateDataTypeDependency(dataTypeEntry, fullTypeName, typeLibrary);
                    break;
                }
                case 2: {
                    AdapterTypeEntry adapterTypeEntry = (AdapterTypeEntry)typeEntry;
                    this.updateAdapterDependency(adapterTypeEntry, fullTypeName, typeLibrary);
                    break;
                }
                case 3: {
                    InterfaceTypeEntry interfaceTypeEntry = (InterfaceTypeEntry)typeEntry;
                    this.updateBlockDependency(interfaceTypeEntry, fullTypeName, typeLibrary);
                    break;
                }
            }
        }
        finally {
            this.updating = false;
        }
    }

    private void updateAttributeDependency(AttributeTypeEntry dependency, String fullTypeName, TypeLibrary typeLibrary) {
        AttributeTypeEntry entry = typeLibrary.getAttributeTypeEntry(fullTypeName);
        if (entry == null) {
            entry = (AttributeTypeEntry)typeLibrary.createErrorTypeEntry(fullTypeName, dependency.getTypeEClass());
        }
        AttributeDeclaration attributeDeclaration = entry.getType();
        AnyDerivedType attributeDataType = attributeDeclaration.getType();
        TreeIterator contents = this.libraryElement.eAllContents();
        while (contents.hasNext()) {
            EObject eObject;
            Objects.requireNonNull((EObject)contents.next());
            EObject eObject2 = eObject;
            int n = 0;
            block4: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Attribute.class}, (Object)eObject2, n)) {
                    case 0: {
                        Attribute attribute = (Attribute)eObject;
                        if (!LibraryElementDependencyUpdater.matches((LibraryElement)attribute.getAttributeDeclaration(), (TypeEntry)dependency)) {
                            eObject2 = eObject;
                            n = 1;
                            continue block4;
                        }
                        attribute.setAttributeDeclaration(attributeDeclaration);
                        attribute.setType((DataType)attributeDataType);
                        break block4;
                    }
                }
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateDataTypeDependency(DataTypeEntry dependency, String fullTypeName, TypeLibrary typeLibrary) {
        DataType dataType = typeLibrary.getDataTypeLibrary().getType(fullTypeName);
        TreeIterator contents = this.libraryElement.eAllContents();
        while (contents.hasNext()) {
            EObject eObject;
            Objects.requireNonNull((EObject)contents.next());
            EObject eObject2 = eObject;
            int n = 0;
            block8: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Attribute.class, AttributeDeclaration.class, IInterfaceElement.class, StructManipulator.class, ConfigurableFB.class}, (Object)eObject2, n)) {
                    case 0: {
                        Attribute attribute = (Attribute)eObject;
                        if (!LibraryElementDependencyUpdater.matches((LibraryElement)attribute.getType(), (TypeEntry)dependency)) {
                            eObject2 = eObject;
                            n = 1;
                            continue block8;
                        }
                        attribute.setType(dataType);
                        break block8;
                    }
                    case 1: {
                        void derivedType;
                        AttributeDeclaration attributeDeclaration = (AttributeDeclaration)eObject;
                        if (!LibraryElementDependencyUpdater.matches((LibraryElement)attributeDeclaration.getType(), (TypeEntry)dependency) || !(dataType instanceof AnyDerivedType)) {
                            eObject2 = eObject;
                            n = 2;
                            continue block8;
                        }
                        AnyDerivedType anyDerivedType = (AnyDerivedType)dataType;
                        attributeDeclaration.setType((AnyDerivedType)derivedType);
                        break block8;
                    }
                    case 2: {
                        IInterfaceElement interfaceElement = (IInterfaceElement)eObject;
                        if (!LibraryElementDependencyUpdater.matches((LibraryElement)interfaceElement.getType(), (TypeEntry)dependency)) {
                            eObject2 = eObject;
                            n = 3;
                            continue block8;
                        }
                        interfaceElement.setType(dataType);
                        break block8;
                    }
                    case 3: {
                        StructManipulator structManipulator = (StructManipulator)eObject;
                        if (!LibraryElementDependencyUpdater.matches((LibraryElement)structManipulator.getDataType(), (TypeEntry)dependency)) {
                            eObject2 = eObject;
                            n = 4;
                            continue block8;
                        }
                        LibraryElementDependencyUpdater.executeCommand((Command)new ChangeStructCommand(structManipulator, dataType));
                        contents.prune();
                        break block8;
                    }
                    case 4: {
                        ConfigurableFB configurableFB = (ConfigurableFB)eObject;
                        if (!LibraryElementDependencyUpdater.matches((LibraryElement)configurableFB.getDataType(), (TypeEntry)dependency)) {
                            eObject2 = eObject;
                            n = 5;
                            continue block8;
                        }
                        LibraryElementDependencyUpdater.executeCommand((Command)new ConfigureFBCommand(configurableFB, dataType));
                        contents.prune();
                        break block8;
                    }
                }
                break;
            }
        }
    }

    private void updateAdapterDependency(AdapterTypeEntry dependency, String fullTypeName, TypeLibrary typeLibrary) {
        AdapterTypeEntry entry = typeLibrary.getAdapterTypeEntry(fullTypeName);
        if (entry == null) {
            entry = (AdapterTypeEntry)typeLibrary.createErrorTypeEntry(fullTypeName, dependency.getTypeEClass());
        }
        AdapterType adapterType = entry.getType();
        TreeIterator contents = this.libraryElement.eAllContents();
        while (contents.hasNext()) {
            EObject eObject;
            Objects.requireNonNull((EObject)contents.next());
            EObject eObject2 = eObject;
            int n = 0;
            block4: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AdapterDeclaration.class}, (Object)eObject2, n)) {
                    case 0: {
                        AdapterDeclaration adapterDeclaration = (AdapterDeclaration)eObject;
                        if (!LibraryElementDependencyUpdater.matches((LibraryElement)adapterDeclaration.getType(), (TypeEntry)dependency)) {
                            eObject2 = eObject;
                            n = 1;
                            continue block4;
                        }
                        LibraryElementDependencyUpdater.executeCommand((Command)ChangeDataTypeCommand.forDataType((IInterfaceElement)adapterDeclaration, (DataType)adapterType));
                        contents.prune();
                        break block4;
                    }
                }
                break;
            }
        }
    }

    private void updateBlockDependency(InterfaceTypeEntry dependency, String fullTypeName, TypeLibrary typeLibrary) {
        TypeEntry entry;
        InterfaceTypeEntry interfaceTypeEntry = dependency;
        Objects.requireNonNull(interfaceTypeEntry);
        InterfaceTypeEntry interfaceTypeEntry2 = interfaceTypeEntry;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FBTypeEntry.class, SubAppTypeEntry.class}, (Object)interfaceTypeEntry2, 0)) {
            case 0: {
                FBTypeEntry fb = (FBTypeEntry)interfaceTypeEntry2;
                TypeEntry typeEntry = typeLibrary.getFBTypeEntry(fullTypeName);
                break;
            }
            case 1: {
                SubAppTypeEntry subApp = (SubAppTypeEntry)interfaceTypeEntry2;
                TypeEntry typeEntry = typeLibrary.getSubAppTypeEntry(fullTypeName);
                break;
            }
            default: {
                TypeEntry typeEntry = entry = typeLibrary.find(fullTypeName);
            }
        }
        if (entry == null) {
            entry = typeLibrary.createErrorTypeEntry(fullTypeName, dependency.getTypeEClass());
        }
        TreeIterator contents = this.libraryElement.eAllContents();
        while (contents.hasNext()) {
            EObject eObject;
            Objects.requireNonNull((EObject)contents.next());
            EObject eObject2 = eObject;
            int n = 0;
            block9: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FB.class, BlockFBNetworkElement.class}, (Object)eObject2, n)) {
                    case 0: {
                        FB fb = (FB)eObject;
                        if (!LibraryElementDependencyUpdater.matches((LibraryElement)fb.getType(), (TypeEntry)dependency) || fb.eContainingFeature() != LibraryElementPackage.Literals.BASE_FB_TYPE__INTERNAL_FBS) {
                            eObject2 = eObject;
                            n = 1;
                            continue block9;
                        }
                        LibraryElementDependencyUpdater.executeCommand((Command)new UpdateInternalFBCommand(fb, entry));
                        break block9;
                    }
                    case 1: {
                        BlockFBNetworkElement element = (BlockFBNetworkElement)eObject;
                        if (!LibraryElementDependencyUpdater.matches((LibraryElement)element.getType(), (TypeEntry)dependency)) {
                            eObject2 = eObject;
                            n = 2;
                            continue block9;
                        }
                        if (!element.isMapped() || element.getMapping().getFrom() == element) {
                            LibraryElementDependencyUpdater.executeCommand((Command)new UpdateFBTypeCommand(element, entry));
                        }
                        contents.prune();
                        break block9;
                    }
                }
                break;
            }
        }
    }

    private static boolean matches(LibraryElement reference, TypeEntry typeEntry) {
        return reference != null && Objects.equals(reference.getTypeEntry(), typeEntry);
    }

    private static void executeCommand(Command command) {
        if (command.canExecute()) {
            command.execute();
        }
    }

    public void setLibraryElement(LibraryElement libraryElement) {
        if (libraryElement != this.libraryElement) {
            this.uninstall();
            this.libraryElement = libraryElement;
            this.install();
        }
    }

    private void install() {
        if (this.libraryElement != null && !this.libraryElement.eAdapters().contains((Object)this)) {
            this.libraryElement.eAdapters().add((Object)this);
        }
    }

    private void uninstall() {
        if (this.libraryElement != null) {
            this.libraryElement.eAdapters().remove((Object)this);
        }
    }

    @Override
    protected boolean addDependency(TypeEntry typeEntry) {
        if (super.addDependency(typeEntry)) {
            if (!typeEntry.eAdapters().contains((Object)this)) {
                typeEntry.eAdapters().add((Object)this);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean removeDependency(TypeEntry typeEntry) {
        if (super.removeDependency(typeEntry)) {
            typeEntry.eAdapters().remove((Object)this);
            return true;
        }
        return false;
    }
}

