/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.annotation;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotationProvider;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotationProviderDescriptor;

public class GraphicalAnnotationModelManager {
    private static final String GRAPHICAL_ANNOTATION_PROVIDER_EXTENSION_POINT_ID = "org.eclipse.fordiac.ide.model.ui.graphicalAnnotationProvider";
    private static final GraphicalAnnotationModelManager INSTANCE = new GraphicalAnnotationModelManager();
    private final List<GraphicalAnnotationProviderDescriptor> providers = GraphicalAnnotationModelManager.loadProviders();

    public List<GraphicalAnnotationProvider> getProviders(GraphicalAnnotationModel model, Object context) {
        return this.providers.stream().filter(desc -> desc.isEnabled(context)).map(GraphicalAnnotationProviderDescriptor::createProvider).filter(Objects::nonNull).filter(provider -> (Boolean)SafeRunner.run(() -> provider.initialize(model, context))).toList();
    }

    private static List<GraphicalAnnotationProviderDescriptor> loadProviders() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(GRAPHICAL_ANNOTATION_PROVIDER_EXTENSION_POINT_ID);
        return Stream.of(point.getExtensions()).map(IExtension::getConfigurationElements).flatMap(iConfigurationElementArray -> Stream.of(iConfigurationElementArray)).map(GraphicalAnnotationProviderDescriptor::new).toList();
    }

    public static GraphicalAnnotationModelManager getInstance() {
        return INSTANCE;
    }
}

