/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.editparts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.shadows.RectangleDropShadowBorder;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.gef.draw2d.AdvancedLineBorder;
import org.eclipse.fordiac.ide.gef.editparts.AbstractPositionableElementEditPart;
import org.eclipse.fordiac.ide.gef.figures.BorderedRoundedRectangle;
import org.eclipse.fordiac.ide.gef.figures.InteractionStyleFigure;
import org.eclipse.fordiac.ide.gef.listeners.DiagramFontChangeListener;
import org.eclipse.fordiac.ide.gef.listeners.IFontUpdateListener;
import org.eclipse.fordiac.ide.model.libraryElement.Color;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.DeviceType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.Link;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.systemconfiguration.editparts.DeviceInterfaceEditPart;
import org.eclipse.fordiac.ide.systemconfiguration.editparts.ResourceContainer;
import org.eclipse.fordiac.ide.systemconfiguration.editparts.ResourceContainerEditPart;
import org.eclipse.fordiac.ide.systemconfiguration.policies.DeleteDeviceEditPolicy;
import org.eclipse.fordiac.ide.systemconfiguration.policies.DeviceViewLayoutEditPolicy;
import org.eclipse.fordiac.ide.systemconfiguration.policies.SegmentNodeEditPolicy;
import org.eclipse.fordiac.ide.util.ColorHelper;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;

public class DeviceEditPart
extends AbstractPositionableElementEditPart
implements NodeEditPart {
    private ResourceContainer resContainer;
    private DiagramFontChangeListener fontChangeListener;

    DeviceEditPart() {
    }

    public Device getModel() {
        return (Device)super.getModel();
    }

    public void activate() {
        super.activate();
        JFaceResources.getFontRegistry().addListener(this.getFontChangeListener());
    }

    public void deactivate() {
        super.deactivate();
        JFaceResources.getFontRegistry().removeListener(this.getFontChangeListener());
    }

    private IPropertyChangeListener getFontChangeListener() {
        if (this.fontChangeListener == null) {
            this.fontChangeListener = new DiagramFontChangeListener((IFontUpdateListener)this.getFigure());
        }
        return this.fontChangeListener;
    }

    protected Adapter createContentAdapter() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                Object feature = notification.getFeature();
                if (LibraryElementPackage.eINSTANCE.getColorizableElement_Color().equals(feature)) {
                    DeviceEditPart.this.backgroundColorChanged((IFigure)DeviceEditPart.this.getFigure());
                } else {
                    super.notifyChanged(notification);
                    DeviceEditPart.this.refreshChildren();
                    DeviceEditPart.this.refreshTargetConnections();
                }
            }
        };
    }

    public INamedElement getINamedElement() {
        return this.getModel();
    }

    protected PositionableElement getPositionableElement() {
        return this.getModel();
    }

    public DeviceFigure getFigure() {
        return (DeviceFigure)super.getFigure();
    }

    public void refresh() {
        super.refresh();
        this.getFigure().getName().setText(this.getModel().getName());
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (childEditPart instanceof DeviceInterfaceEditPart) {
            this.getFigure().getDataInputs().add(child);
        } else if (childEditPart instanceof ResourceContainerEditPart) {
            this.getFigure().getContentPane().add(child);
        } else {
            super.addChildVisual(childEditPart, index);
        }
    }

    protected void removeChildVisual(EditPart childEditPart) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (childEditPart instanceof DeviceInterfaceEditPart) {
            this.getFigure().getDataInputs().remove(child);
        } else if (childEditPart instanceof ResourceContainerEditPart) {
            this.getFigure().getContentPane().remove(child);
        } else {
            super.removeChildVisual(childEditPart);
        }
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.resContainer = new ResourceContainer((Device)model);
    }

    protected List getModelChildren() {
        ArrayList<ResourceContainer> elements = new ArrayList<ResourceContainer>();
        elements.addAll((Collection<ResourceContainer>)this.getModel().getVarDeclarations());
        elements.add(this.resContainer);
        return elements;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new DeviceViewLayoutEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeleteDeviceEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new SegmentNodeEditPolicy());
    }

    public Label getNameLabel() {
        return this.getFigure().getName();
    }

    protected IFigure createFigureForModel() {
        return new DeviceFigure();
    }

    protected void backgroundColorChanged(IFigure figure) {
        Color fordiacColor = this.getModel().getColor();
        if (fordiacColor == null) {
            fordiacColor = ColorHelper.createRandomColor();
            this.getModel().setColor(fordiacColor);
        }
        this.setColor(figure, fordiacColor);
    }

    public boolean isConnectable() {
        return true;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new DeviceConnectionAnchor((IFigure)this.getFigure().getConnectionReferenceFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new DeviceConnectionAnchor((IFigure)this.getFigure().getConnectionReferenceFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new DeviceConnectionAnchor((IFigure)this.getFigure().getConnectionReferenceFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new DeviceConnectionAnchor((IFigure)this.getFigure().getConnectionReferenceFigure());
    }

    protected List<Link> getModelTargetConnections() {
        return this.getModel().getInConnections();
    }

    private final class DeviceConnectionAnchor
    extends ChopboxAnchor {
        DeviceConnectionAnchor(IFigure owner) {
            super(owner);
        }

        protected Rectangle getBox() {
            Rectangle main = DeviceEditPart.this.getFigure().getConnectionReferenceFigure().getBounds().getCopy();
            Rectangle top = DeviceEditPart.this.getFigure().getName().getBounds();
            main.setHeight(main.height + top.height());
            main.y = top.y();
            return main;
        }
    }

    private class DeviceFigure
    extends Shape
    implements InteractionStyleFigure,
    IFontUpdateListener {
        private static final boolean DEVICE_HAS_OUTER_BORDER = false;
        private final Label instanceNameLabel = new Label();
        private Label typeLabel;
        private final Figure dataInputs = new Figure();
        private Figure contentPane;
        private AdvancedLineBorder upperSeparator;
        private final AdvancedLineBorder lowerSeparator;
        private final RoundedRectangle deviceRectangle = new BorderedRoundedRectangle();

        public int getIntersectionStyle(Point location) {
            if (this.instanceNameLabel.intersects(new Rectangle(location, new Dimension(1, 1)))) {
                return 1;
            }
            return 0;
        }

        public DeviceFigure() {
            this.setLayoutManager((LayoutManager)new ToolbarLayout());
            this.createInstanceNameLabel((Figure)this);
            this.deviceRectangle.setCornerDimensions(new Dimension(6, 6));
            ToolbarLayout bottomLayout = new ToolbarLayout();
            bottomLayout.setStretchMinorAxis(true);
            this.deviceRectangle.setLayoutManager((LayoutManager)bottomLayout);
            this.deviceRectangle.setOutline(false);
            this.deviceRectangle.setBorder((Border)new RectangleDropShadowBorder(6));
            this.add((IFigure)this.deviceRectangle);
            this.createDeviceInfoSection((Figure)this.deviceRectangle);
            ToolbarLayout bottomInputsLayout = new ToolbarLayout(false);
            bottomInputsLayout.setStretchMinorAxis(true);
            this.dataInputs.setLayoutManager((LayoutManager)bottomInputsLayout);
            this.dataInputs.setOpaque(false);
            this.lowerSeparator = new AdvancedLineBorder(4);
            this.dataInputs.setBorder((Border)this.lowerSeparator);
            this.deviceRectangle.add((IFigure)this.dataInputs);
            this.createContentPane(this.deviceRectangle);
            this.setInstanceAndTypeLabelFonts();
        }

        private void createInstanceNameLabel(Figure parent) {
            this.instanceNameLabel.setText(DeviceEditPart.this.getINamedElement().getName());
            this.instanceNameLabel.setTextAlignment(2);
            parent.add((IFigure)this.instanceNameLabel);
        }

        public void setBackgroundColor(org.eclipse.swt.graphics.Color bg) {
            org.eclipse.swt.graphics.Color deviceColor = FigureUtilities.darker((org.eclipse.swt.graphics.Color)bg);
            this.upperSeparator.setColor(deviceColor);
            this.lowerSeparator.setColor(deviceColor);
            super.setBackgroundColor(bg);
        }

        private void createDeviceInfoSection(Figure parent) {
            ToolbarLayout deviceInfoLayout = new ToolbarLayout();
            deviceInfoLayout.setStretchMinorAxis(true);
            Figure deviceInfo = new Figure();
            deviceInfo.setLayoutManager((LayoutManager)deviceInfoLayout);
            DeviceType type = DeviceEditPart.this.getModel().getType();
            String typeName = type != null ? type.getName() : "Type not set!";
            this.typeLabel = new Label(typeName);
            deviceInfo.add((IFigure)this.typeLabel);
            this.typeLabel.setTextAlignment(2);
            this.typeLabel.setBorder((Border)new MarginBorder(0, 0, 10, 0));
            parent.add((IFigure)deviceInfo);
            this.upperSeparator = new AdvancedLineBorder(4);
            deviceInfo.setBorder((Border)this.upperSeparator);
        }

        private void createContentPane(RoundedRectangle container) {
            this.contentPane = new Figure();
            this.contentPane.setLayoutManager((LayoutManager)new ToolbarLayout());
            container.add((IFigure)this.contentPane);
        }

        public Label getName() {
            return this.instanceNameLabel;
        }

        public Figure getConnectionReferenceFigure() {
            return this.deviceRectangle;
        }

        protected void fillShape(Graphics graphics) {
        }

        protected void outlineShape(Graphics graphics) {
        }

        public Figure getDataInputs() {
            return this.dataInputs;
        }

        public Figure getContentPane() {
            return this.contentPane;
        }

        public void updateFonts() {
            this.setInstanceAndTypeLabelFonts();
            this.invalidateTree();
            this.revalidate();
        }

        public void setInstanceAndTypeLabelFonts() {
            this.instanceNameLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.fordiac.ide.preferences.diagramFontDefinition"));
            this.typeLabel.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.fordiac.ide.preferences.diagramFontDefinition"));
        }
    }
}

