/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.FileStore;
import java.nio.file.FileSystemException;
import java.nio.file.Path;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionHolder;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.file.util.BaseFileSystem;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionHolder;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.sftp.client.RawSftpClient;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.client.SftpErrorDataHandler;
import org.apache.sshd.sftp.client.SftpMessage;
import org.apache.sshd.sftp.client.SftpVersionSelector;
import org.apache.sshd.sftp.client.fs.SftpFileStore;
import org.apache.sshd.sftp.client.fs.SftpFileSystemProvider;
import org.apache.sshd.sftp.client.fs.SftpPath;
import org.apache.sshd.sftp.client.impl.AbstractSftpClient;
import org.apache.sshd.sftp.client.impl.SftpPathImpl;
import org.apache.sshd.sftp.common.SftpConstants;

public class SftpFileSystem
extends BaseFileSystem<SftpPath>
implements SessionHolder<ClientSession>,
ClientSessionHolder {
    public static final NavigableSet<String> UNIVERSAL_SUPPORTED_VIEWS = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet((Comparator)String.CASE_INSENSITIVE_ORDER, (Object[])new String[]{"basic", "posix", "owner"}));
    public static final AttributeRepository.AttributeKey<Boolean> OWNED_SESSION = new AttributeRepository.AttributeKey();
    private final String id;
    private final SftpClientFactory factory;
    private final SftpVersionSelector selector;
    private final SftpErrorDataHandler errorDataHandler;
    private SftpClientEnriched sftp;
    private int readBufferSize;
    private int writeBufferSize;
    private final List<FileStore> stores;
    private final AtomicBoolean open = new AtomicBoolean();
    private AtomicReference<ClientSession> clientSession = new AtomicReference();

    public SftpFileSystem(SftpFileSystemProvider provider, String id, ClientSession session, SftpClientFactory factory, SftpVersionSelector selector, SftpErrorDataHandler errorDataHandler) throws IOException {
        this(provider, id, factory, selector, errorDataHandler);
        this.clientSession.set(Objects.requireNonNull(session, "No client session"));
        if (!Boolean.TRUE.equals(session.getAttribute(OWNED_SESSION))) {
            session.addSessionListener(new SessionListener(){

                public void sessionClosed(Session session) {
                    if (SftpFileSystem.this.clientSession.get() == session) {
                        try {
                            SftpFileSystem.this.close();
                        }
                        catch (IOException e) {
                            SftpFileSystem.this.log.warn("sessionClosed({}) [{}] could not close file system properly: {}", new Object[]{session, SftpFileSystem.this, e.toString(), e});
                        }
                    }
                }
            });
        }
        this.init();
    }

    protected SftpFileSystem(SftpFileSystemProvider provider, String id, SftpClientFactory factory, SftpVersionSelector selector, SftpErrorDataHandler errorDataHandler) {
        super((FileSystemProvider)provider);
        this.id = id;
        this.factory = factory != null ? factory : SftpClientFactory.instance();
        this.selector = selector;
        this.errorDataHandler = errorDataHandler;
        this.stores = Collections.singletonList(new SftpFileStore(id, this));
    }

    protected void init() throws IOException {
        this.open.set(true);
    }

    public final SftpVersionSelector getSftpVersionSelector() {
        return this.selector;
    }

    public SftpErrorDataHandler getSftpErrorDataHandler() {
        return this.errorDataHandler;
    }

    public final String getId() {
        return this.id;
    }

    public final int getVersion() {
        try {
            return this.getClientInternal().getVersion();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public SftpFileSystemProvider provider() {
        return (SftpFileSystemProvider)super.provider();
    }

    public List<FileStore> getFileStores() {
        return this.stores;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public void setReadBufferSize(int size) {
        if (size < 256) {
            throw new IllegalArgumentException("Insufficient read buffer size: " + size + ", min.=" + 256);
        }
        this.readBufferSize = size;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(int size) {
        if (size < 256) {
            throw new IllegalArgumentException("Insufficient write buffer size: " + size + ", min.=" + 256);
        }
        this.writeBufferSize = size;
    }

    protected SftpPath create(String root, List<String> names) {
        return new SftpPathImpl(this, root, names);
    }

    public ClientSession getClientSession() {
        return this.clientSession.get();
    }

    public ClientSession getSession() {
        return this.getClientSession();
    }

    protected void setClientSession(ClientSession newSession) {
        this.clientSession.set(newSession);
    }

    protected ClientSession sessionForSftpClient() throws IOException {
        return this.getClientSession();
    }

    public SftpClient getClient() throws IOException {
        return new Wrapper(this.getClientInternal(), this.getSftpErrorDataHandler(), this.getReadBufferSize(), this.getWriteBufferSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SftpClientEnriched getClientInternal() throws IOException {
        SftpFileSystem sftpFileSystem = this;
        synchronized (sftpFileSystem) {
            if (!this.isOpen()) {
                throw new IOException("SftpFileSystem is closed " + (Object)((Object)this));
            }
            SftpClientEnriched client = this.sftp;
            if (client == null || !client.isOpen()) {
                ClientSession session = this.sessionForSftpClient();
                SftpClient inner = this.factory.createSftpClient(session, this.getSftpVersionSelector(), this.getSftpErrorDataHandler());
                this.sftp = client = new SftpClientEnriched(inner, this.getSftpErrorDataHandler(), this.getReadBufferSize(), this.getWriteBufferSize());
            }
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            SftpFileSystem sftpFileSystem = this;
            synchronized (sftpFileSystem) {
                if (this.sftp != null) {
                    this.sftp.close();
                    this.sftp = null;
                }
            }
            SftpFileSystemProvider provider = this.provider();
            String fsId = this.getId();
            SftpFileSystem fs = provider.removeFileSystem(fsId);
            ClientSession session = this.getClientSession();
            if (session != null && Boolean.TRUE.equals(session.getAttribute(OWNED_SESSION))) {
                session.close(true);
            }
            if (fs != null && fs != this) {
                throw new FileSystemException(fsId, fsId, "Mismatched FS instance for id=" + fsId);
            }
        }
    }

    public boolean isOpen() {
        return this.open.get();
    }

    public Set<String> supportedFileAttributeViews() {
        try {
            return this.getClientInternal().supportedFileAttributeViews();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return DefaultUserPrincipalLookupService.INSTANCE;
    }

    public SftpPath getDefaultDir() {
        try {
            return this.getClientInternal().getDefaultDir();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.getClientSession() + "]";
    }

    private class SftpClientEnriched
    extends DelegatingClient {
        private AtomicReference<Set<String>> supportedViews;
        private AtomicReference<SftpPath> defaultDir;

        SftpClientEnriched(SftpClient delegate, SftpErrorDataHandler errorHandler, int readSize, int writeSize) {
            super(delegate, errorHandler, readSize, writeSize);
            this.supportedViews = new AtomicReference();
            this.defaultDir = new AtomicReference();
        }

        Set<String> supportedFileAttributeViews() {
            Set<String> result = this.supportedViews.get();
            if (result == null) {
                if (this.getVersion() >= 4) {
                    TreeSet<String> views = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                    views.addAll(UNIVERSAL_SUPPORTED_VIEWS);
                    views.add("acl");
                    result = Collections.unmodifiableSet(views);
                } else {
                    result = UNIVERSAL_SUPPORTED_VIEWS;
                }
                this.supportedViews.set(result);
            }
            return result;
        }

        SftpPath getDefaultDir() throws IOException {
            SftpPath result = this.defaultDir.get();
            if (result == null) {
                result = (SftpPath)((Object)SftpFileSystem.this.getPath(this.canonicalPath("."), new String[0]));
                this.defaultDir.set(result);
            }
            return result;
        }
    }

    private class Wrapper
    extends DelegatingClient {
        private final AtomicBoolean open;

        Wrapper(SftpClient delegate, SftpErrorDataHandler errorHandler, int readSize, int writeSize) {
            super(delegate, errorHandler, readSize, writeSize);
            this.open = new AtomicBoolean();
            this.open.set(delegate.isOpen());
        }

        @Override
        public boolean isClosing() {
            if (!this.open.get()) {
                return true;
            }
            if (this.delegate.isClosing() || !this.delegate.isOpen()) {
                this.open.set(false);
                return true;
            }
            return false;
        }

        @Override
        public boolean isOpen() {
            return this.open.get() && this.delegate.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.open.set(false);
        }
    }

    public static class DefaultUserPrincipalLookupService
    extends UserPrincipalLookupService {
        public static final DefaultUserPrincipalLookupService INSTANCE = new DefaultUserPrincipalLookupService();

        @Override
        public UserPrincipal lookupPrincipalByName(String name) throws IOException {
            return new DefaultUserPrincipal(name);
        }

        @Override
        public GroupPrincipal lookupPrincipalByGroupName(String group) throws IOException {
            return new DefaultGroupPrincipal(group);
        }
    }

    public static class DefaultGroupPrincipal
    extends DefaultUserPrincipal
    implements GroupPrincipal {
        public DefaultGroupPrincipal(String name) {
            super(name);
        }
    }

    public static class DefaultUserPrincipal
    implements UserPrincipal {
        private final String name;

        public DefaultUserPrincipal(String name) {
            this.name = Objects.requireNonNull(name, "name is null");
        }

        @Override
        public final String getName() {
            return this.name;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultUserPrincipal that = (DefaultUserPrincipal)o;
            return Objects.equals(this.getName(), that.getName());
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.getName());
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }

    private class DelegatingClient
    extends AbstractSftpClient {
        protected final SftpClient delegate;
        private final int readSize;
        private final int writeSize;

        DelegatingClient(SftpClient delegate, SftpErrorDataHandler errorHandler, int readSize, int writeSize) {
            super(errorHandler);
            this.delegate = delegate;
            this.readSize = readSize;
            this.writeSize = writeSize;
        }

        @Override
        public int getVersion() {
            return this.delegate.getVersion();
        }

        public ClientSession getClientSession() {
            return this.delegate.getClientSession();
        }

        public ClientChannel getClientChannel() {
            return this.delegate.getClientChannel();
        }

        @Override
        public NavigableMap<String, byte[]> getServerExtensions() {
            return this.delegate.getServerExtensions();
        }

        @Override
        public Charset getNameDecodingCharset() {
            return this.delegate.getNameDecodingCharset();
        }

        @Override
        public void setNameDecodingCharset(Charset cs) {
            this.delegate.setNameDecodingCharset(cs);
        }

        @Override
        public boolean isClosing() {
            return this.delegate.isClosing();
        }

        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public SftpClient.CloseableHandle open(String path, Collection<SftpClient.OpenMode> options) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("open(" + path + ")[" + options + "] client is closed");
            }
            return this.delegate.open(path, options);
        }

        @Override
        public void close(SftpClient.Handle handle) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("close(" + handle + ") client is closed");
            }
            this.delegate.close(handle);
        }

        @Override
        public void remove(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("remove(" + path + ") client is closed");
            }
            this.delegate.remove(path);
        }

        @Override
        public void rename(String oldPath, String newPath, Collection<SftpClient.CopyMode> options) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("rename(" + oldPath + " => " + newPath + ")[" + options + "] client is closed");
            }
            this.delegate.rename(oldPath, newPath, options);
        }

        @Override
        public int read(SftpClient.Handle handle, long fileOffset, byte[] dst, int dstOffset, int len) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("read(" + handle + "/" + fileOffset + ")[" + dstOffset + "/" + len + "] client is closed");
            }
            return this.delegate.read(handle, fileOffset, dst, dstOffset, len);
        }

        @Override
        public void write(SftpClient.Handle handle, long fileOffset, byte[] src, int srcOffset, int len) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("write(" + handle + "/" + fileOffset + ")[" + srcOffset + "/" + len + "] client is closed");
            }
            this.delegate.write(handle, fileOffset, src, srcOffset, len);
        }

        @Override
        public void mkdir(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("mkdir(" + path + ") client is closed");
            }
            this.delegate.mkdir(path);
        }

        @Override
        public void rmdir(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("rmdir(" + path + ") client is closed");
            }
            this.delegate.rmdir(path);
        }

        @Override
        public SftpClient.CloseableHandle openDir(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("openDir(" + path + ") client is closed");
            }
            return this.delegate.openDir(path);
        }

        @Override
        public List<SftpClient.DirEntry> readDir(SftpClient.Handle handle) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("readDir(" + handle + ") client is closed");
            }
            return this.delegate.readDir(handle);
        }

        @Override
        public Iterable<SftpClient.DirEntry> listDir(SftpClient.Handle handle) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("readDir(" + handle + ") client is closed");
            }
            return this.delegate.listDir(handle);
        }

        @Override
        public String canonicalPath(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("canonicalPath(" + path + ") client is closed");
            }
            return this.delegate.canonicalPath(path);
        }

        @Override
        public SftpClient.Attributes stat(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("stat(" + path + ") client is closed");
            }
            return this.delegate.stat(path);
        }

        @Override
        public SftpClient.Attributes lstat(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("lstat(" + path + ") client is closed");
            }
            return this.delegate.lstat(path);
        }

        @Override
        public SftpClient.Attributes stat(SftpClient.Handle handle) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("stat(" + handle + ") client is closed");
            }
            return this.delegate.stat(handle);
        }

        @Override
        public void setStat(String path, SftpClient.Attributes attributes) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("setStat(" + path + ")[" + attributes + "] client is closed");
            }
            this.delegate.setStat(path, attributes);
        }

        @Override
        public void setStat(SftpClient.Handle handle, SftpClient.Attributes attributes) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("setStat(" + handle + ")[" + attributes + "] client is closed");
            }
            this.delegate.setStat(handle, attributes);
        }

        @Override
        public String readLink(String path) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("readLink(" + path + ") client is closed");
            }
            return this.delegate.readLink(path);
        }

        @Override
        public void symLink(String linkPath, String targetPath) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("symLink(" + linkPath + " => " + targetPath + ") client is closed");
            }
            this.delegate.symLink(linkPath, targetPath);
        }

        @Override
        public List<SftpClient.DirEntry> readDir(SftpClient.Handle handle, AtomicReference<Boolean> eolIndicator) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("readDir(" + handle + ") client is closed");
            }
            return this.delegate.readDir(handle, eolIndicator);
        }

        @Override
        public InputStream read(String path) throws IOException {
            return this.read(path, this.readSize);
        }

        @Override
        public InputStream read(String path, SftpClient.OpenMode ... mode) throws IOException {
            return this.read(path, this.readSize, mode);
        }

        @Override
        public InputStream read(String path, Collection<SftpClient.OpenMode> mode) throws IOException {
            return this.read(path, this.readSize, mode);
        }

        @Override
        public OutputStream write(String path) throws IOException {
            return this.write(path, this.writeSize);
        }

        @Override
        public OutputStream write(String path, SftpClient.OpenMode ... mode) throws IOException {
            return this.write(path, this.writeSize, mode);
        }

        @Override
        public OutputStream write(String path, Collection<SftpClient.OpenMode> mode) throws IOException {
            return this.write(path, this.writeSize, mode);
        }

        @Override
        public void put(Path localFile, String path) throws IOException {
            this.put(localFile, this.writeSize, path);
        }

        @Override
        public void put(InputStream stream, String path) throws IOException {
            this.put(stream, this.writeSize, path);
        }

        @Override
        public void put(Path localFile, String path, SftpClient.OpenMode ... modes) throws IOException {
            this.put(localFile, this.writeSize, path, GenericUtils.of((Enum[])modes));
        }

        @Override
        public void put(InputStream stream, String path, SftpClient.OpenMode ... modes) throws IOException {
            this.put(stream, this.writeSize, path, (Collection<SftpClient.OpenMode>)GenericUtils.of((Enum[])modes));
        }

        @Override
        public void put(Path localFile, String path, Collection<SftpClient.OpenMode> modes) throws IOException {
            this.put(localFile, this.writeSize, path, modes);
        }

        @Override
        public void put(InputStream stream, String path, Collection<SftpClient.OpenMode> modes) throws IOException {
            this.put(stream, this.writeSize, path, modes);
        }

        @Override
        public void link(String linkPath, String targetPath, boolean symbolic) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("link(" + linkPath + " => " + targetPath + "] symbolic=" + symbolic + ": client is closed");
            }
            this.delegate.link(linkPath, targetPath, symbolic);
        }

        @Override
        public void lock(SftpClient.Handle handle, long offset, long length, int mask) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("lock(" + handle + ")[offset=" + offset + ", length=" + length + ", mask=0x" + Integer.toHexString(mask) + "] client is closed");
            }
            this.delegate.lock(handle, offset, length, mask);
        }

        @Override
        public void unlock(SftpClient.Handle handle, long offset, long length) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("unlock" + handle + ")[offset=" + offset + ", length=" + length + "] client is closed");
            }
            this.delegate.unlock(handle, offset, length);
        }

        @Override
        public int send(int cmd, Buffer buffer) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("send(cmd=" + SftpConstants.getCommandMessageName(cmd) + ") client is closed");
            }
            if (this.delegate instanceof RawSftpClient) {
                return ((RawSftpClient)((Object)this.delegate)).send(cmd, buffer);
            }
            throw new StreamCorruptedException("send(cmd=" + SftpConstants.getCommandMessageName(cmd) + ") delegate is not a " + RawSftpClient.class.getSimpleName());
        }

        @Override
        public SftpMessage write(int cmd, Buffer buffer) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("write(cmd=" + SftpConstants.getCommandMessageName(cmd) + ") client is closed");
            }
            if (this.delegate instanceof RawSftpClient) {
                return ((RawSftpClient)((Object)this.delegate)).write(cmd, buffer);
            }
            throw new StreamCorruptedException("write(cmd=" + SftpConstants.getCommandMessageName(cmd) + ") delegate is not a " + RawSftpClient.class.getSimpleName());
        }

        @Override
        public Buffer receive(int id) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("receive(id=" + id + ") client is closed");
            }
            if (this.delegate instanceof RawSftpClient) {
                return ((RawSftpClient)((Object)this.delegate)).receive(id);
            }
            throw new StreamCorruptedException("receive(id=" + id + ") delegate is not a " + RawSftpClient.class.getSimpleName());
        }

        @Override
        public Buffer receive(int id, long timeout) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("receive(id=" + id + ", timeout=" + timeout + ") client is closed");
            }
            if (this.delegate instanceof RawSftpClient) {
                return ((RawSftpClient)((Object)this.delegate)).receive(id, timeout);
            }
            throw new StreamCorruptedException("receive(id=" + id + ", timeout=" + timeout + ") delegate is not a " + RawSftpClient.class.getSimpleName());
        }

        @Override
        public Buffer receive(int id, Duration timeout) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("receive(id=" + id + ", timeout=" + timeout + ") client is closed");
            }
            if (this.delegate instanceof RawSftpClient) {
                return ((RawSftpClient)((Object)this.delegate)).receive(id, timeout);
            }
            throw new StreamCorruptedException("receive(id=" + id + ", timeout=" + timeout + ") delegate is not a " + RawSftpClient.class.getSimpleName());
        }
    }
}

