/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.resource;

import com.google.common.collect.ForwardingMap;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStandardFunction;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCoreRegionString;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCoreRegionStringCollectors;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionStrategy;
import org.eclipse.xtext.util.IAcceptor;

public class STCoreResourceDescriptionStrategy
extends DefaultResourceDescriptionStrategy {
    private static final Logger LOG = Logger.getLogger(STCoreResourceDescriptionStrategy.class);
    public static final String TYPE_URI = STCoreResourceDescriptionStrategy.class.getName() + ".TYPE_URI";
    public static final String SIGNATURE_HASH = STCoreResourceDescriptionStrategy.class.getName() + ".SIGNATURE_HASH";
    public static final String CONTAINER_ECLASS_NAME = STCoreResourceDescriptionStrategy.class.getName() + ".containerEClassName";
    public static final String CONTAINMENT_FEATURE_NAME = STCoreResourceDescriptionStrategy.class.getName() + ".containmentFeatureName";
    public static final String DISPLAY_STRING = STCoreResourceDescriptionStrategy.class.getName() + ".DISPLAY_STRING";
    public static final String PARAMETER_PROPOSAL = STCoreResourceDescriptionStrategy.class.getName() + ".PARAMETER_PROPOSAL";
    public static final String PARAMETER_PROPOSAL_REGIONS = STCoreResourceDescriptionStrategy.class.getName() + ".PARAMETER_PROPOSAL_REGIONS";

    public boolean createEObjectDescriptions(EObject eObject, IAcceptor<IEObjectDescription> acceptor) {
        if (this.getQualifiedNameProvider() == null) {
            return false;
        }
        try {
            QualifiedName qualifiedName = this.getQualifiedNameProvider().getFullyQualifiedName(eObject);
            if (qualifiedName != null) {
                acceptor.accept((Object)EObjectDescription.create((QualifiedName)qualifiedName, (EObject)eObject, this.createLazyUserData(eObject)));
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    protected Map<String, String> createLazyUserData(final EObject eObject) {
        return new ForwardingMap<String, String>(){
            private Map<String, String> delegate;

            protected Map<String, String> delegate() {
                if (this.delegate == null) {
                    HashMap<String, String> userData = new HashMap<String, String>();
                    STCoreResourceDescriptionStrategy.this.fillUserData(eObject, userData);
                    this.delegate = Map.copyOf(userData);
                }
                return this.delegate;
            }
        };
    }

    protected void fillUserData(EObject eObject, Map<String, String> userData) {
        ITypedElement typedElement;
        EObject container = eObject.eContainer();
        if (container != null) {
            userData.put(CONTAINER_ECLASS_NAME, container.eClass().getName());
            userData.put(CONTAINMENT_FEATURE_NAME, eObject.eContainmentFeature().getName());
        } else {
            userData.put(CONTAINER_ECLASS_NAME, "");
            userData.put(CONTAINMENT_FEATURE_NAME, "");
        }
        if (eObject instanceof ICallable) {
            ICallable callable = (ICallable)eObject;
            userData.put(SIGNATURE_HASH, STCoreResourceDescriptionStrategy.computeSignatureHash(callable));
            userData.put(DISPLAY_STRING, callable.getSignature());
            STCoreRegionString regionString = STCoreResourceDescriptionStrategy.getCallableParameterProposal(callable);
            userData.put(PARAMETER_PROPOSAL, regionString.toString());
            userData.put(PARAMETER_PROPOSAL_REGIONS, regionString.getRegions().toString());
        } else if (eObject instanceof ITypedElement && (typedElement = (ITypedElement)eObject).getType() != null) {
            userData.put(TYPE_URI, EcoreUtil.getURI((EObject)typedElement.getType()).toString());
            userData.put(DISPLAY_STRING, STCoreResourceDescriptionStrategy.getTypedElementDisplayString(typedElement));
        }
    }

    public static String computeSignatureHash(ICallable callable) {
        SignatureHashBuilder builder = new SignatureHashBuilder();
        Stream.of(callable.getInputParameters(), callable.getOutputParameters(), callable.getInOutParameters()).flatMap(Collection::stream).forEachOrdered(builder::appendParameter);
        if (callable.getReturnType() != null) {
            builder.appendType((LibraryElement)callable.getReturnType());
        }
        return builder.hash();
    }

    public static int computeParameterHash(INamedElement parameter) {
        if (parameter instanceof ITypedElement) {
            ITypedElement typedElement = (ITypedElement)parameter;
            return Objects.hash(typedElement.getName(), typedElement.getType());
        }
        return parameter.getName().hashCode();
    }

    public static STCoreRegionString getCallableParameterProposal(ICallable callable) {
        STStandardFunction standardFunction;
        if (callable instanceof STStandardFunction && (standardFunction = (STStandardFunction)callable).isVarargs()) {
            return new STCoreRegionString("()");
        }
        return Stream.of(callable.getInputParameters(), callable.getInOutParameters(), callable.getOutputParameters()).flatMap(Collection::stream).map(parameter -> STCoreResourceDescriptionStrategy.getCallableParameterProposal(callable, (INamedElement)parameter)).collect(STCoreRegionStringCollectors.joining(", ", "(", ")"));
    }

    protected static STCoreRegionString getCallableParameterProposal(ICallable callable, INamedElement parameter) {
        if (callable instanceof STStandardFunction) {
            return new STCoreRegionString(STCoreResourceDescriptionStrategy.getCallableParameterDefaultValue(callable, parameter), true);
        }
        return new STCoreRegionString(parameter.getName()).append(callable.getOutputParameters().contains((Object)parameter) ? " => " : " := ").append(STCoreResourceDescriptionStrategy.getCallableParameterDefaultValue(callable, parameter), true);
    }

    protected static String getCallableParameterDefaultValue(ICallable callable, INamedElement parameter) {
        if (callable.getInOutParameters().contains((Object)parameter) || callable.getOutputParameters().contains((Object)parameter)) {
            return "VAR";
        }
        if (parameter instanceof VarDeclaration) {
            VarDeclaration varDeclaration = (VarDeclaration)parameter;
            return STCoreResourceDescriptionStrategy.getCallableParameterTypeDefaultValue((LibraryElement)varDeclaration.getType());
        }
        if (parameter instanceof STVarDeclaration) {
            STVarDeclaration stVarDeclaration = (STVarDeclaration)parameter;
            return STCoreResourceDescriptionStrategy.getCallableParameterTypeDefaultValue((LibraryElement)stVarDeclaration.getType());
        }
        return "";
    }

    protected static String getCallableParameterTypeDefaultValue(LibraryElement type) {
        if (type instanceof AnyDerivedType) {
            return "VAR";
        }
        try {
            return ValueOperations.defaultValue((LibraryElement)type).toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getTypedElementDisplayString(ITypedElement typedElement) {
        return typedElement.getName() + " : " + typedElement.getTypeName();
    }

    protected boolean isResolvedAndExternal(EObject from, EObject to) {
        if (to instanceof LibraryElement) {
            LibraryElement libraryElement = (LibraryElement)to;
            if (!to.eIsProxy() && (libraryElement.getTypeEntry() == null || libraryElement.getTypeEntry().hasError())) {
                return false;
            }
        }
        return super.isResolvedAndExternal(from, to);
    }

    public static class SignatureHashBuilder {
        private final MessageDigest digest = SignatureHashBuilder.createDigest();
        private final StringBuilder builder = new StringBuilder();

        protected static MessageDigest createDigest() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error((Object)"Error creating message digest", (Throwable)e);
                return null;
            }
        }

        protected void append(String s) {
            if (this.digest != null) {
                this.digest.update(s.getBytes(StandardCharsets.UTF_8));
            }
            this.builder.append(s);
        }

        public SignatureHashBuilder appendType(LibraryElement type) {
            if (type != null) {
                this.append(EcoreUtil.getURI((EObject)type).toString());
            }
            return this;
        }

        public SignatureHashBuilder appendParameter(INamedElement parameter) {
            this.append(parameter.getName());
            if (parameter instanceof ITypedElement) {
                ITypedElement typedElement = (ITypedElement)parameter;
                this.appendType(typedElement.getType());
            }
            return this;
        }

        public String hash() {
            if (this.digest != null) {
                try {
                    return new BigInteger(this.digest.digest()).toString(16);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error hashing signature", (Throwable)e);
                }
            }
            return this.builder.toString();
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

