/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.doc.editors;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Base64;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDocumentationCommand;
import org.eclipse.fordiac.ide.model.ui.editors.LibraryElementProvider;
import org.eclipse.fordiac.ide.typeeditor.ITypeEditorPage;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.nebula.widgets.richtext.RichTextEditor;
import org.eclipse.nebula.widgets.richtext.RichTextEditorConfiguration;
import org.eclipse.nebula.widgets.richtext.toolbar.ToolbarButton;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.osgi.framework.Bundle;

public class DescriptionEditor
extends EditorPart
implements ITypeEditorPage {
    private static final String TOOLBAR_GROUP_CONFIGURATION = "[{ name: 'clipboard', groups: [ 'undo', 'clipboard'] },{ name: 'colors' },{ name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },{ name: 'styles' }, { name: 'paragraph', groups: [ 'align', 'list', 'indent' ] },{ name: 'find'},{ name: 'insert' },{ name: 'links' },]";
    private CommandStack commandStack;
    private RichTextEditor editor;
    final Bundle bundle = Platform.getBundle((String)"org.eclipse.fordiac.ide.fbtypeeditor.doc");
    final URL url = this.bundle.getEntry("icon/insert_image.png");

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setInput(input);
        this.setSite((IWorkbenchPartSite)site);
        this.setPartName("Description");
        this.setTitleImage(FordiacImage.ICON_DOCUMENTATION_EDITOR.getImage());
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        if (iWorkbenchPartSite instanceof MultiPageEditorSite) {
            MultiPageEditorSite multiPageEditorSite = (MultiPageEditorSite)iWorkbenchPartSite;
            this.commandStack = (CommandStack)multiPageEditorSite.getMultiPageEditor().getAdapter(CommandStack.class);
        }
    }

    public void dispose() {
        this.commandStack = null;
        super.dispose();
    }

    public boolean isDirty() {
        return LibraryElementProvider.INSTANCE.canSaveLibraryElement(this.getEditorInput());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(parent);
        try {
            this.editor = new RichTextEditor(parent, this.createRichTextEditorConfiguration());
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.editor);
            this.editor.setText(this.getType().getDocumentation());
            this.editor.addModifyListener(e -> {
                if (this.editor != null && this.editor.getText() != null && !this.editor.getText().equals(this.getType().getDocumentation())) {
                    this.executeCommand((Command)new ChangeDocumentationCommand(this.getType(), this.editor.getText()));
                }
            });
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.editor);
            this.editor.setText(this.getType().getDocumentation());
            this.editor.addModifyListener(e -> {
                if (this.editor != null && this.editor.getText() != null && !this.editor.getText().equals(this.getType().getDocumentation())) {
                    this.executeCommand((Command)new ChangeDocumentationCommand(this.getType(), this.editor.getText()));
                }
            });
        }
        catch (SWTError e2) {
            Label errorLabel = new Label(parent, 0);
            errorLabel.setText(e2.getMessage());
            GridDataFactory.swtDefaults().applyTo((Control)errorLabel);
        }
    }

    private RichTextEditorConfiguration createRichTextEditorConfiguration() {
        RichTextEditorConfiguration editorConfig = new RichTextEditorConfiguration();
        editorConfig.setOption("toolbarGroups", (Object)TOOLBAR_GROUP_CONFIGURATION);
        editorConfig.removeDefaultToolbarButton(new String[]{"Flash", "HorizontalRule", "SpecialChar", "Smiley", "PageBreak", "Iframe"});
        editorConfig.setRemoveFormat(false);
        if (!"gtk".equals(SWT.getPlatform())) {
            InsertConvertedImageButton base64ImageInsert = new InsertConvertedImageButton();
            editorConfig.addToolbarButton((ToolbarButton)base64ImageInsert);
        }
        return editorConfig;
    }

    private void executeCommand(Command cmd) {
        if (this.commandStack != null && cmd != null) {
            this.commandStack.execute(cmd);
        }
    }

    public void setFocus() {
        if (this.editor != null && !this.editor.isDisposed()) {
            this.editor.setFocus();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isMarkerTarget(IMarker marker) {
        return false;
    }

    public boolean outlineSelectionChanged(Object selectedElement) {
        return false;
    }

    public void setInput(IEditorInput input) {
        super.setInputWithNotify(input);
    }

    public void reloadType() {
        if (this.editor != null && !this.editor.isDisposed()) {
            this.editor.setText(this.getType().getDocumentation());
        }
    }

    public Object getSelectableObject() {
        return null;
    }

    private class InsertConvertedImageButton
    extends ToolbarButton {
        public InsertConvertedImageButton() {
            super("insert_image", "insert_base64_image", "insert converted image", "insert", DescriptionEditor.this.url);
        }

        public Object execute() {
            this.insertImage();
            return null;
        }

        private void insertImage() {
            FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            String filename = dialog.open();
            if (filename != null) {
                this.insertEncodedBase64Image(new File(filename));
            }
        }

        private void insertEncodedBase64Image(final File image) {
            WorkspaceJob job = new WorkspaceJob("convert image to base64"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        Throwable throwable = null;
                        Object var3_5 = null;
                        try (FileInputStream fileInputStreamReader = new FileInputStream(image);){
                            byte[] bytes = fileInputStreamReader.readAllBytes();
                            String base64 = Base64.getEncoder().encodeToString(bytes);
                            Display.getDefault().asyncExec(() -> ((InsertConvertedImageButton)InsertConvertedImageButton.this).DescriptionEditor.this.editor.insertHTML("<img src= data:image/png;base64," + base64 + ">"));
                            return Status.OK_STATUS;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
                        return Status.CANCEL_STATUS;
                    }
                }
            };
            job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            job.schedule();
        }
    }
}

