/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ltk.core.refactoring.IValidationCheckResultQuery;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.swt.widgets.Shell;

public class ValidationCheckResultQuery
implements IValidationCheckResultQuery {
    private final Shell fParent;
    private final String fTitle;

    public ValidationCheckResultQuery(Shell parent, String title) {
        this.fParent = parent;
        this.fTitle = title;
    }

    public boolean proceed(RefactoringStatus status) {
        Dialog dialog = RefactoringUI.createRefactoringStatusDialog(status, this.fParent, this.fTitle, false);
        int[] result = new int[1];
        Runnable r = () -> {
            int n = dialog.open();
        };
        this.fParent.getDisplay().syncExec(r);
        return result[0] == 0;
    }

    public void stopped(RefactoringStatus status) {
        Runnable r = () -> {
            String message = status.getMessageMatchingSeverity(4);
            MessageDialog.openWarning((Shell)this.fParent, (String)this.fTitle, (String)this.getFullMessage(message));
        };
        this.fParent.getDisplay().syncExec(r);
    }

    private String getFullMessage(String errorMessage) {
        return Messages.format(RefactoringUIMessages.ValidationCheckResultQuery_error_message, errorMessage);
    }
}

