/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.InputPrimitiveEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.OutputPrimitiveEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.figures.TransactionFigure;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.policies.DeleteTransactionEditPolicy;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.policies.TransactionLayoutEditPolicy;
import org.eclipse.fordiac.ide.gef.policies.HighlightEditPolicy;
import org.eclipse.fordiac.ide.model.libraryElement.InputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.Primitive;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class TransactionEditPart
extends AbstractGraphicalEditPart {
    private final Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            TransactionEditPart.this.refresh();
        }
    };

    public void activate() {
        if (!this.isActive()) {
            this.getModel().eAdapters().add((Object)this.adapter);
        }
        super.activate();
    }

    public void deactivate() {
        if (this.isActive()) {
            this.getModel().eAdapters().remove((Object)this.adapter);
        }
        super.deactivate();
    }

    protected IFigure createFigure() {
        return new TransactionFigure();
    }

    public ServiceTransaction getModel() {
        return (ServiceTransaction)super.getModel();
    }

    public OutputPrimitive getPossibleOutputPrimitive(InputPrimitive inputPrimitive) {
        Primitive primitive;
        int index = this.getModelChildren().indexOf(inputPrimitive);
        Assert.isTrue((index >= 0 ? 1 : 0) != 0);
        if (index < this.getModelChildren().size() - 1 && (primitive = this.getModelChildren().get(index + 1)) instanceof OutputPrimitive) {
            return (OutputPrimitive)primitive;
        }
        return null;
    }

    public InputPrimitive getPossibleInputPrimitive(Primitive outputPrimitive) {
        Primitive primitive;
        int index = this.getModelChildren().indexOf(outputPrimitive);
        if (index > 0 && index < this.getModelChildren().size() && (primitive = this.getModelChildren().get(index - 1)) instanceof InputPrimitive) {
            return (InputPrimitive)primitive;
        }
        return null;
    }

    protected List<Primitive> getModelChildren() {
        ServiceTransaction transaction = this.getModel();
        ArrayList<Primitive> primitives = new ArrayList<Primitive>();
        if (transaction.getInputPrimitive() != null) {
            primitives.add((Primitive)transaction.getInputPrimitive());
        }
        if (!transaction.getOutputPrimitive().isEmpty()) {
            primitives.addAll((Collection<Primitive>)transaction.getOutputPrimitive());
        }
        return primitives;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (childEditPart instanceof InputPrimitiveEditPart || childEditPart instanceof OutputPrimitiveEditPart) {
            TransactionFigure thisFigure = (TransactionFigure)this.getFigure();
            IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
            thisFigure.add(child, childEditPart instanceof InputPrimitiveEditPart ? 0 : index);
        }
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (childEditPart instanceof InputPrimitiveEditPart || childEditPart instanceof OutputPrimitiveEditPart) {
            IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
            ((TransactionFigure)this.getFigure()).remove(child);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new TransactionLayoutEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new HighlightEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeleteTransactionEditPolicy());
    }
}

