/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.fb.interpreter.OpSem.EventManager;
import org.eclipse.fordiac.ide.fb.interpreter.OpSem.FBTransaction;
import org.eclipse.fordiac.ide.fb.interpreter.OpSem.Transaction;
import org.eclipse.fordiac.ide.fb.interpreter.api.CoverageCalculator;
import org.eclipse.fordiac.ide.fb.interpreter.api.EventManagerFactory;
import org.eclipse.fordiac.ide.fb.interpreter.api.ExecutionTrace;
import org.eclipse.fordiac.ide.fb.interpreter.api.TransactionFactory;
import org.eclipse.fordiac.ide.fb.interpreter.mm.ServiceSequenceUtils;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.CreateServiceSequenceCommand;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.commands.Command;

public class CreateRecordedServiceSequenceCommand
extends Command {
    private final FBType fbType;
    private final ServiceSequence oldSequence;
    private CreateServiceSequenceCommand cmd;
    private final List<String> events;
    private final List<List<String>> parameters;
    private final boolean forceOverwrite;
    private String startState = null;
    private boolean traceInfo = false;
    private ServiceSequence newSequence;
    private EventManager eventManager;

    public CreateRecordedServiceSequenceCommand(FBType fbType, List<String> events, List<List<String>> parameters) {
        this(fbType, null, events, parameters);
    }

    public CreateRecordedServiceSequenceCommand(FBType fbType, ServiceSequence sequence, List<String> events, List<List<String>> parameters) {
        this(fbType, sequence, events, parameters, false);
    }

    public CreateRecordedServiceSequenceCommand(FBType fbType, ServiceSequence sequence, List<String> events, List<List<String>> parameters, boolean forceOverwrite) {
        this.fbType = Objects.requireNonNull(fbType);
        this.oldSequence = sequence;
        this.events = events;
        this.parameters = parameters;
        this.forceOverwrite = forceOverwrite;
    }

    public void setStartState(String startState) {
        if (this.fbType instanceof BasicFBType) {
            this.startState = startState;
        }
    }

    public void enableTraceInfo(boolean traceInfo) {
        this.traceInfo = traceInfo;
    }

    public boolean canExecute() {
        if (this.oldSequence != null) {
            return this.fbType.equals(this.oldSequence.getService().getFBType());
        }
        return true;
    }

    public void execute() {
        if (this.cmd != null) {
            this.cmd.execute();
        }
        try {
            this.runInterpreter();
            if (this.oldSequence != null && !this.forceOverwrite) {
                this.newSequence = (ServiceSequence)EcoreUtil.copy((EObject)this.oldSequence);
                this.startState = this.oldSequence.getStartState();
            } else {
                this.cmd = new CreateServiceSequenceCommand(this.fbType.getService());
                this.cmd.execute();
                this.newSequence = this.cmd.getCreatedElement();
            }
            this.updateSequences(this.oldSequence, this.newSequence);
            List<String> parameter = this.parameters.stream().map(CreateRecordedServiceSequenceCommand::sumParameter).toList();
            ServiceSequenceUtils.convertEventManagerToServiceModel((ServiceSequence)this.newSequence, (FBType)this.fbType, (EventManager)this.eventManager, parameter);
            this.newSequence.setStartState(this.startState);
            if (this.traceInfo) {
                this.newSequence.setComment("Coverage: " + CoverageCalculator.calculateCoverageOfSequence((List)this.eventManager.getTransactions(), (FBType)this.fbType));
            }
        }
        catch (Exception e) {
            FordiacLogHelper.logWarning((String)("interpreter could not execute: " + e.getMessage()));
        }
    }

    private void updateSequences(ServiceSequence toRemove, ServiceSequence toAdd) {
        if (toRemove != null) {
            this.fbType.getService().getServiceSequence().remove((Object)toRemove);
        }
        if (toAdd != null) {
            this.fbType.getService().getServiceSequence().add((Object)toAdd);
        }
    }

    public void undo() {
        this.updateSequences(this.newSequence, this.oldSequence);
    }

    public void redo() {
        this.updateSequences(this.oldSequence, this.newSequence);
    }

    private void runInterpreter() {
        List eventPins = ServiceSequenceUtils.getEvents((FBType)this.fbType, this.events);
        this.eventManager = EventManagerFactory.createFrom((List)eventPins, (FBType)((FBType)EcoreUtil.copy((EObject)this.fbType)));
        int i = 0;
        while (i < this.parameters.size()) {
            if (i < this.eventManager.getTransactions().size()) {
                CreateRecordedServiceSequenceCommand.setParameters((FBTransaction)this.eventManager.getTransactions().get(i), this.parameters.get(i));
            }
            ++i;
        }
        TransactionFactory.setStartState((Transaction)((Transaction)this.eventManager.getTransactions().getFirst()), (String)this.startState);
        if (this.traceInfo) {
            TransactionFactory.addTraceInfoTo((EList)this.eventManager.getTransactions());
        }
        this.eventManager.process();
    }

    private static String sumParameter(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s);
            sb.append(";");
        }
        return sb.toString();
    }

    private static void setParameters(FBTransaction transaction, List<String> parameters) {
        ArrayList<VarDeclaration> paramVars = new ArrayList<VarDeclaration>();
        for (String s : parameters) {
            VarDeclaration varDecl = LibraryElementFactory.eINSTANCE.createVarDeclaration();
            List param = ServiceSequenceUtils.splitParameter((String)s);
            if (param.size() == 2) {
                varDecl.setName((String)param.get(0));
                varDecl.setValue(LibraryElementFactory.eINSTANCE.createValue());
                varDecl.getValue().setValue((String)param.get(1));
            }
            paramVars.add(varDecl);
        }
        transaction.getInputVariables().addAll(paramVars);
    }

    public ExecutionTrace getTraceInfo() {
        if (this.eventManager == null) {
            this.runInterpreter();
        }
        return ExecutionTrace.of((EventManager)this.eventManager);
    }
}

