/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands;

import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands.AbstractCreateElementCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.Service;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;

public class CreateOutputPrimitiveCommand
extends AbstractCreateElementCommand<OutputPrimitive> {
    private final boolean isLeftInterface;
    private final ServiceTransaction transaction;

    public CreateOutputPrimitiveCommand(ServiceTransaction transaction, boolean isLeftInterface) {
        super(transaction.getOutputPrimitive());
        this.isLeftInterface = isLeftInterface;
        this.transaction = transaction;
    }

    public CreateOutputPrimitiveCommand(ServiceTransaction transaction, OutputPrimitive refElement, boolean isLeftInterface) {
        super(transaction.getOutputPrimitive(), refElement);
        this.isLeftInterface = isLeftInterface;
        this.transaction = transaction;
    }

    public CreateOutputPrimitiveCommand(ServiceTransaction transaction, int index, boolean isLeftInterface) {
        super(transaction.getOutputPrimitive(), index);
        this.isLeftInterface = isLeftInterface;
        this.transaction = transaction;
    }

    @Override
    protected OutputPrimitive createNewElement() {
        Service service = this.transaction.getServiceSequence().getService();
        OutputPrimitive newOutputPrimitive = LibraryElementFactory.eINSTANCE.createOutputPrimitive();
        FBType fb = service.getFBType();
        String event = fb.getInterfaceList().getEventOutputs().isEmpty() ? Messages.CreateOutputPrimitiveCommand_NotAvailable : ((Event)fb.getInterfaceList().getEventOutputs().get(0)).getName();
        newOutputPrimitive.setEvent(event);
        if (this.isLeftInterface) {
            newOutputPrimitive.setInterface(service.getLeftInterface());
        } else {
            newOutputPrimitive.setInterface(service.getRightInterface());
        }
        return newOutputPrimitive;
    }
}

