/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.commands;

import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.gef.commands.Command;

public class ChangeServiceInterfaceNameCommand
extends Command {
    private final FBType fb;
    private final boolean isLeftInterface;
    private final String name;
    private String oldName;

    public ChangeServiceInterfaceNameCommand(String name, FBType fb, boolean isLeftInterface) {
        this.fb = fb;
        this.isLeftInterface = isLeftInterface;
        this.name = name;
    }

    public void execute() {
        if (this.fb.getService() == null) {
            this.fb.setService(LibraryElementFactory.eINSTANCE.createService());
        }
        if (this.isLeftInterface) {
            if (this.fb.getService().getLeftInterface() == null) {
                this.fb.getService().setLeftInterface(LibraryElementFactory.eINSTANCE.createServiceInterface());
                this.oldName = "";
            } else {
                this.oldName = this.fb.getService().getLeftInterface().getName();
            }
        } else if (this.fb.getService().getRightInterface() == null) {
            this.fb.getService().setRightInterface(LibraryElementFactory.eINSTANCE.createServiceInterface());
            this.oldName = "";
        } else {
            this.oldName = this.fb.getService().getRightInterface().getName();
        }
        this.setName(this.name);
    }

    public void undo() {
        this.setName(this.oldName);
    }

    public void redo() {
        this.setName(this.name);
    }

    private void setName(String name) {
        if (this.isLeftInterface) {
            this.fb.getService().getLeftInterface().setName(name);
        } else {
            this.fb.getService().getRightInterface().setName(name);
        }
    }
}

