/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.preserveorder.ModelOrderNodeComparator;
import org.eclipse.elk.alg.layered.intermediate.preserveorder.ModelOrderPortComparator;
import org.eclipse.elk.alg.layered.options.GroupOrderStrategy;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.LongEdgeOrderingStrategy;
import org.eclipse.elk.alg.layered.options.OrderingStrategy;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class SortByInputModelProcessor
implements ILayoutProcessor<LGraph> {
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Sort By Input Model " + String.valueOf(graph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_STRATEGY)), 1.0f);
        int layerIndex = 0;
        for (Layer layer : graph) {
            layer.id = layerIndex;
            int previousLayerIndex = layerIndex == 0 ? 0 : layerIndex - 1;
            Layer previousLayer = graph.getLayers().get(previousLayerIndex);
            ModelOrderNodeComparator comparator = new ModelOrderNodeComparator(graph, previousLayer, (OrderingStrategy)((Object)graph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_STRATEGY)), (LongEdgeOrderingStrategy)((Object)graph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_LONG_EDGE_STRATEGY)), (GroupOrderStrategy)((Object)graph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_GROUP_MODEL_ORDER_CM_GROUP_ORDER_STRATEGY)), true);
            SortByInputModelProcessor.insertionSort(layer.getNodes(), comparator);
            for (LNode node : layer.getNodes()) {
                if (node.getProperty(LayeredOptions.PORT_CONSTRAINTS) == PortConstraints.FIXED_ORDER || node.getProperty(LayeredOptions.PORT_CONSTRAINTS) == PortConstraints.FIXED_POS) continue;
                Collections.sort(node.getPorts(), new ModelOrderPortComparator(graph, previousLayer, (OrderingStrategy)((Object)graph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_STRATEGY)), SortByInputModelProcessor.longEdgeTargetNodePreprocessing(node), (boolean)((Boolean)graph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_PORT_MODEL_ORDER))));
                progressMonitor.log((Object)("Node " + String.valueOf((Object)node) + " ports: " + String.valueOf(node.getPorts())));
            }
            comparator = new ModelOrderNodeComparator(graph, previousLayer, (OrderingStrategy)((Object)graph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_STRATEGY)), (LongEdgeOrderingStrategy)((Object)graph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_LONG_EDGE_STRATEGY)), (GroupOrderStrategy)((Object)graph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_GROUP_MODEL_ORDER_CM_GROUP_ORDER_STRATEGY)), false);
            SortByInputModelProcessor.insertionSort(layer.getNodes(), comparator);
            progressMonitor.log((Object)("Layer " + layerIndex + ": " + String.valueOf(layer)));
            ++layerIndex;
        }
        progressMonitor.done();
    }

    public static Map<LNode, Integer> longEdgeTargetNodePreprocessing(LNode node) {
        HashMap<LNode, Integer> targetNodeModelOrder = new HashMap<LNode, Integer>();
        if (node.hasProperty(InternalProperties.TARGET_NODE_MODEL_ORDER)) {
            return (Map)node.getProperty(InternalProperties.TARGET_NODE_MODEL_ORDER);
        }
        node.getPorts().stream().filter(p -> !p.getOutgoingEdges().isEmpty()).forEach(p -> {
            LNode targetNode = SortByInputModelProcessor.getTargetNode(p);
            p.setProperty(InternalProperties.LONG_EDGE_TARGET_NODE, (Object)targetNode);
            if (targetNode != null) {
                LEdge edge;
                int previousOrder = Integer.MAX_VALUE;
                if (targetNodeModelOrder.containsKey((Object)targetNode)) {
                    previousOrder = (Integer)targetNodeModelOrder.get((Object)targetNode);
                }
                if (!((Boolean)(edge = p.getOutgoingEdges().get(0)).getProperty(InternalProperties.REVERSED)).booleanValue()) {
                    targetNodeModelOrder.put(targetNode, Math.min((Integer)edge.getProperty(InternalProperties.MODEL_ORDER), previousOrder));
                }
            }
        });
        node.setProperty(InternalProperties.TARGET_NODE_MODEL_ORDER, targetNodeModelOrder);
        return targetNodeModelOrder;
    }

    public static LNode getTargetNode(LPort port) {
        LNode node = null;
        LEdge edge = port.getOutgoingEdges().get(0);
        do {
            if ((node = edge.getTarget().getNode()).hasProperty(InternalProperties.LONG_EDGE_TARGET)) {
                return ((LPort)((Object)node.getProperty(InternalProperties.LONG_EDGE_TARGET))).getNode();
            }
            if (node.getType() != LNode.NodeType.NORMAL && node.getOutgoingEdges().iterator().hasNext()) {
                edge = node.getOutgoingEdges().iterator().next();
                continue;
            }
            if (node.getType() == LNode.NodeType.NORMAL) continue;
            return null;
        } while (node != null && node.getType() != LNode.NodeType.NORMAL);
        return node;
    }

    public static void insertionSort(List<LNode> layer, ModelOrderNodeComparator comparator) {
        int i = 1;
        while (i < layer.size()) {
            LNode temp = layer.get(i);
            int j = i;
            while (j > 0 && comparator.compare(layer.get(j - 1), temp) > 0) {
                layer.set(j, layer.get(j - 1));
                --j;
            }
            layer.set(j, temp);
            ++i;
        }
        comparator.clearTransitiveOrdering();
    }

    public static void insertionSortPort(List<LPort> layer, ModelOrderPortComparator comparator) {
        int i = 1;
        while (i < layer.size()) {
            LPort temp = layer.get(i);
            int j = i;
            while (j > 0 && comparator.compare(layer.get(j - 1), temp) > 0) {
                layer.set(j, layer.get(j - 1));
                --j;
            }
            layer.set(j, temp);
            ++i;
        }
        comparator.clearTransitiveOrdering();
    }
}

