/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng.st;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.export.ExportException;
import org.eclipse.fordiac.ide.export.forte_ng.st.StructuredTextSupport;
import org.eclipse.fordiac.ide.export.forte_ng.util.ForteNgExportUtil;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STArrayAccessExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STAssignment;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBinaryExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBuiltinFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCaseStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STContinue;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STDateAndTimeLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STDateLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExit;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STForStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STIfStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STMemberAccessExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STMultibitPartialExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STNop;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STNumericLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STRepeatStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STReturn;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStringLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STTimeLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STTimeOfDayLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STUnaryExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarInOutDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarInputDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarOutputDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarPlainDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarTempDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STWhileStatement;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunction;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunctionSource;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@FinalFieldsConstructor
public class STFunctionSupport
extends StructuredTextSupport {
    private final STFunctionSource source;
    private STFunction currentFunction;

    public boolean prepare() {
        return true;
    }

    public CharSequence generate(Map<?, ?> options) throws ExportException {
        CharSequence _xblockexpression = null;
        this.prepare();
        CharSequence _xifexpression = null;
        Object _get = options.get("header");
        boolean _equals = Objects.equals(_get, Boolean.TRUE);
        _xifexpression = _equals ? this.generateStructuredTextFunctionSourceHeader(this.source) : this.generateStructuredTextFunctionSourceImpl(this.source);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private CharSequence generateStructuredTextFunctionSourceHeader(STFunctionSource source) {
        StringBuilder _xblockexpression = null;
        StringBuilder result = new StringBuilder();
        EList _functions = source.getFunctions();
        Iterator iterator = _functions.iterator();
        while (iterator.hasNext()) {
            STFunction function;
            this.currentFunction = function = (STFunction)iterator.next();
            result.append(this.generateStructuredTextFunctionHeader(function));
            this.currentFunction = null;
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    private CharSequence generateStructuredTextFunctionSourceImpl(STFunctionSource source) {
        StringBuilder _xblockexpression = null;
        StringBuilder result = new StringBuilder();
        EList _functions = source.getFunctions();
        Iterator iterator = _functions.iterator();
        while (iterator.hasNext()) {
            STFunction function;
            this.currentFunction = function = (STFunction)iterator.next();
            result.append(this.generateStructuredTextFunctionImpl(function));
            this.currentFunction = null;
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    private CharSequence generateStructuredTextFunctionHeader(STFunction func) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateStructuredTextFunctionDeclaration = this.generateStructuredTextFunctionDeclaration(func);
        _builder.append((Object)_generateStructuredTextFunctionDeclaration);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence generateStructuredTextFunctionImpl(STFunction func) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateStructuredTextFunctionDeclaration = this.generateStructuredTextFunctionDeclaration(func);
        _builder.append((Object)_generateStructuredTextFunctionDeclaration);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateStructuredTextFunctionBody = this.generateStructuredTextFunctionBody(func);
        _builder.append((Object)_generateStructuredTextFunctionBody, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateStructuredTextFunctionDeclaration(STFunction func) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _elvis = null;
        DataType _returnType = func.getReturnType();
        CharSequence _generateTypeName = null;
        if (_returnType != null) {
            _generateTypeName = ForteNgExportUtil.generateTypeName((LibraryElement)_returnType);
        }
        _elvis = _generateTypeName != null ? _generateTypeName : "void";
        _builder.append((Object)_elvis);
        _builder.append(" func_");
        String _name = func.getName();
        _builder.append(_name);
        _builder.append("(");
        CharSequence _generateStructuredTextFunctionParameters = this.generateStructuredTextFunctionParameters(func);
        _builder.append((Object)_generateStructuredTextFunctionParameters);
        _builder.append(")");
        return _builder;
    }

    private CharSequence generateStructuredTextFunctionParameters(STFunction func) {
        StringConcatenation _builder = new StringConcatenation();
        Iterable<STVarDeclaration> _structuredTextFunctionParameters = this.getStructuredTextFunctionParameters(func);
        boolean _hasElements = false;
        for (STVarDeclaration param : _structuredTextFunctionParameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _generateParameterTypeName = this.generateParameterTypeName(param);
            _builder.append((Object)_generateParameterTypeName);
            CharSequence _generateParameterName = this.generateParameterName(param);
            _builder.append((Object)_generateParameterName);
        }
        return _builder;
    }

    private Iterable<STVarDeclaration> getStructuredTextFunctionParameters(STFunction func) {
        Functions.Function1 _function = it -> it.getVarDeclarations();
        Iterable _flatMap = IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)func.getVarDeclarations(), STVarInputDeclarationBlock.class), (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> it.getVarDeclarations();
        Iterable _flatMap_1 = IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)func.getVarDeclarations(), STVarInOutDeclarationBlock.class), (Functions.Function1)_function_1);
        Iterable _plus = Iterables.concat((Iterable)_flatMap, (Iterable)_flatMap_1);
        Functions.Function1 _function_2 = it -> it.getVarDeclarations();
        Iterable _flatMap_2 = IterableExtensions.flatMap((Iterable)Iterables.filter((Iterable)func.getVarDeclarations(), STVarOutputDeclarationBlock.class), (Functions.Function1)_function_2);
        return Iterables.concat((Iterable)_plus, (Iterable)_flatMap_2);
    }

    private CharSequence generateStructuredTextFunctionBody(STFunction func) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateOutputGuard = this.generateOutputGuard(Iterables.filter((Iterable)func.getVarDeclarations(), STVarOutputDeclarationBlock.class));
        _builder.append((Object)_generateOutputGuard);
        _builder.newLineIfNotEmpty();
        DataType _returnType = func.getReturnType();
        boolean bl = _tripleNotEquals = _returnType != null;
        if (_tripleNotEquals) {
            CharSequence _generateTypeName = ForteNgExportUtil.generateTypeName((LibraryElement)func.getReturnType());
            _builder.append((Object)_generateTypeName);
            _builder.append(" st_ret_val = ");
            CharSequence _generateTypeDefaultValue = this.generateTypeDefaultValue((INamedElement)func.getReturnType());
            _builder.append((Object)_generateTypeDefaultValue);
            _builder.append(";");
        }
        _builder.newLineIfNotEmpty();
        CharSequence _generateVariables = this.generateVariables(Iterables.filter((Iterable)func.getVarDeclarations(), STVarOutputDeclarationBlock.class), false);
        _builder.append((Object)_generateVariables);
        _builder.newLineIfNotEmpty();
        CharSequence _generateVariables_1 = this.generateVariables(Iterables.filter((Iterable)func.getVarDeclarations(), STVarPlainDeclarationBlock.class), true);
        _builder.append((Object)_generateVariables_1);
        _builder.newLineIfNotEmpty();
        CharSequence _generateVariables_2 = this.generateVariables(Iterables.filter((Iterable)func.getVarDeclarations(), STVarTempDeclarationBlock.class), true);
        _builder.append((Object)_generateVariables_2);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateStatementList = this.generateStatementList((List<STStatement>)func.getCode());
        _builder.append((Object)_generateStatementList);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        DataType _returnType_1 = func.getReturnType();
        boolean bl2 = _tripleNotEquals_1 = _returnType_1 != null;
        if (_tripleNotEquals_1) {
            _builder.append("return st_ret_val;");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Override
    protected CharSequence _generateStatement(STReturn stmt) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("return");
        DataType _returnType = this.currentFunction.getReturnType();
        boolean bl = _tripleNotEquals = _returnType != null;
        if (_tripleNotEquals) {
            _builder.append(" st_ret_val");
        }
        _builder.append(";");
        return _builder;
    }

    @Override
    protected CharSequence _generateExpression(STFeatureExpression expr) {
        CharSequence _xifexpression = null;
        _xifexpression = expr.getFeature() == this.currentFunction && !expr.isCall() ? "st_ret_val" : super._generateExpression(expr);
        return _xifexpression;
    }

    public Set<INamedElement> getDependencies(Map<?, ?> options) {
        Set _xblockexpression = null;
        this.prepare();
        Set _xifexpression = null;
        Object _get = options.get("header");
        boolean _equals = Objects.equals(_get, Boolean.TRUE);
        if (_equals) {
            Functions.Function1 _function = it -> it.getReturnType();
            Iterable _filterNull = IterableExtensions.filterNull((Iterable)ListExtensions.map((List)this.source.getFunctions(), (Functions.Function1)_function));
            Functions.Function1 _function_1 = it -> it.getVarDeclarations();
            Functions.Function1 _function_2 = it -> it.getVarDeclarations();
            Functions.Function1 _function_3 = it -> this.getParameterDependencies((STVarDeclaration)it);
            Iterable _flatMap = IterableExtensions.flatMap((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.flatMap((Iterable)this.source.getFunctions(), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
            _xifexpression = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)_filterNull, (Iterable)_flatMap));
        } else {
            _xifexpression = this.getContainedDependencies((EObject)this.source);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    @XbaseGenerated
    protected CharSequence generateStatement(STStatement stmt) {
        if (stmt instanceof STCaseStatement) {
            return this._generateStatement((STCaseStatement)stmt);
        }
        if (stmt instanceof STContinue) {
            return this._generateStatement((STContinue)stmt);
        }
        if (stmt instanceof STExit) {
            return this._generateStatement((STExit)stmt);
        }
        if (stmt instanceof STExpression) {
            return this._generateStatement((STExpression)stmt);
        }
        if (stmt instanceof STForStatement) {
            return this._generateStatement((STForStatement)stmt);
        }
        if (stmt instanceof STIfStatement) {
            return this._generateStatement((STIfStatement)stmt);
        }
        if (stmt instanceof STNop) {
            return this._generateStatement((STNop)stmt);
        }
        if (stmt instanceof STRepeatStatement) {
            return this._generateStatement((STRepeatStatement)stmt);
        }
        if (stmt instanceof STReturn) {
            return this._generateStatement((STReturn)stmt);
        }
        if (stmt instanceof STWhileStatement) {
            return this._generateStatement((STWhileStatement)stmt);
        }
        if (stmt != null) {
            return this._generateStatement(stmt);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stmt).toString());
    }

    @Override
    @XbaseGenerated
    protected CharSequence generateExpression(STExpression expr) {
        if (expr instanceof STArrayAccessExpression) {
            return this._generateExpression((STArrayAccessExpression)expr);
        }
        if (expr instanceof STAssignment) {
            return this._generateExpression((STAssignment)expr);
        }
        if (expr instanceof STBinaryExpression) {
            return this._generateExpression((STBinaryExpression)expr);
        }
        if (expr instanceof STBuiltinFeatureExpression) {
            return this._generateExpression((STBuiltinFeatureExpression)expr);
        }
        if (expr instanceof STDateAndTimeLiteral) {
            return this._generateExpression((STDateAndTimeLiteral)expr);
        }
        if (expr instanceof STDateLiteral) {
            return this._generateExpression((STDateLiteral)expr);
        }
        if (expr instanceof STFeatureExpression) {
            return this._generateExpression((STFeatureExpression)expr);
        }
        if (expr instanceof STMemberAccessExpression) {
            return this._generateExpression((STMemberAccessExpression)expr);
        }
        if (expr instanceof STMultibitPartialExpression) {
            return this._generateExpression((STMultibitPartialExpression)expr);
        }
        if (expr instanceof STNumericLiteral) {
            return this._generateExpression((STNumericLiteral)expr);
        }
        if (expr instanceof STStringLiteral) {
            return this._generateExpression((STStringLiteral)expr);
        }
        if (expr instanceof STTimeLiteral) {
            return this._generateExpression((STTimeLiteral)expr);
        }
        if (expr instanceof STTimeOfDayLiteral) {
            return this._generateExpression((STTimeOfDayLiteral)expr);
        }
        if (expr instanceof STUnaryExpression) {
            return this._generateExpression((STUnaryExpression)expr);
        }
        if (expr != null) {
            return this._generateExpression(expr);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expr).toString());
    }

    public STFunctionSupport(STFunctionSource source) {
        this.source = source;
    }
}

