/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.widgets;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.ui.widgets.BreadcrumbWidget;
import org.eclipse.fordiac.ide.model.ui.widgets.ChildrenSortComparator;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;

public class BreadcrumbItem {
    private static final int SHELL_WIDTH = 250;
    private static final int SHELL_HEIGHT = 250;
    private final AdapterFactoryLabelProvider labelProvider;
    private final ITreeContentProvider contentProvider;
    private final Object current;
    private final ToolItem text;
    private ToolItem arrow;
    private final BreadcrumbWidget parent;
    private Shell shell;

    BreadcrumbItem(BreadcrumbWidget parent, final Object current, AdapterFactoryLabelProvider labelProvider, AdapterFactoryContentProvider contentProvider) {
        this.current = current;
        this.parent = parent;
        this.labelProvider = labelProvider;
        this.contentProvider = new FilteredBreadCrumbContentProvider(contentProvider);
        this.text = new ToolItem(parent.getToolBar(), 8);
        this.text.setText(labelProvider.getText(current));
        this.text.setImage(labelProvider.getImage(current));
        this.text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                BreadcrumbItem.this.updateBreadcrumb(current);
            }
        });
        if (this.contentProvider.hasChildren(current)) {
            this.arrow = new ToolItem(parent.getToolBar(), 8);
            this.arrow.setImage(new BreadcrumbArrowDescriptor().createImage());
            this.arrow.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    BreadcrumbItem.this.openShell();
                }
            });
        }
    }

    public Object getModel() {
        return this.current;
    }

    public String getText() {
        return this.labelProvider.getText(this.current);
    }

    void dispose() {
        this.text.dispose();
        if (this.arrow != null) {
            if (this.arrow.getImage() != null) {
                this.arrow.getImage().dispose();
            }
            this.arrow.dispose();
        }
    }

    private void openShell() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        this.shell = new Shell(display, 540680);
        this.shell.setSize(250, 250);
        this.shell.setLayout((Layout)new FillLayout());
        TreeViewer viewer = new TreeViewer((Composite)this.shell);
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        AdapterFactoryLabelProvider adapterFactoryLabelProvider = this.labelProvider;
        if (adapterFactoryLabelProvider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
            DelegatingStyledCellLabelProvider.IStyledLabelProvider styledLabelProvider = (DelegatingStyledCellLabelProvider.IStyledLabelProvider)adapterFactoryLabelProvider;
            viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider(styledLabelProvider));
        } else {
            viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
        viewer.setInput(this.current);
        viewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                if (BreadcrumbItem.this.shell != null) {
                    BreadcrumbItem.this.shell.close();
                }
            }
        });
        viewer.addSelectionChangedListener(this::handleTreeSelection);
        Point location = new Point(this.arrow.getBounds().x, this.arrow.getBounds().y);
        Rectangle rect = this.arrow.getBounds();
        Point menuLocation = new Point(location.x - 1, location.y + rect.height);
        this.shell.setLocation(display.map((Control)this.arrow.getParent(), null, menuLocation));
        this.shell.open();
    }

    private void updateBreadcrumb(Object obj) {
        this.parent.setInput(obj);
        if (this.shell != null && !this.shell.isDisposed() && this.shell.isEnabled()) {
            this.shell.close();
        }
    }

    private void handleTreeSelection(SelectionChangedEvent event) {
        IStructuredSelection selection = event.getStructuredSelection();
        if (!selection.isEmpty()) {
            this.updateBreadcrumb(selection.getFirstElement());
        }
    }

    private static final class BreadcrumbArrowDescriptor
    extends CompositeImageDescriptor {
        private BreadcrumbArrowDescriptor() {
        }

        protected void drawCompositeImage(int width, int height) {
            Display display = Display.getCurrent();
            int SIZE = 5;
            ImageDataProvider imageProvider = zoom -> {
                int whitePixel;
                Image image = new Image((Device)display, 5, 10);
                GC gc = new GC((Drawable)image, 0x2000000);
                gc.setBackground(display.getSystemColor(24));
                int[] nArray = new int[6];
                nArray[2] = 5;
                nArray[3] = 5;
                nArray[5] = 10;
                gc.fillPolygon(nArray);
                gc.dispose();
                ImageData imageData = image.getImageData(zoom);
                image.dispose();
                imageData.transparentPixel = whitePixel = imageData.palette.getPixel(display.getSystemColor(25).getRGB());
                return imageData;
            };
            this.drawImage(imageProvider, width / 2 - 2, height / 2 - 5);
        }

        protected Point getSize() {
            return new Point(16, 16);
        }
    }

    private static class FilteredBreadCrumbContentProvider
    implements ITreeContentProvider {
        final AdapterFactoryContentProvider nestedContentProvider;

        public FilteredBreadCrumbContentProvider(AdapterFactoryContentProvider nestedContentProvider) {
            this.nestedContentProvider = nestedContentProvider;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            return Arrays.stream(this.nestedContentProvider.getChildren(parentElement)).filter(obj -> obj instanceof IFile || obj instanceof SystemConfiguration || obj instanceof Application || obj instanceof SubApp || obj instanceof CFBInstance || obj instanceof org.eclipse.fordiac.ide.model.libraryElement.Device || obj instanceof Resource).sorted(new ChildrenSortComparator()).toArray();
        }

        public Object getParent(Object element) {
            return this.nestedContentProvider.getParent(element);
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length != 0;
        }
    }
}

