/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.editors;

import java.util.Objects;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class GraphicalViewerNavigationLocationData {
    private final double zoom;
    private final Point location;

    public GraphicalViewerNavigationLocationData(GraphicalViewer viewer) {
        this.zoom = GraphicalViewerNavigationLocationData.getCurrentZoom(viewer);
        this.location = GraphicalViewerNavigationLocationData.getViewerLocation(viewer);
    }

    public void restoreGraphicalViewerData(EditPartViewer viewer) {
        FigureCanvas canvas;
        Control control;
        RootEditPart rootEditPart = viewer.getRootEditPart();
        if (rootEditPart instanceof ScalableFreeformRootEditPart) {
            ScalableFreeformRootEditPart rootEP = (ScalableFreeformRootEditPart)rootEditPart;
            rootEP.getZoomManager().setZoom(this.zoom);
        }
        if ((control = viewer.getControl()) instanceof FigureCanvas && !(canvas = (FigureCanvas)control).isDisposed()) {
            Display.getDefault().syncExec(() -> {
                if (!canvas.isDisposed()) {
                    viewer.flush();
                    canvas.scrollTo(this.location.x, this.location.y);
                }
            });
        }
    }

    public int hashCode() {
        return Objects.hash(this.location, this.zoom);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            GraphicalViewerNavigationLocationData other = (GraphicalViewerNavigationLocationData)obj;
            return this.location.equals((Object)other.location) && Double.compare(this.zoom, other.zoom) == 0;
        }
        return false;
    }

    private static double getCurrentZoom(GraphicalViewer viewer) {
        RootEditPart rootEditPart = viewer.getRootEditPart();
        if (rootEditPart instanceof ScalableFreeformRootEditPart) {
            ScalableFreeformRootEditPart rootEP = (ScalableFreeformRootEditPart)rootEditPart;
            return rootEP.getZoomManager().getZoom();
        }
        return 1.0;
    }

    private static Point getViewerLocation(GraphicalViewer viewer) {
        Control control = viewer.getControl();
        if (control instanceof FigureCanvas) {
            FigureCanvas canvas = (FigureCanvas)control;
            return canvas.getViewport().getViewLocation();
        }
        return new Point(0, 0);
    }
}

