/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts;

import java.io.FileOutputStream;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.fordiac.ide.Utils;
import org.eclipse.fordiac.ide.contractSpec.Unit;
import org.eclipse.fordiac.ide.contracts.CInterval;
import org.eclipse.fordiac.ide.contracts.ContractRule;
import org.eclipse.fordiac.ide.contracts.DynamicCheckResult;
import org.eclipse.fordiac.ide.contracts.EventOccurrence;
import org.eclipse.fordiac.ide.contracts.dialogs.ContractCheckResultDialog;
import org.eclipse.fordiac.ide.contracts.helpers.Painter;
import org.eclipse.fordiac.ide.contracts.helpers.SVGPainter;
import org.eclipse.fordiac.ide.contracts.helpers.SWTPainter;
import org.eclipse.fordiac.ide.ui.utils.ContractScanner;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DynamicCheckResultDialog
extends ContractCheckResultDialog {
    private static final Color AXIS_COLOR = new Color(0, 0, 0);
    private static final Color AXIS_LIGHT_COLOR = new Color(200, 200, 200);
    private static final Color INTERVAL_COLOR = new Color(255, 149, 14);
    private static final Color EVENT_COLOR = new Color(1, 34, 105);
    private static final Color ISSUE_COLOR = new Color(207, 8, 8);
    private static final Color FULFILL_COLOR = new Color(27, 176, 11);
    private static final int LINE_HEIGHT = 25;
    private static final int LINE_PAD = 5;
    private static final int DIAGRAM_PAD = 10;
    private static final int MARKER_SIZE = 8;
    private static final int MAX_RULES = 15;
    private final Shell parentShell;
    private final DynamicCheckResult result;
    private final double diagramMax;
    private final int[] triangleVertBuf;
    private StyledText[] ruleTexts;
    private Label[] ruleTextLabels;
    private Composite upButtons;
    private Composite downButtons;
    private Label displayRangeLbl;
    private Label rulePageLabel;
    private Canvas canvas;
    private Rectangle diagramArea;
    private CInterval oldRange;
    private CInterval displayRange;
    private Unit displayUnit;
    private int firstRuleIdx = 0;
    private boolean dragging = false;
    private double dragStartNs = 0.0;
    private double dragNs = 0.0;

    public DynamicCheckResultDialog(DynamicCheckResult result, boolean networkCheck, Shell shell) {
        super(result.system(), networkCheck, shell);
        this.parentShell = shell;
        this.result = result;
        this.triangleVertBuf = new int[6];
        double upperBound = 0.0;
        double lastEvent = 0.0;
        for (DynamicCheckResult.RuleData ruleData : result.rules()) {
            if (ruleData.markers().isEmpty()) continue;
            if (ruleData.markers().getLast().timestampNs() > lastEvent) {
                lastEvent = ruleData.markers().getLast().timestampNs();
            }
            int idx = Math.min(5, ruleData.markers().size() - 1);
            upperBound = Math.max(upperBound, ruleData.markers().get(idx).timestampNs());
        }
        if (lastEvent == 0.0) {
            lastEvent = 1.0E7;
        }
        if (upperBound == 0.0) {
            upperBound = 1.0E7;
        }
        this.displayRange = new CInterval('[', 0.0, upperBound, ']');
        this.displayUnit = Utils.getFittingUnit((double)upperBound);
        this.diagramMax = lastEvent + Utils.getInNs((double)10.0, (Unit)this.displayUnit);
    }

    @Override
    protected Control createCustomArea(Composite parent) {
        super.createCustomArea(parent);
        Composite composite = new Composite(parent, 0);
        GridLayout gLayout = new GridLayout(2, false);
        gLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gLayout);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.createRuleList(composite);
        this.createDiagram(composite);
        this.rulePageLabel = new Label(composite, 0);
        this.rulePageLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.updateRulePageLabel();
        this.createTimeLineNav(composite);
        return this.dialogArea;
    }

    private void createRuleList(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gLayout = new GridLayout(2, false);
        gLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gLayout);
        new Label(composite, 0);
        this.upButtons = new Composite(composite, 0);
        this.upButtons.setLayout((Layout)new FillLayout());
        this.upButtons.setLayoutData((Object)new GridData(4, 128, true, false));
        Button up1 = new Button(this.upButtons, 0);
        up1.setText("-");
        up1.addSelectionListener(DynamicCheckResultDialog.listener(e -> this.navigateRules(-1L)));
        Button upPage = new Button(this.upButtons, 0);
        upPage.setText("^");
        upPage.addSelectionListener(DynamicCheckResultDialog.listener(e -> this.navigateRules(-15L)));
        Button upTop = new Button(this.upButtons, 0);
        upTop.setText("^^");
        upTop.addSelectionListener(DynamicCheckResultDialog.listener(e -> this.navigateRules(-this.result.rules().size())));
        this.ruleTexts = new StyledText[this.nRules()];
        this.ruleTextLabels = new Label[this.nRules()];
        int i = 0;
        while (i < this.ruleTexts.length) {
            Label lbl = new Label(composite, 131072);
            lbl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            lbl.setForeground(new Color(128, 128, 128));
            this.ruleTextLabels[i] = lbl;
            StyledText txt = new StyledText(composite, 4);
            txt.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            txt.setMargins(5, 5, 5, 5);
            txt.setEnabled(false);
            this.ruleTexts[i] = txt;
            if (i % 2 == 0) {
                txt.setBackground(new Color(255, 255, 255));
            }
            ++i;
        }
        new Label(composite, 0);
        this.downButtons = new Composite(composite, 0);
        this.downButtons.setLayout((Layout)new FillLayout());
        this.downButtons.setLayoutData((Object)new GridData(4, 128, true, false));
        Button down1 = new Button(this.downButtons, 0);
        down1.setText("+");
        down1.addSelectionListener(DynamicCheckResultDialog.listener(e -> this.navigateRules(1L)));
        Button downPage = new Button(this.downButtons, 0);
        downPage.setText("v");
        downPage.addSelectionListener(DynamicCheckResultDialog.listener(e -> this.navigateRules(15L)));
        Button downBot = new Button(this.downButtons, 0);
        downBot.setText("vv");
        downBot.addSelectionListener(DynamicCheckResultDialog.listener(e -> this.navigateRules(this.result.rules().size())));
        this.fillRuleList();
    }

    private void fillRuleList() {
        String lastName = ".";
        int i = 0;
        while (i < this.nRules()) {
            DynamicCheckResult.RuleData ruleData = this.result.rules().get(i + this.firstRuleIdx);
            ContractRule rule = ruleData.rule();
            String name = rule.getOwner().getName();
            if (lastName.equals(name)) {
                this.ruleTextLabels[i].setText("\"");
            } else {
                this.ruleTextLabels[i].setText(name);
                lastName = name;
            }
            StyledText txt = this.ruleTexts[i];
            String ruleString = rule.toString();
            txt.setText(ruleString);
            txt.setStyleRanges(ContractScanner.getStyleRanges((String)ruleString));
            ++i;
        }
        Control[] controlArray = this.upButtons.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setEnabled(this.firstRuleIdx > 0);
            ++n2;
        }
        controlArray = this.downButtons.getChildren();
        n = controlArray.length;
        n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setEnabled(this.firstRuleIdx < this.result.rules().size() - 15);
            ++n2;
        }
        this.updateRulePageLabel();
        if (this.ruleTexts.length > 0) {
            this.ruleTexts[0].getParent().getParent().layout();
        }
    }

    private void createDiagram(Composite parent) {
        this.canvas = new Canvas(parent, 0x20000000);
        GridData gData = new GridData(4, 4, true, true);
        gData.widthHint = 800;
        this.canvas.setLayoutData((Object)gData);
        this.canvas.addPaintListener(e -> {
            e.gc.setAntialias(1);
            this.drawDiagram(new SWTPainter(e.gc));
        });
        this.canvas.addDragDetectListener(e -> {
            this.dragging = true;
            this.dragStartNs = this.pixel2Ns(e.x);
            this.oldRange = this.displayRange;
        });
        this.canvas.addMouseMoveListener(e -> {
            if (this.dragging) {
                this.dragNs = this.pixel2Ns(e.x, this.oldRange);
                this.navigateDiagram(this.dragStartNs - this.dragNs, false);
                this.dragStartNs = this.dragNs;
            }
        });
        this.canvas.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                FileDialog dialog = new FileDialog(DynamicCheckResultDialog.this.parentShell, 8192);
                dialog.setFilterExtensions(new String[]{"*.svg", "*.*"});
                dialog.setFileName("result.svg");
                String fname = dialog.open();
                if (fname == null) {
                    return;
                }
                SVGPainter painter = new SVGPainter(DynamicCheckResultDialog.this.canvas.getClientArea());
                DynamicCheckResultDialog.this.drawDiagram(painter);
                String svg = painter.finalizeSVG();
                try {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (FileOutputStream fstream = new FileOutputStream(fname);){
                        fstream.write(svg.getBytes());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                DynamicCheckResultDialog.this.dragging = false;
            }
        });
        this.canvas.addMouseWheelListener(e -> this.navigateDiagramStep(e.count, true));
    }

    private void createTimeLineNav(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(5, false));
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button left = new Button(composite, 0);
        left.setText("<");
        left.addSelectionListener(DynamicCheckResultDialog.listener(e -> this.navigateDiagramStep(-1, false)));
        this.displayRangeLbl = new Label(composite, 0);
        this.displayRangeLbl.setAlignment(0x1000000);
        this.displayRangeLbl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.updateDisplayRange();
        Button right = new Button(composite, 0);
        right.setText(">");
        right.addSelectionListener(DynamicCheckResultDialog.listener(e -> this.navigateDiagramStep(1, false)));
        Button zoomIn = new Button(composite, 0);
        zoomIn.setText("+");
        zoomIn.addSelectionListener(DynamicCheckResultDialog.listener(e -> this.navigateDiagramStep(1, true)));
        Button zoomOut = new Button(composite, 0);
        zoomOut.setText("-");
        zoomOut.addSelectionListener(DynamicCheckResultDialog.listener(e -> this.navigateDiagramStep(-1, true)));
    }

    private void drawDiagram(Painter painter) {
        Rectangle canvasArea = this.canvas.getClientArea();
        this.diagramArea = new Rectangle(canvasArea.x + 10, canvasArea.y + 10, canvasArea.width - 20, canvasArea.height - 20);
        painter.setBackground(new Color(255, 255, 255));
        int linePos = this.diagramArea.y + 25 - 5;
        int nFilled = this.nRules() % 2 == 0 ? this.nRules() / 2 : this.nRules() / 2 + 1;
        int i = 0;
        while (i < nFilled) {
            painter.fillRectangle(0, linePos, canvasArea.width, 25);
            linePos += 50;
            ++i;
        }
        painter.setForeground(AXIS_COLOR);
        painter.drawLine(0, this.diagramArea.height, canvasArea.width, this.diagramArea.height);
        double totalNs = this.displayRange.getDiameter();
        long stepSizeNs = 1L;
        while (totalNs / 10.0 > 10.0) {
            stepSizeNs *= 10L;
            totalNs /= 10.0;
        }
        if ((double)stepSizeNs / this.displayRange.getDiameter() < 0.02) {
            stepSizeNs *= 5L;
        } else if ((double)stepSizeNs / this.displayRange.getDiameter() < 0.05) {
            stepSizeNs *= 2L;
        }
        int nTicks = (int)(this.displayRange.getDiameter() / (double)stepSizeNs) + 2;
        double unitScale = Utils.getInNs((double)1.0, (Unit)this.displayUnit);
        long lowest = Math.round(this.displayRange.getLowerBound() / (double)stepSizeNs) * stepSizeNs;
        int i2 = 0;
        while (i2 < nTicks) {
            int xPos = this.ns2Pixel(lowest + (long)i2 * stepSizeNs);
            painter.setForeground(AXIS_LIGHT_COLOR);
            painter.drawLine(xPos, this.diagramArea.height, xPos, 25);
            painter.setForeground(AXIS_COLOR);
            painter.drawLine(xPos, this.diagramArea.height, xPos, this.diagramArea.height - 5);
            String markerText = String.valueOf((double)(lowest + (long)i2 * stepSizeNs) / unitScale);
            painter.drawTextCentered(markerText, xPos, this.diagramArea.height, true);
            ++i2;
        }
        linePos = this.diagramArea.y + 25 - 5;
        i2 = 0;
        while (i2 < this.nRules()) {
            DynamicCheckResult.RuleData ruleData = this.result.rules().get(i2 + this.firstRuleIdx);
            this.drawRuleIntervals(painter, ruleData, linePos, canvasArea.width);
            this.drawRuleMarkers(painter, ruleData, linePos, canvasArea.width);
            linePos += 25;
            ++i2;
        }
    }

    private void drawRuleIntervals(Painter painter, DynamicCheckResult.RuleData ruleData, int linePos, int maxWidth) {
        int middlePos = linePos + 12;
        double jitter = ruleData.rule().getJitter();
        int j = this.firstDrawIndexInterval(ruleData.intervals(), jitter);
        while (j < ruleData.intervals().size()) {
            CInterval interval = ruleData.intervals().get(j);
            painter.setForeground(INTERVAL_COLOR);
            painter.setBackground(INTERVAL_COLOR);
            int start = this.drawInterval(painter, interval, linePos, true);
            if (jitter > 0.0) {
                CInterval intervalJitter = interval.addJitter(jitter);
                start = this.drawInterval(painter, intervalJitter, linePos, false);
            }
            painter.setForeground(EVENT_COLOR);
            painter.setBackground(EVENT_COLOR);
            switch (ruleData.rule().getType()) {
                case REPETITION: {
                    if (j == 0) break;
                }
                case REACTION: 
                case CAUSAL_REACTION: {
                    this.drawArrowLR(painter, interval.getLowerBound() - ruleData.rule().getInterval().getLowerBound(), interval.getLowerBound(), middlePos);
                    break;
                }
                case AGE: 
                case CAUSAL_AGE: {
                    this.drawArrowLR(painter, interval.getUpperBound() + ruleData.rule().getInterval().getLowerBound(), interval.getUpperBound(), middlePos);
                    break;
                }
            }
            if (start > maxWidth) break;
            ++j;
        }
    }

    private void drawRuleMarkers(Painter painter, DynamicCheckResult.RuleData ruleData, int linePos, int maxWidth) {
        int markerYPos = linePos + 12;
        int p = 4;
        int j = this.firstDrawIndex(ruleData.markers());
        while (j < ruleData.markers().size()) {
            EventOccurrence eo = ruleData.markers().get(j);
            int xPos = this.ns2Pixel(eo.timestampNs());
            if (xPos > maxWidth) break;
            switch (eo.type()) {
                case RECORDED: {
                    painter.setForeground(AXIS_COLOR);
                    painter.setBackground(switch (eo.state()) {
                        case EventOccurrence.State.NOT_SET -> EVENT_COLOR;
                        case EventOccurrence.State.FULFILLING -> FULFILL_COLOR;
                        case EventOccurrence.State.ISSUE -> ISSUE_COLOR;
                        default -> throw new MatchException(null, null);
                    });
                    this.drawArrowHeadUD(painter, xPos, linePos + 25, 8, -13);
                    String txt = eo.getShortName();
                    painter.drawTextCentered(txt, xPos, linePos, true);
                    break;
                }
                case MISSED_MARKER: {
                    painter.setForeground(ISSUE_COLOR);
                    painter.drawLine(xPos - 4, markerYPos + 4, xPos + 4, markerYPos - 4);
                    painter.drawLine(xPos + 4, markerYPos + 4, xPos - 4, markerYPos - 4);
                    break;
                }
            }
            ++j;
        }
    }

    private int drawInterval(Painter painter, CInterval interval, int yPos, boolean fill) {
        int start = this.ns2Pixel(interval.getLowerBound());
        int end = this.ns2Pixel(interval.getUpperBound());
        int width = Math.max(end - start, 1);
        painter.drawRectangle(start, yPos + 5, width, 15);
        if (fill) {
            painter.setAlpha(128);
            painter.fillRectangle(start, yPos + 5, width, 15);
            painter.setAlpha(255);
        }
        return start;
    }

    private void drawArrowLR(Painter painter, double start, double end, int y) {
        int startP = this.ns2Pixel(start);
        int endP = this.ns2Pixel(end);
        int markerAndHalf = 12;
        if (start < end) {
            painter.drawLine(startP, y, endP - 8, y);
            this.drawArrowHeadLR(painter, endP - 12, y, 8, 12);
        } else {
            painter.drawLine(startP, y, endP + 8, y);
            this.drawArrowHeadLR(painter, endP + 12, y, 8, -12);
        }
    }

    private void drawArrowHeadUD(Painter painter, int x, int y, int baseWidth, int height) {
        this.triangleVertBuf[0] = x - baseWidth / 2;
        this.triangleVertBuf[1] = y;
        this.triangleVertBuf[2] = x;
        this.triangleVertBuf[3] = y + height;
        this.triangleVertBuf[4] = x + baseWidth / 2;
        this.triangleVertBuf[5] = y;
        painter.fillPolygon(this.triangleVertBuf);
    }

    private void drawArrowHeadLR(Painter painter, int x, int y, int baseWidth, int length) {
        this.triangleVertBuf[0] = x;
        this.triangleVertBuf[1] = y + baseWidth / 2;
        this.triangleVertBuf[2] = x + length;
        this.triangleVertBuf[3] = y;
        this.triangleVertBuf[4] = x;
        this.triangleVertBuf[5] = y - baseWidth / 2;
        painter.fillPolygon(this.triangleVertBuf);
    }

    private int firstDrawIndex(List<EventOccurrence> list) {
        double actualStart = this.pixel2Ns(-10);
        EventOccurrence key = new EventOccurrence("", actualStart);
        int firstIndex = Collections.binarySearch(list, key);
        if (firstIndex < 0) {
            firstIndex = Math.abs(firstIndex + 1);
        }
        return firstIndex;
    }

    private int firstDrawIndexInterval(List<CInterval> list, double jitter) {
        double actualStart = this.pixel2Ns(-10) - jitter;
        CInterval key = new CInterval('[', actualStart, actualStart, ']');
        int firstIndex = Collections.binarySearch(list, key, (a, b) -> Double.compare(a.getUpperBound(), b.getUpperBound()));
        if (firstIndex < 0) {
            firstIndex = Math.abs(firstIndex + 1);
        }
        return Math.max(firstIndex - 1, 0);
    }

    private void navigateDiagramStep(int direction, boolean zoom) {
        if (zoom) {
            double zoomAmount = Math.max(1.0, this.displayRange.getDiameter() / 10.0);
            this.navigateDiagram(zoomAmount * (double)Math.signum(direction), zoom);
        } else {
            this.navigateDiagram(Utils.getInNs((double)1.0, (Unit)this.displayUnit) * (double)Math.signum(direction), zoom);
        }
    }

    private void navigateDiagram(double amount, boolean zoom) {
        if (zoom) {
            CInterval nRange = this.displayRange.addJitter(-amount);
            if (nRange.getLowerBound() + 1.0 >= nRange.getUpperBound()) {
                return;
            }
            if (nRange.getLowerBound() < 0.0) {
                nRange = new CInterval('[', 0.0, nRange.getUpperBound(), ']');
            }
            if (nRange.getUpperBound() > this.diagramMax) {
                nRange = new CInterval('[', nRange.getLowerBound(), this.diagramMax, ']');
            }
            this.displayRange = nRange;
        } else {
            double diameter = this.displayRange.getDiameter();
            CInterval nRange = this.displayRange.translate(amount);
            this.displayRange = nRange.getLowerBound() < 0.0 ? new CInterval('[', 0.0, diameter, ']') : (nRange.getUpperBound() > this.diagramMax ? new CInterval('[', this.diagramMax - diameter, this.diagramMax, ']') : nRange);
        }
        this.updateDisplayRange();
        this.canvas.redraw();
    }

    private void navigateRules(long changeAmount) {
        int nRules = this.result.rules().size();
        this.firstRuleIdx = Math.clamp((long)this.firstRuleIdx + changeAmount, 0, nRules - 15);
        this.fillRuleList();
        this.canvas.redraw();
    }

    private void updateDisplayRange() {
        this.displayUnit = Utils.getFittingUnit((double)this.displayRange.getDiameter());
        double unit = Utils.getInNs((double)1.0, (Unit)this.displayUnit);
        double lv = this.displayRange.getLowerBound() / unit;
        double uv = this.displayRange.getUpperBound() / unit;
        this.displayRangeLbl.setText("[%.2f, %.2f]%s".formatted(lv, uv, this.displayUnit));
    }

    private void updateRulePageLabel() {
        if (this.rulePageLabel != null) {
            this.rulePageLabel.setText("%d-%d / %d".formatted(this.firstRuleIdx + 1, this.firstRuleIdx + this.nRules(), this.result.rules().size()));
        }
    }

    private int nRules() {
        return Math.min(15, this.result.rules().size());
    }

    private int ns2Pixel(double ns) {
        return this.ns2Pixel(ns, this.displayRange);
    }

    private int ns2Pixel(double ns, CInterval range) {
        double pad = this.displayRange.getDiameter() * 0.1;
        double nsClamped = Math.clamp(ns, this.displayRange.getLowerBound() - pad, this.displayRange.getUpperBound() + pad);
        double shifted = nsClamped - range.getLowerBound();
        double percentage = shifted / range.getDiameter();
        return (int)(percentage * (double)this.diagramArea.width) + this.diagramArea.x;
    }

    private double pixel2Ns(int pixel) {
        return this.pixel2Ns(pixel, this.displayRange);
    }

    private double pixel2Ns(int pixel, CInterval range) {
        double percentage = (double)(pixel - this.diagramArea.x) / (double)this.diagramArea.width;
        double shifted = percentage * range.getDiameter();
        return shifted + range.getLowerBound();
    }

    private static SelectionListener listener(final Consumer<SelectionEvent> action) {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                action.accept(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }
}

