/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug;

import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.fordiac.ide.debug.AbstractLaunchProcess;
import org.eclipse.fordiac.ide.deployment.DeploymentCoordinator;
import org.eclipse.fordiac.ide.deployment.DownloadRunnable;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentStreamsProxy;
import org.eclipse.fordiac.ide.deployment.debug.Messages;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.util.IDeploymentListener;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;

public class DeploymentProcess
extends AbstractLaunchProcess {
    private final DeploymentStreamsProxy streamsProxy = new DeploymentStreamsProxy();
    private final DownloadRunnable downloadRunnable;
    private final Job job;
    private boolean terminated;

    public DeploymentProcess(AutomationSystem system, Set<INamedElement> selection, ILaunch launch) throws DeploymentException {
        super(MessageFormat.format(Messages.DeploymentProcess_Name, system.getName()), launch);
        this.downloadRunnable = new DownloadRunnable(DeploymentCoordinator.createDeploymentdata((Object[])selection.toArray()), null, (IDeploymentListener)this.streamsProxy, null);
        this.job = Job.create((String)this.name, this::deploy);
        this.job.addJobChangeListener(IJobChangeListener.onDone(this::terminated));
        this.job.setUser(true);
        launch.addProcess((IProcess)this);
        this.fireCreationEvent();
    }

    protected IStatus deploy(IProgressMonitor monitor) {
        try {
            this.downloadRunnable.run(monitor);
            return this.downloadRunnable.getResult();
        }
        catch (InterruptedException e) {
            this.streamsProxy.getErrorStreamMonitor().message(Messages.DeploymentProcess_Terminated);
            Thread.currentThread().interrupt();
            return Status.error((String)Messages.DeploymentProcess_Terminated);
        }
        catch (Exception t) {
            this.streamsProxy.getErrorStreamMonitor().message(MessageFormat.format(Messages.DeploymentProcess_ExeceptionOccured, t.getMessage()));
            return Status.error((String)MessageFormat.format(Messages.DeploymentProcess_ExeceptionOccured, t.getMessage()), (Throwable)t);
        }
    }

    protected void terminated(IJobChangeEvent event) {
        this.terminated = true;
        this.fireTerminateEvent();
    }

    public void start() {
        this.job.schedule();
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void terminate() throws DebugException {
        this.job.cancel();
    }

    public int getExitValue() throws DebugException {
        if (!this.isTerminated()) {
            throw new DebugException(Status.error((String)Messages.DeploymentProcess_StillRunning));
        }
        return this.job.getResult().getCode();
    }

    public IStreamsProxy getStreamsProxy() {
        return this.streamsProxy;
    }

    public Job getJob() {
        return this.job;
    }
}

