/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.disco.transform;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.elk.alg.disco.graph.DCDirection;
import org.eclipse.elk.alg.disco.graph.DCElement;
import org.eclipse.elk.alg.disco.graph.DCExtension;
import org.eclipse.elk.alg.disco.graph.DCGraph;
import org.eclipse.elk.alg.disco.options.DisCoOptions;
import org.eclipse.elk.alg.disco.transform.ElkGraphComponentsProcessor;
import org.eclipse.elk.alg.disco.transform.IGraphTransformer;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.ElkShape;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.util.EList;

public class ElkGraphTransformer
implements IGraphTransformer<ElkNode> {
    private static final double HALF_PI = 1.5707963267948966;
    private ElkNode parent;
    private HashMap<ElkGraphElement, DCElement> elementMapping = Maps.newHashMap();
    private HashMap<ElkEdge, DCExtension> incomingExtensionsMapping = Maps.newHashMap();
    private HashMap<ElkEdge, DCExtension> outgoingExtensionsMapping = Maps.newHashMap();
    private DCGraph transformedGraph;
    private double componentSpacing = 0.0;

    public ElkGraphTransformer() {
    }

    public ElkGraphTransformer(double componentSpacing) {
        this.componentSpacing = componentSpacing;
    }

    @Override
    public DCGraph importGraph(ElkNode graph) {
        this.parent = graph;
        List<List<ElkNode>> components = ElkGraphComponentsProcessor.split(graph);
        ArrayList result = Lists.newArrayList();
        for (List<ElkNode> component : components) {
            ArrayList subResult = Lists.newArrayList();
            result.add(subResult);
            HashSet edgeSet = Sets.newHashSet();
            for (ElkNode node : component) {
                DCElement componentNode = this.importElkShape(node, true, 0.0, 0.0);
                subResult.add(componentNode);
                double nodeX = node.getX();
                double nodeY = node.getY();
                componentNode.setParentCoords(new KVector(nodeX, nodeY));
                EList labels = node.getLabels();
                for (ElkLabel label : labels) {
                    DCElement componentLabel = this.importElkShape(label, false, nodeX, nodeY);
                    subResult.add(componentLabel);
                }
                EList ports = node.getPorts();
                for (ElkPort port : ports) {
                    DCElement componentPort = this.importElkShape(port, false, nodeX, nodeY);
                    subResult.add(componentPort);
                    double portX = port.getX() + nodeX;
                    double portY = port.getY() + nodeY;
                    labels = port.getLabels();
                    for (ElkLabel label : labels) {
                        DCElement componentLabel = this.importElkShape(label, false, portX, portY);
                        subResult.add(componentLabel);
                    }
                }
                edgeSet.addAll(Sets.newHashSet((Iterable)ElkGraphUtil.allIncidentEdges((ElkNode)node)));
            }
            this.importElkEdges(edgeSet, subResult);
        }
        this.transformedGraph = new DCGraph(result, this.componentSpacing / 2.0);
        this.transformedGraph.copyProperties((IPropertyHolder)graph);
        return this.transformedGraph;
    }

    @Override
    public void applyLayout() {
        ElkPort portToAdjust;
        KVectorChain newPoints;
        ElkEdgeSection edgeSection;
        DCDirection dir;
        KVector graphDimensions = this.transformedGraph.getDimensions();
        double newWidth = graphDimensions.x;
        double newHeight = graphDimensions.y;
        double oldWidth = this.parent.getWidth();
        double oldHeight = this.parent.getHeight();
        this.parent.setDimensions(graphDimensions.x, graphDimensions.y);
        double xFactor = newWidth / oldWidth;
        double yFactor = newHeight / oldHeight;
        for (ElkLabel label : this.parent.getLabels()) {
            label.setX(label.getX() * xFactor);
            label.setY(label.getY() * yFactor);
        }
        for (ElkPort port : this.parent.getPorts()) {
            double px = port.getX();
            double py = port.getY();
            if (px > 0.0) {
                port.setX(px * xFactor);
            }
            if (!(py > 0.0)) continue;
            port.setY(py * yFactor);
        }
        this.elementMapping.forEach(new OffsetApplier());
        ArrayList adjustedPorts = Lists.newArrayList();
        for (Map.Entry<ElkEdge, DCExtension> inEntry : this.incomingExtensionsMapping.entrySet()) {
            ElkEdge edge = inEntry.getKey();
            dir = inEntry.getValue().getDirection();
            edgeSection = ElkGraphUtil.firstEdgeSection((ElkEdge)edge, (boolean)false, (boolean)false);
            newPoints = this.adjustFirstSegment(ElkGraphUtil.getSourceNode((ElkEdge)edge), ElkUtil.createVectorChain((ElkEdgeSection)edgeSection), dir);
            ElkUtil.applyVectorChain((KVectorChain)newPoints, (ElkEdgeSection)edgeSection);
            portToAdjust = ElkGraphUtil.getSourcePort((ElkEdge)edge);
            if (portToAdjust == null || adjustedPorts.contains(portToAdjust)) continue;
            adjustedPorts.add(portToAdjust);
            this.adjustRelatedPort(portToAdjust, (KVector)newPoints.getFirst(), dir);
        }
        for (Map.Entry<ElkEdge, DCExtension> outEntry : this.outgoingExtensionsMapping.entrySet()) {
            ElkEdge edge = outEntry.getKey();
            dir = outEntry.getValue().getDirection();
            edgeSection = ElkGraphUtil.firstEdgeSection((ElkEdge)edge, (boolean)false, (boolean)false);
            newPoints = this.adjustFirstSegment(ElkGraphUtil.getTargetNode((ElkEdge)edge), KVectorChain.reverse((KVectorChain)ElkUtil.createVectorChain((ElkEdgeSection)edgeSection)), dir);
            newPoints = KVectorChain.reverse((KVectorChain)newPoints);
            ElkUtil.applyVectorChain((KVectorChain)newPoints, (ElkEdgeSection)edgeSection);
            portToAdjust = ElkGraphUtil.getTargetPort((ElkEdge)edge);
            if (portToAdjust == null || adjustedPorts.contains(portToAdjust)) continue;
            adjustedPorts.add(portToAdjust);
            this.adjustRelatedPort(portToAdjust, (KVector)newPoints.getLast(), dir);
        }
    }

    private void adjustRelatedPort(ElkPort port, KVector edgePoint, DCDirection dir) {
        if (dir.isHorizontal()) {
            port.setY(edgePoint.y - port.getHeight() / 2.0);
        } else {
            port.setX(edgePoint.x - port.getWidth() / 2.0);
        }
    }

    private <E extends ElkShape> DCElement importElkShape(E element, boolean considerWhenApplyingOffset, double offsetX, double offsetY) throws IllegalArgumentException {
        if (!(element instanceof ElkNode || element instanceof ElkLabel || element instanceof ElkPort)) {
            throw new IllegalArgumentException("Method only works for ElkNode-, ElkLabel and ElkPort-objects.");
        }
        double halfComponentSpacing = this.componentSpacing / 2.0;
        double x0 = element.getX() + offsetX - halfComponentSpacing;
        double y0 = element.getY() + offsetY - halfComponentSpacing;
        double x1 = x0 + element.getWidth() + this.componentSpacing;
        double y1 = y0 + element.getHeight() + this.componentSpacing;
        KVectorChain coords = new KVectorChain();
        coords.add((Object)this.newPoint(x0, y0));
        coords.add((Object)this.newPoint(x0, y1));
        coords.add((Object)this.newPoint(x1, y1));
        coords.add((Object)this.newPoint(x1, y0));
        DCElement shape = new DCElement(coords);
        shape.copyProperties((IPropertyHolder)element);
        if (considerWhenApplyingOffset) {
            this.elementMapping.put((ElkGraphElement)element, shape);
        }
        return shape;
    }

    private DCElement importElkEdge(ElkEdge edge, Collection<DCElement> newComponent) {
        ElkEdgeSection edgeSection = ElkGraphUtil.firstEdgeSection((ElkEdge)edge, (boolean)false, (boolean)false);
        KVectorChain points = ElkUtil.createVectorChain((ElkEdgeSection)edgeSection);
        double thickness = (Double)edge.getProperty(DisCoOptions.EDGE_THICKNESS);
        KVectorChain contour = this.getContour((List<KVector>)points, thickness + this.componentSpacing);
        DCElement shape = new DCElement(contour);
        shape.copyProperties((IPropertyHolder)edge);
        this.elementMapping.put((ElkGraphElement)edge, shape);
        newComponent.add(shape);
        EList labels = edge.getLabels();
        for (ElkLabel label : labels) {
            DCElement componentLabel = this.importElkShape(label, true, 0.0, 0.0);
            newComponent.add(componentLabel);
        }
        return shape;
    }

    private void importExtension(ElkEdge edge, Collection<DCElement> newComponent, boolean outgoingExtension) {
        KVector middlePos;
        DCElement shape;
        ElkEdgeSection edgeSection = ElkGraphUtil.firstEdgeSection((ElkEdge)edge, (boolean)false, (boolean)false);
        KVectorChain points = ElkUtil.createVectorChain((ElkEdgeSection)edgeSection);
        if (outgoingExtension) {
            points = KVectorChain.reverse((KVectorChain)points);
        }
        double thickness = (Double)edge.getProperty(DisCoOptions.EDGE_THICKNESS);
        KVector outerPoint = (KVector)points.getFirst();
        KVector innerPoint = (KVector)points.get(1);
        if (points.size() > 2) {
            ArrayList fixedEdgePoints = Lists.newArrayList();
            fixedEdgePoints.addAll(points.subList(1, points.size()));
            KVectorChain contour = this.getContour(fixedEdgePoints, thickness + this.componentSpacing);
            shape = new DCElement(contour);
            shape.copyProperties((IPropertyHolder)edge);
            newComponent.add(shape);
        } else {
            shape = outgoingExtension ? this.elementMapping.get(ElkGraphUtil.getSourceNode((ElkEdge)edge)) : this.elementMapping.get(ElkGraphUtil.getTargetNode((ElkEdge)edge));
        }
        ElkNode extParent = ElkGraphUtil.getSourceNode((ElkEdge)edge);
        if (outgoingExtension) {
            extParent = ElkGraphUtil.getTargetNode((ElkEdge)edge);
        }
        DCDirection dir = this.nearestSide(outerPoint, extParent);
        double extensionWidth = thickness + this.componentSpacing;
        if (dir.isHorizontal()) {
            extensionWidth += Math.abs(outerPoint.y - innerPoint.y);
            middlePos = new KVector(innerPoint.x, (innerPoint.y + outerPoint.y) / 2.0);
        } else {
            extensionWidth += Math.abs(outerPoint.x - innerPoint.x);
            middlePos = new KVector((innerPoint.x + outerPoint.x) / 2.0, innerPoint.y);
        }
        if (outgoingExtension) {
            this.outgoingExtensionsMapping.put(edge, new DCExtension(shape, dir, middlePos, extensionWidth));
        } else {
            this.incomingExtensionsMapping.put(edge, new DCExtension(shape, dir, middlePos, extensionWidth));
        }
        this.elementMapping.put((ElkGraphElement)edge, shape);
        EList labels = edge.getLabels();
        for (ElkLabel label : labels) {
            DCElement componentLabel = this.importElkShape(label, true, 0.0, 0.0);
            newComponent.add(componentLabel);
        }
    }

    private DCDirection nearestSide(KVector point, ElkNode node) {
        double shortestDistance = Double.MAX_VALUE;
        DCDirection result = DCDirection.NORTH;
        shortestDistance = Math.abs(point.y);
        double distance = Math.abs(node.getHeight() - point.y);
        if (distance < shortestDistance) {
            shortestDistance = distance;
            result = DCDirection.SOUTH;
        }
        if ((distance = Math.abs(point.x)) < shortestDistance) {
            shortestDistance = distance;
            result = DCDirection.WEST;
        }
        if ((distance = Math.abs(node.getWidth() - point.x)) < shortestDistance) {
            shortestDistance = distance;
            result = DCDirection.EAST;
        }
        return result;
    }

    private void importElkEdges(Collection<ElkEdge> edges, Collection<DCElement> newComponent) {
        for (ElkEdge edge : edges) {
            DCElement componentEdge = this.elementMapping.get(edge);
            if (componentEdge != null) continue;
            if (ElkGraphUtil.getSourceNode((ElkEdge)edge).getParent().equals(ElkGraphUtil.getTargetNode((ElkEdge)edge).getParent())) {
                this.importElkEdge(edge, newComponent);
                continue;
            }
            if (ElkGraphUtil.getSourceNode((ElkEdge)edge).equals(ElkGraphUtil.getTargetNode((ElkEdge)edge).getParent())) {
                if (this.incomingExtensionsMapping.get(edge) != null || this.elementMapping.get(ElkGraphUtil.getTargetNode((ElkEdge)edge)) == null) continue;
                this.importExtension(edge, newComponent, false);
                continue;
            }
            if (this.outgoingExtensionsMapping.get(edge) != null || this.elementMapping.get(ElkGraphUtil.getSourceNode((ElkEdge)edge)) == null) continue;
            this.importExtension(edge, newComponent, true);
        }
    }

    private KVectorChain getContour(List<KVector> edgePoints, double thickness) {
        KVector intersectionPoint;
        KVector currentPoint;
        ArrayList ccwPoints = Lists.newArrayList();
        ArrayList cwPoints = Lists.newArrayList();
        double radius = thickness / 2.0;
        int numberOfPoints = edgePoints.size();
        KVector current = edgePoints.get(0);
        KVector successor = edgePoints.get(1);
        List<KVector> orthPoints = this.getOrthogonalPoints(current.x, current.y, successor.x, successor.y, radius);
        ccwPoints.add(orthPoints.get(0));
        cwPoints.add(orthPoints.get(1));
        int i = 2;
        while (i < numberOfPoints) {
            KVector predecessor = current;
            current = successor;
            successor = edgePoints.get(i);
            orthPoints = this.getOrthogonalPoints(current.x, current.y, predecessor.x, predecessor.y, radius);
            ccwPoints.add(orthPoints.get(1));
            cwPoints.add(orthPoints.get(0));
            orthPoints = this.getOrthogonalPoints(current.x, current.y, successor.x, successor.y, radius);
            ccwPoints.add(orthPoints.get(0));
            cwPoints.add(orthPoints.get(1));
            ++i;
        }
        orthPoints = this.getOrthogonalPoints(successor.x, successor.y, current.x, current.y, radius);
        ccwPoints.add(orthPoints.get(1));
        cwPoints.add(orthPoints.get(0));
        KVectorChain ccwMerged = new KVectorChain();
        ArrayList cwMerged = Lists.newArrayList();
        ccwMerged.add((Object)((KVector)ccwPoints.get(0)));
        int i2 = 1;
        while (i2 < ccwPoints.size() - 2) {
            currentPoint = (KVector)ccwPoints.get(i2);
            intersectionPoint = this.computeIntersection((KVector)ccwPoints.get(i2 - 1), currentPoint, (KVector)ccwPoints.get(i2 + 1), (KVector)ccwPoints.get(i2 + 2));
            if (!Double.isFinite(intersectionPoint.x) || !Double.isFinite(intersectionPoint.y)) {
                ccwMerged.add((Object)currentPoint);
            } else {
                ccwMerged.add((Object)intersectionPoint);
            }
            i2 += 2;
        }
        ccwMerged.add((Object)((KVector)ccwPoints.get(ccwPoints.size() - 1)));
        cwMerged.add((KVector)cwPoints.get(0));
        i2 = 1;
        while (i2 < cwPoints.size() - 2) {
            currentPoint = (KVector)cwPoints.get(i2);
            intersectionPoint = this.computeIntersection((KVector)cwPoints.get(i2 - 1), currentPoint, (KVector)cwPoints.get(i2 + 1), (KVector)cwPoints.get(i2 + 2));
            if (!Double.isFinite(intersectionPoint.x) || !Double.isFinite(intersectionPoint.y)) {
                cwMerged.add(currentPoint);
            } else {
                cwMerged.add(intersectionPoint);
            }
            i2 += 2;
        }
        cwMerged.add((KVector)cwPoints.get(cwPoints.size() - 1));
        i2 = cwMerged.size() - 1;
        while (i2 >= 0) {
            ccwMerged.add((Object)((KVector)cwMerged.get(i2)));
            --i2;
        }
        return ccwMerged;
    }

    private List<KVector> getOrthogonalPoints(double curX, double curY, double nxtX, double nxtY, double radius) {
        double difX = nxtX - curX;
        double difY = nxtY - curY;
        double angleRadians = Math.atan2(difX, difY);
        double orthAngleCCW = angleRadians + 1.5707963267948966;
        double orthAngleCW = angleRadians - 1.5707963267948966;
        double xCCW = radius * Math.sin(orthAngleCCW) + curX;
        double yCCW = radius * Math.cos(orthAngleCCW) + curY;
        double xCW = radius * Math.sin(orthAngleCW) + curX;
        double yCW = radius * Math.cos(orthAngleCW) + curY;
        return Lists.newArrayList((Object[])new KVector[]{this.newPoint(xCCW, yCCW), this.newPoint(xCW, yCW)});
    }

    private KVector computeIntersection(KVector p1, KVector p2, KVector p3, KVector p4) {
        double x1 = p1.x;
        double y1 = p1.y;
        double x2 = p2.x;
        double y2 = p2.y;
        double x3 = p3.x;
        double y3 = p3.y;
        double x4 = p4.x;
        double y4 = p4.y;
        double factor1 = x1 * y2 - y1 * x2;
        double factor2 = x3 * y4 - y3 * x4;
        double denominator = (x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4);
        double x = (factor1 * (x3 - x4) - factor2 * (x1 - x2)) / denominator;
        double y = (factor1 * (y3 - y4) - factor2 * (y1 - y2)) / denominator;
        return this.newPoint(x, y);
    }

    private KVector newPoint(double x, double y) {
        return new KVector(x, y);
    }

    private KVectorChain adjustFirstSegment(ElkNode source, KVectorChain chain, DCDirection dir) {
        KVector firstPoint = (KVector)chain.remove();
        switch (dir) {
            case NORTH: {
                firstPoint.y = 0.0;
                break;
            }
            case SOUTH: {
                firstPoint.y = source.getHeight();
                break;
            }
            case WEST: {
                firstPoint.x = 0.0;
                break;
            }
            default: {
                firstPoint.x = source.getWidth();
            }
        }
        chain.add(0, (Object)firstPoint);
        return chain;
    }

    private class OffsetApplier
    implements BiConsumer<ElkGraphElement, DCElement> {
        private KVector offset;

        private OffsetApplier() {
        }

        @Override
        public void accept(ElkGraphElement elem, DCElement poly) {
            this.offset = poly.getOffset();
            if (elem instanceof ElkEdge) {
                ElkEdgeSection edgeSection = ElkGraphUtil.firstEdgeSection((ElkEdge)((ElkEdge)elem), (boolean)false, (boolean)false);
                KVectorChain points = ElkUtil.createVectorChain((ElkEdgeSection)edgeSection);
                OffSetToChainApplier applier = new OffSetToChainApplier();
                points.forEach((Consumer)applier);
                ElkUtil.applyVectorChain((KVectorChain)points, (ElkEdgeSection)edgeSection);
                if (elem.getProperty(CoreOptions.JUNCTION_POINTS) != null) {
                    ((KVectorChain)elem.getProperty(CoreOptions.JUNCTION_POINTS)).forEach((Consumer)applier);
                }
            } else {
                ElkShape shape = (ElkShape)elem;
                shape.setX(shape.getX() + this.offset.x);
                shape.setY(shape.getY() + this.offset.y);
            }
        }

        private class OffSetToChainApplier
        implements Consumer<KVector> {
            private OffSetToChainApplier() {
            }

            @Override
            public void accept(KVector point) {
                point.add(OffsetApplier.this.offset.x, OffsetApplier.this.offset.y);
            }
        }
    }
}

