/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.preferences;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.editors.IDialogFieldListener;
import org.eclipse.fordiac.ide.ui.editors.SelectionButtonDialogField;
import org.eclipse.fordiac.ide.ui.preferences.PreferenceStoreProvider;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class FordiacPropertyPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private ControlEnableState fBlockEnableState;
    private Link fChangeWorkspaceSettings;
    private SelectionButtonDialogField fUseProjectSettings;
    private Composite fParentComposite;
    protected IProject fProject;
    private Map<String, Object> fData;
    public static final String DATA_NO_LINK = "PropertyAndPreferencePage.nolink";
    protected PreferenceStoreProvider provider;
    private final String qualifier;

    protected FordiacPropertyPreferencePage(int style, String qualifier) {
        super(style);
        this.qualifier = qualifier;
        this.fBlockEnableState = null;
        this.fProject = null;
        this.fData = null;
    }

    protected abstract String getPreferencePageID();

    protected abstract String getPropertyPageID();

    protected boolean supportsProjectSpecificOptions() {
        return this.getPropertyPageID() != null;
    }

    protected boolean offerLink() {
        return this.fData == null || !Boolean.TRUE.equals(this.fData.get(DATA_NO_LINK));
    }

    protected Label createDescriptionLabel(Composite parent) {
        this.fParentComposite = parent;
        if (this.isProjectPreferencePage()) {
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            IDialogFieldListener listener = field -> {
                boolean enabled = ((SelectionButtonDialogField)field).isSelected();
                this.enableProjectSpecificSettings(enabled);
                if (enabled && this.getData() != null) {
                    this.applyData(this.getData());
                }
            };
            this.fUseProjectSettings = new SelectionButtonDialogField(32);
            this.fUseProjectSettings.setDialogFieldListener(listener);
            this.fUseProjectSettings.setLabelText(FordiacMessages.PropertyAndPreferencePage_useprojectsettings_label);
            this.fUseProjectSettings.doFillIntoGrid(composite, 1);
            Object obj = this.fUseProjectSettings.getSelectionButton(null).getLayoutData();
            if (obj instanceof GridData) {
                GridData gd = (GridData)obj;
                gd.grabExcessHorizontalSpace = true;
            }
            if (this.offerLink()) {
                this.fChangeWorkspaceSettings = this.createLink(composite, FordiacMessages.PropertyAndPreferencePage_useworkspacesettings_change);
                this.fChangeWorkspaceSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            } else {
                Button control = this.fUseProjectSettings.getSelectionButton(null);
                Object ld = control.getLayoutData();
                if (ld instanceof GridData) {
                    GridData gd = (GridData)ld;
                    gd.horizontalSpan = 2;
                } else {
                    GridData gd = new GridData();
                    gd.horizontalSpan = 2;
                    control.setLayoutData((Object)gd);
                }
            }
            Label horizontalLine = new Label(composite, 258);
            horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            horizontalLine.setFont(composite.getFont());
        } else if (this.supportsProjectSpecificOptions() && this.offerLink()) {
            this.fChangeWorkspaceSettings = this.createLink(parent, FordiacMessages.PropertyAndPreferencePage_showprojectspecificsettings_label);
            this.fChangeWorkspaceSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        }
        return super.createDescriptionLabel(parent);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.isProjectPreferencePage()) {
            this.enableProjectSpecificSettings(this.provider.isProjectStoreActive());
        }
        return control;
    }

    private Link createLink(Composite composite, String text) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FordiacPropertyPreferencePage.this.doLinkActivated((Link)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                FordiacPropertyPreferencePage.this.doLinkActivated((Link)e.widget);
            }
        });
        return link;
    }

    protected boolean useProjectSettings() {
        return this.isProjectPreferencePage() && this.fUseProjectSettings != null && this.fUseProjectSettings.isSelected();
    }

    protected boolean isProjectPreferencePage() {
        return this.fProject != null;
    }

    protected IProject getProject() {
        return this.fProject;
    }

    final void doLinkActivated(Link link) {
        Map<String, Object> data = this.getData();
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        data.put(DATA_NO_LINK, Boolean.TRUE);
        if (this.isProjectPreferencePage()) {
            this.openWorkspacePreferences(data);
        } else {
            LinkedList<IProject> projects = new LinkedList<IProject>();
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject proj = iProjectArray[n2];
                try {
                    if (proj.hasNature("org.eclipse.fordiac.ide.systemmanagement.FordiacNature")) {
                        projects.add(proj);
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                ++n2;
            }
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider());
            dialog.setTitle(FordiacMessages.PropertyAndPreferencePage_ChooseProjectDialog_title);
            dialog.setMessage(FordiacMessages.PropertyAndPreferencePage_ChooseProjectDialog_description);
            dialog.setElements(projects.toArray());
            dialog.setHelpAvailable(false);
            if (dialog.open() == 0) {
                IProject res = (IProject)dialog.getFirstResult();
                this.openProjectProperties(res, data);
            }
        }
    }

    protected final void openWorkspacePreferences(Object data) {
        String id = this.getPreferencePageID();
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, (Object)data).open();
    }

    protected final void openProjectProperties(IProject project, Object data) {
        String id = this.getPropertyPageID();
        if (id != null) {
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)project, (String)id, (String[])new String[]{id}, (Object)data).open();
        }
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        this.fUseProjectSettings.setSelection(useProjectSpecificSettings);
        this.provider.setProjectStoreActive(useProjectSpecificSettings);
        this.enablePreferenceContent(useProjectSpecificSettings);
        this.updateLinkVisibility();
    }

    private void updateLinkVisibility() {
        if (this.fChangeWorkspaceSettings == null || this.fChangeWorkspaceSettings.isDisposed()) {
            return;
        }
        if (this.isProjectPreferencePage()) {
            this.fChangeWorkspaceSettings.setEnabled(!this.useProjectSettings());
        }
    }

    protected void enablePreferenceContent(boolean enable) {
        if (enable) {
            if (this.fBlockEnableState != null) {
                this.fBlockEnableState.restore();
                this.fBlockEnableState = null;
            }
        } else if (this.fBlockEnableState == null) {
            this.fBlockEnableState = ControlEnableState.disable((Control)this.getFieldEditorParent());
        }
    }

    protected void performDefaults() {
        if (this.useProjectSettings()) {
            this.enableProjectSpecificSettings(false);
        }
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
        this.provider = new PreferenceStoreProvider(this.qualifier, null);
    }

    public IAdaptable getElement() {
        return this.fProject;
    }

    public void setElement(IAdaptable element) {
        IResource resource = (IResource)element.getAdapter(IResource.class);
        this.fProject = resource != null ? resource.getProject() : null;
        this.provider = new PreferenceStoreProvider(this.qualifier, this.fProject);
    }

    public void applyData(Object data) {
        if (data instanceof Map) {
            this.fData = (Map)data;
        }
        if (this.fChangeWorkspaceSettings != null && !this.offerLink()) {
            this.fChangeWorkspaceSettings.dispose();
            this.fParentComposite.layout(true, true);
        }
    }

    protected Map<String, Object> getData() {
        return this.fData;
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.isProjectPreferencePage()) {
            return this.provider.getProjectStore();
        }
        return this.provider.getInstanceStore();
    }
}

