# Contributing to Eclipse 4DIAC

Thanks for your interest in this project.

## Project description

Eclipse 4diac™ in its current form has been started 2007 as an open source
project fostering the further development of IEC 61499 for its use in
distributed Industrial Process Measurement and Control Systems (IPMCS) and to
further distribute research results from the original contributors. From the
beginning, it has provided everything that is necessary to program and execute
distributed IPMCS.

* https://projects.eclipse.org/projects/iot.4diac

## Developer resources

Information regarding source code management, builds, coding standards, and
more.

* https://projects.eclipse.org/projects/iot.4diac/developer

The project maintains the following source code repositories

* https://git.eclipse.org/r/plugins/gitiles/4diac/org.eclipse.4diac.examples
* https://git.eclipse.org/r/plugins/gitiles/4diac/org.eclipse.4diac.forte
* https://git.eclipse.org/r/plugins/gitiles/4diac/org.eclipse.4diac.ide

This project uses Bugzilla to track ongoing development and issues.

* Search for issues: https://bugs.eclipse.org/bugs/buglist.cgi?product=4DIAC
* Create a new report:
   https://bugs.eclipse.org/bugs/enter_bug.cgi?product=4DIAC

Be sure to search for existing bugs before you create another one. Remember that
contributions are always welcome!

An overview on what kinds of contributions are possible can be found here:
* https://www.eclipse.org/4diac/en_contribute.php

A detailed decomentation of the contribution process here:
* https://www.eclipse.org/4diac/en_help.php?helppage=html/development/contribute.html


## Eclipse Development Process

This Eclipse Foundation open project is governed by the Eclipse Foundation
Development Process and operates under the terms of the Eclipse IP Policy.

* https://eclipse.org/projects/dev_process
* https://www.eclipse.org/org/documents/Eclipse_IP_Policy.pdf

## Eclipse Contributor Agreement

In order to be able to contribute to Eclipse Foundation projects you must
electronically sign the Eclipse Contributor Agreement (ECA).

* http://www.eclipse.org/legal/ECA.php

The ECA provides the Eclipse Foundation with a permanent record that you agree
that each of your contributions will comply with the commitments documented in
the Developer Certificate of Origin (DCO). Having an ECA on file associated with
the email address matching the "Author" field of your contribution's Git commits
fulfills the DCO's requirement that you sign-off on your contributions.

For more information, please see the Eclipse Committer Handbook:
https://www.eclipse.org/projects/handbook/#resources-commit

## Contact

Contact the project developers via the project's "dev" list.

* https://dev.eclipse.org/mailman/listinfo/4diac-dev