/*
 * This file is part of the Vamsas Client version 0.2. 
 * Copyright 2010 by Jim Procter, Iain Milne, Pierre Marguerite, 
 *  Andrew Waterhouse and Dominik Lindner.
 * 
 * Earlier versions have also been incorporated into Jalview version 2.4 
 * since 2008, and TOPALi version 2 since 2007.
 * 
 * The Vamsas Client is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *  
 * The Vamsas Client is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with the Vamsas Client.  If not, see <http://www.gnu.org/licenses/>.
 */
package uk.ac.vamsas.client;

/**
 * Enumerates the event types generated during the lifecycle of a Vamsas
 * session. See the excel spreadsheet in
 * VamsasClient/docs/VamsasSessionEventAnalysis.xls for some more information
 * about when these are generated and how they should be handled.
 * 
 */

public class Events {
  /**
   * Generated when a client has finished updating the document. Client which
   * has completed an update should not receive the event. NewValue:
   * uk.ac.vamsas.client.IClient for session.
   */
  public static final String DOCUMENT_UPDATE = "uk.ac.vamsas.client.events.documentUpdateEvent";

  /**
   * Generated when a new vamsas document is created (perhaps from some existing
   * Vamsas data) so an application may do its own data space initialization.
   * Raised for a new application connecting to a vamsas document NewValue:
   * uk.ac.vamsas.client.IClient for session. LATER: DOCUMENT_CREATE event may
   * be redundant
   */
  public static final String DOCUMENT_CREATE = "uk.ac.vamsas.client.events.documentCreateEvent";

  /**
   * Generated when a new vamsas client is attached to a session (Handle is
   * passed) Note: the newly created client does not receive the event.
   */
  public static final String CLIENT_CREATION = "uk.ac.vamsas.client.events.clientCreateEvent";

  /**
   * Generated when a vamsas client leaves a session (Handle is passed to all
   * others).
   */
  public static final String CLIENT_FINALIZATION = "uk.ac.vamsas.client.events.clientFinalizationEvent";

  /**
   * Generated prior to session Shutdown, after the last participating vamsas
   * client has finalized. Probably only useful to IClientFactory
   * implementations. NewValue: <Vamsas-session URN>
   */
  public static final String SESSION_SHUTDOWN = "uk.ac.vamsas.client.events.SessionShutdownEvent";

  /**
   * Generated for all clients when any client calls IClient.storeDocument() to
   * allow them to store any updates before an offline copy of the session is
   * created. Any client that handles this should call the
   * IClient.getDocument(), update and then IClient.updateDocument in the same
   * handler thread (the lock on the document is held until the handler exits).
   * EventName: <Vamsas-session URN> NewValue: uk.ac.vamsas.client.IClient for
   * session.
   */
  public static final String DOCUMENT_FINALIZEAPPDATA = "uk.ac.vamsas.client.events.DocumentFinalizeAppData";

  /**
   * Generated by Vorba stub for the sole remaining client instance in a
   * session, when it makes a call to finalizeClient(). It is only raised if the
   * session has been modified since the last call to storeDocument() by any
   * application. LATER: copies of a document should be on a per-user basis for
   * multi-user sessions. Sequence is as follows : 1. All other vamsas clients
   * have called finalizeClient() 2. Final living client monitors closures, and
   * realises that it is last. 3. Final client generates event to prompt
   * associated application to inquire if the user wishes to save the document
   * for future reference. * Any call to finalizeClient in a thread other than
   * the registered EventListener will block until the RequestToClose handler
   * has exited. NewValue: uk.ac.vamsas.client.IClient for session.
   */
  public static final String DOCUMENT_REQUESTTOCLOSE = "uk.ac.vamas.client.DocumentRequestToCloseEvent";

  public static java.util.Vector EventList = initList();

  private static java.util.Vector initList() {
    java.util.Vector vec = new java.util.Vector();
    vec.add((Object) DOCUMENT_UPDATE);
    vec.add((Object) DOCUMENT_CREATE);
    vec.add((Object) CLIENT_CREATION);
    vec.add((Object) CLIENT_FINALIZATION);
    vec.add((Object) SESSION_SHUTDOWN);
    vec.add((Object) DOCUMENT_REQUESTTOCLOSE);
    vec.add((Object) DOCUMENT_FINALIZEAPPDATA);
    return vec;
  }
}
