=begin
#OpenBao API

#HTTP API that gives you full access to OpenBao. All API routes are prefixed with `/v1/`.

The version of the OpenAPI document: 2.0.0

Generated by: https://openapi-generator.tech
Generator version: 7.7.0

=end

require 'date'
require 'time'

module OpenbaoClient
  class PkiConfigureAutoTidyRequest
    # The amount of time that must pass after creation that an account with no orders is marked revoked, and the amount of time after being marked revoked or deactivated.
    attr_accessor :acme_account_safety_buffer

    # Set to true to enable automatic tidy operations.
    attr_accessor :enabled

    # Interval at which to run an auto-tidy operation. This is the time between tidy invocations (after one finishes to the start of the next). Running a manual tidy will reset this duration.
    attr_accessor :interval_duration

    # The amount of extra time that must have passed beyond issuer's expiration before it is removed from the backend storage. Defaults to 8760 hours (1 year).
    attr_accessor :issuer_safety_buffer

    # This configures whether stored certificates are counted upon initialization of the backend, and whether during normal operation, a running count of certificates stored is maintained.
    attr_accessor :maintain_stored_certificate_counts

    # The amount of time to wait between processing certificates. This allows operators to change the execution profile of tidy to take consume less resources by slowing down how long it takes to run. Note that the entire list of certificates will be stored in memory during the entire tidy operation, but resources to read/process/update existing entries will be spread out over a greater period of time. By default this is zero seconds.
    attr_accessor :pause_duration

    # This configures whether the stored certificate count is published to the metrics consumer. It does not affect if the stored certificate count is maintained, and if maintained, it will be available on the tidy-status endpoint.
    attr_accessor :publish_stored_certificate_count_metrics

    # The amount of time that must pass from the cross-cluster revocation request being initiated to when it will be slated for removal. Setting this too low may remove valid revocation requests before the owning cluster has a chance to process them, especially if the cluster is offline.
    attr_accessor :revocation_queue_safety_buffer

    # The amount of extra time that must have passed beyond certificate expiration before it is removed from the backend storage and/or revocation list. Defaults to 72 hours.
    attr_accessor :safety_buffer

    # Set to true to enable tidying ACME accounts, orders and authorizations. ACME orders are tidied (deleted) safety_buffer after the certificate associated with them expires, or after the order and relevant authorizations have expired if no certificate was produced. Authorizations are tidied with the corresponding order. When a valid ACME Account is at least acme_account_safety_buffer old, and has no remaining orders associated with it, the account is marked as revoked. After another acme_account_safety_buffer has passed from the revocation or deactivation date, a revoked or deactivated ACME account is deleted.
    attr_accessor :tidy_acme

    # Set to true to enable tidying up the certificate store
    attr_accessor :tidy_cert_store

    # Set to true to enable tidying up the cross-cluster revoked certificate store. Only runs on the active primary node.
    attr_accessor :tidy_cross_cluster_revoked_certs

    # Set to true to automatically remove expired issuers past the issuer_safety_buffer. No keys will be removed as part of this operation.
    attr_accessor :tidy_expired_issuers

    # Set to true to move the legacy ca_bundle from /config/ca_bundle to /config/ca_bundle.bak. This prevents downgrades to pre-Vault 1.11 versions (before the OpenBao fork -- as older PKI engines do not know about the new multi-issuer storage layout), but improves the performance on seal wrapped PKI mounts. This will only occur if at least issuer_safety_buffer time has occurred after the initial storage migration. This backup is saved in case of an issue in future migrations. Operators may consider removing it via sys/raw if they desire. The backup will be removed via a DELETE /root call, but note that this removes ALL issuers within the mount (and is thus not desirable in most operational scenarios).
    attr_accessor :tidy_move_legacy_ca_bundle

    # Deprecated; synonym for 'tidy_revoked_certs
    attr_accessor :tidy_revocation_list

    # Set to true to remove stale revocation queue entries that haven't been confirmed by any active cluster. Only runs on the active primary node
    attr_accessor :tidy_revocation_queue

    # Set to true to validate issuer associations on revocation entries. This helps increase the performance of CRL building and OCSP responses.
    attr_accessor :tidy_revoked_cert_issuer_associations

    # Set to true to expire all revoked and expired certificates, removing them both from the CRL and from storage. The CRL will be rotated if this causes any values to be removed.
    attr_accessor :tidy_revoked_certs

    # Attribute mapping from ruby-style variable name to JSON key.
    def self.attribute_map
      {
        :'acme_account_safety_buffer' => :'acme_account_safety_buffer',
        :'enabled' => :'enabled',
        :'interval_duration' => :'interval_duration',
        :'issuer_safety_buffer' => :'issuer_safety_buffer',
        :'maintain_stored_certificate_counts' => :'maintain_stored_certificate_counts',
        :'pause_duration' => :'pause_duration',
        :'publish_stored_certificate_count_metrics' => :'publish_stored_certificate_count_metrics',
        :'revocation_queue_safety_buffer' => :'revocation_queue_safety_buffer',
        :'safety_buffer' => :'safety_buffer',
        :'tidy_acme' => :'tidy_acme',
        :'tidy_cert_store' => :'tidy_cert_store',
        :'tidy_cross_cluster_revoked_certs' => :'tidy_cross_cluster_revoked_certs',
        :'tidy_expired_issuers' => :'tidy_expired_issuers',
        :'tidy_move_legacy_ca_bundle' => :'tidy_move_legacy_ca_bundle',
        :'tidy_revocation_list' => :'tidy_revocation_list',
        :'tidy_revocation_queue' => :'tidy_revocation_queue',
        :'tidy_revoked_cert_issuer_associations' => :'tidy_revoked_cert_issuer_associations',
        :'tidy_revoked_certs' => :'tidy_revoked_certs'
      }
    end

    # Returns all the JSON keys this model knows about
    def self.acceptable_attributes
      attribute_map.values
    end

    # Attribute type mapping.
    def self.openapi_types
      {
        :'acme_account_safety_buffer' => :'Integer',
        :'enabled' => :'Boolean',
        :'interval_duration' => :'Integer',
        :'issuer_safety_buffer' => :'Integer',
        :'maintain_stored_certificate_counts' => :'Boolean',
        :'pause_duration' => :'String',
        :'publish_stored_certificate_count_metrics' => :'Boolean',
        :'revocation_queue_safety_buffer' => :'Integer',
        :'safety_buffer' => :'Integer',
        :'tidy_acme' => :'Boolean',
        :'tidy_cert_store' => :'Boolean',
        :'tidy_cross_cluster_revoked_certs' => :'Boolean',
        :'tidy_expired_issuers' => :'Boolean',
        :'tidy_move_legacy_ca_bundle' => :'Boolean',
        :'tidy_revocation_list' => :'Boolean',
        :'tidy_revocation_queue' => :'Boolean',
        :'tidy_revoked_cert_issuer_associations' => :'Boolean',
        :'tidy_revoked_certs' => :'Boolean'
      }
    end

    # List of attributes with nullable: true
    def self.openapi_nullable
      Set.new([
      ])
    end

    # Initializes the object
    # @param [Hash] attributes Model attributes in the form of hash
    def initialize(attributes = {})
      if (!attributes.is_a?(Hash))
        fail ArgumentError, "The input argument (attributes) must be a hash in `OpenbaoClient::PkiConfigureAutoTidyRequest` initialize method"
      end

      # check to see if the attribute exists and convert string to symbol for hash key
      attributes = attributes.each_with_object({}) { |(k, v), h|
        if (!self.class.attribute_map.key?(k.to_sym))
          fail ArgumentError, "`#{k}` is not a valid attribute in `OpenbaoClient::PkiConfigureAutoTidyRequest`. Please check the name to make sure it's valid. List of attributes: " + self.class.attribute_map.keys.inspect
        end
        h[k.to_sym] = v
      }

      if attributes.key?(:'acme_account_safety_buffer')
        self.acme_account_safety_buffer = attributes[:'acme_account_safety_buffer']
      else
        self.acme_account_safety_buffer = 2592000
      end

      if attributes.key?(:'enabled')
        self.enabled = attributes[:'enabled']
      end

      if attributes.key?(:'interval_duration')
        self.interval_duration = attributes[:'interval_duration']
      else
        self.interval_duration = 43200
      end

      if attributes.key?(:'issuer_safety_buffer')
        self.issuer_safety_buffer = attributes[:'issuer_safety_buffer']
      else
        self.issuer_safety_buffer = 31536000
      end

      if attributes.key?(:'maintain_stored_certificate_counts')
        self.maintain_stored_certificate_counts = attributes[:'maintain_stored_certificate_counts']
      else
        self.maintain_stored_certificate_counts = false
      end

      if attributes.key?(:'pause_duration')
        self.pause_duration = attributes[:'pause_duration']
      else
        self.pause_duration = '0s'
      end

      if attributes.key?(:'publish_stored_certificate_count_metrics')
        self.publish_stored_certificate_count_metrics = attributes[:'publish_stored_certificate_count_metrics']
      else
        self.publish_stored_certificate_count_metrics = false
      end

      if attributes.key?(:'revocation_queue_safety_buffer')
        self.revocation_queue_safety_buffer = attributes[:'revocation_queue_safety_buffer']
      else
        self.revocation_queue_safety_buffer = 172800
      end

      if attributes.key?(:'safety_buffer')
        self.safety_buffer = attributes[:'safety_buffer']
      else
        self.safety_buffer = 259200
      end

      if attributes.key?(:'tidy_acme')
        self.tidy_acme = attributes[:'tidy_acme']
      else
        self.tidy_acme = false
      end

      if attributes.key?(:'tidy_cert_store')
        self.tidy_cert_store = attributes[:'tidy_cert_store']
      end

      if attributes.key?(:'tidy_cross_cluster_revoked_certs')
        self.tidy_cross_cluster_revoked_certs = attributes[:'tidy_cross_cluster_revoked_certs']
      end

      if attributes.key?(:'tidy_expired_issuers')
        self.tidy_expired_issuers = attributes[:'tidy_expired_issuers']
      end

      if attributes.key?(:'tidy_move_legacy_ca_bundle')
        self.tidy_move_legacy_ca_bundle = attributes[:'tidy_move_legacy_ca_bundle']
      end

      if attributes.key?(:'tidy_revocation_list')
        self.tidy_revocation_list = attributes[:'tidy_revocation_list']
      end

      if attributes.key?(:'tidy_revocation_queue')
        self.tidy_revocation_queue = attributes[:'tidy_revocation_queue']
      else
        self.tidy_revocation_queue = false
      end

      if attributes.key?(:'tidy_revoked_cert_issuer_associations')
        self.tidy_revoked_cert_issuer_associations = attributes[:'tidy_revoked_cert_issuer_associations']
      end

      if attributes.key?(:'tidy_revoked_certs')
        self.tidy_revoked_certs = attributes[:'tidy_revoked_certs']
      end
    end

    # Show invalid properties with the reasons. Usually used together with valid?
    # @return Array for valid properties with the reasons
    def list_invalid_properties
      warn '[DEPRECATED] the `list_invalid_properties` method is obsolete'
      invalid_properties = Array.new
      invalid_properties
    end

    # Check to see if the all the properties in the model are valid
    # @return true if the model is valid
    def valid?
      warn '[DEPRECATED] the `valid?` method is obsolete'
      true
    end

    # Checks equality by comparing each attribute.
    # @param [Object] Object to be compared
    def ==(o)
      return true if self.equal?(o)
      self.class == o.class &&
          acme_account_safety_buffer == o.acme_account_safety_buffer &&
          enabled == o.enabled &&
          interval_duration == o.interval_duration &&
          issuer_safety_buffer == o.issuer_safety_buffer &&
          maintain_stored_certificate_counts == o.maintain_stored_certificate_counts &&
          pause_duration == o.pause_duration &&
          publish_stored_certificate_count_metrics == o.publish_stored_certificate_count_metrics &&
          revocation_queue_safety_buffer == o.revocation_queue_safety_buffer &&
          safety_buffer == o.safety_buffer &&
          tidy_acme == o.tidy_acme &&
          tidy_cert_store == o.tidy_cert_store &&
          tidy_cross_cluster_revoked_certs == o.tidy_cross_cluster_revoked_certs &&
          tidy_expired_issuers == o.tidy_expired_issuers &&
          tidy_move_legacy_ca_bundle == o.tidy_move_legacy_ca_bundle &&
          tidy_revocation_list == o.tidy_revocation_list &&
          tidy_revocation_queue == o.tidy_revocation_queue &&
          tidy_revoked_cert_issuer_associations == o.tidy_revoked_cert_issuer_associations &&
          tidy_revoked_certs == o.tidy_revoked_certs
    end

    # @see the `==` method
    # @param [Object] Object to be compared
    def eql?(o)
      self == o
    end

    # Calculates hash code according to all attributes.
    # @return [Integer] Hash code
    def hash
      [acme_account_safety_buffer, enabled, interval_duration, issuer_safety_buffer, maintain_stored_certificate_counts, pause_duration, publish_stored_certificate_count_metrics, revocation_queue_safety_buffer, safety_buffer, tidy_acme, tidy_cert_store, tidy_cross_cluster_revoked_certs, tidy_expired_issuers, tidy_move_legacy_ca_bundle, tidy_revocation_list, tidy_revocation_queue, tidy_revoked_cert_issuer_associations, tidy_revoked_certs].hash
    end

    # Builds the object from hash
    # @param [Hash] attributes Model attributes in the form of hash
    # @return [Object] Returns the model itself
    def self.build_from_hash(attributes)
      return nil unless attributes.is_a?(Hash)
      attributes = attributes.transform_keys(&:to_sym)
      transformed_hash = {}
      openapi_types.each_pair do |key, type|
        if attributes.key?(attribute_map[key]) && attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = nil
        elsif type =~ /\AArray<(.*)>/i
          # check to ensure the input is an array given that the attribute
          # is documented as an array but the input is not
          if attributes[attribute_map[key]].is_a?(Array)
            transformed_hash["#{key}"] = attributes[attribute_map[key]].map { |v| _deserialize($1, v) }
          end
        elsif !attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = _deserialize(type, attributes[attribute_map[key]])
        end
      end
      new(transformed_hash)
    end

    # Deserializes the data based on type
    # @param string type Data type
    # @param string value Value to be deserialized
    # @return [Object] Deserialized data
    def self._deserialize(type, value)
      case type.to_sym
      when :Time
        Time.parse(value)
      when :Date
        Date.parse(value)
      when :String
        value.to_s
      when :Integer
        value.to_i
      when :Float
        value.to_f
      when :Boolean
        if value.to_s =~ /\A(true|t|yes|y|1)\z/i
          true
        else
          false
        end
      when :Object
        # generic object (usually a Hash), return directly
        value
      when /\AArray<(?<inner_type>.+)>\z/
        inner_type = Regexp.last_match[:inner_type]
        value.map { |v| _deserialize(inner_type, v) }
      when /\AHash<(?<k_type>.+?), (?<v_type>.+)>\z/
        k_type = Regexp.last_match[:k_type]
        v_type = Regexp.last_match[:v_type]
        {}.tap do |hash|
          value.each do |k, v|
            hash[_deserialize(k_type, k)] = _deserialize(v_type, v)
          end
        end
      else # model
        # models (e.g. Pet) or oneOf
        klass = OpenbaoClient.const_get(type)
        klass.respond_to?(:openapi_any_of) || klass.respond_to?(:openapi_one_of) ? klass.build(value) : klass.build_from_hash(value)
      end
    end

    # Returns the string representation of the object
    # @return [String] String presentation of the object
    def to_s
      to_hash.to_s
    end

    # to_body is an alias to to_hash (backward compatibility)
    # @return [Hash] Returns the object in the form of hash
    def to_body
      to_hash
    end

    # Returns the object in the form of hash
    # @return [Hash] Returns the object in the form of hash
    def to_hash
      hash = {}
      self.class.attribute_map.each_pair do |attr, param|
        value = self.send(attr)
        if value.nil?
          is_nullable = self.class.openapi_nullable.include?(attr)
          next if !is_nullable || (is_nullable && !instance_variable_defined?(:"@#{attr}"))
        end

        hash[param] = _to_hash(value)
      end
      hash
    end

    # Outputs non-array value in the form of hash
    # For object, use to_hash. Otherwise, just return the value
    # @param [Object] value Any valid value
    # @return [Hash] Returns the value in the form of hash
    def _to_hash(value)
      if value.is_a?(Array)
        value.compact.map { |v| _to_hash(v) }
      elsif value.is_a?(Hash)
        {}.tap do |hash|
          value.each { |k, v| hash[k] = _to_hash(v) }
        end
      elsif value.respond_to? :to_hash
        value.to_hash
      else
        value
      end
    end

  end

end
