# frozen_string_literal: true

class CreateIndexForVulnerabilityFeedbackPipelineIdConvertToBigint < Gitlab::Database::Migration[2.2]
  milestone '17.0'
  disable_ddl_transaction!

  TABLE_NAME = :vulnerability_feedback
  INDEX_NAME = :index_vulnerability_feedback_on_pipeline_id_bigint
  COLUMN_NAME = :pipeline_id_convert_to_bigint

  def up
    add_concurrent_index TABLE_NAME, COLUMN_NAME, name: INDEX_NAME
  end

  def down
    remove_concurrent_index_by_name TABLE_NAME, name: INDEX_NAME
  end
end
