#!BPY
# -*- coding: latin-1 -*-
"""
Name: 'Twisted Torus'
Blender: 243
Group: 'AddMesh'
"""

__author__ = ["paulo_gomes"]
__version__ = '1.00'
__url__ = ["http://wiki.blender.org/index.php/Extensions:Py/Scripts/Manual/Add/Twisted_Torus"]

__bpydoc__ = """

Usage:

* Launch from Add Mesh menu

* Modify parameters as desired or keep defaults

"""

# ***** BEGIN GPL LICENSE BLOCK *****
#
# Copyright (C) 2008, paulo_gomes
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****
import BPyAddMesh
import Blender
from math import cos, sin, pi

def add_torus(Raio_Torus, Raio_Circulo, Seccoes_Torus, Vertices_Circulo, Voltas):
    Vector = Blender.Mathutils.Vector
    RotationMatrix = Blender.Mathutils.RotationMatrix
    vertices = []
    faces = []
    i1 = 0
    total_vertices = Seccoes_Torus * Vertices_Circulo

    for major_index in xrange(Seccoes_Torus):
        mtx = RotationMatrix( 360 * float(major_index)/Seccoes_Torus, 3,  'z' )
        rotvoltas = 2*pi*major_index/Seccoes_Torus * Voltas
        
        for minor_index in xrange(Vertices_Circulo):
            angle = (2*pi*minor_index/Vertices_Circulo) + rotvoltas
            
            print mtx
            vertices.append( Vector(Raio_Torus+(cos(angle)*Raio_Circulo), 0, (sin(angle)*Raio_Circulo)) * mtx )
            
            if minor_index+1==Vertices_Circulo:
                i2 = (major_index)*Vertices_Circulo
                i3 = i1 + Vertices_Circulo
                i4 = i2 + Vertices_Circulo
                
            else:
                i2 = i1 + 1
                i3 = i1 + Vertices_Circulo
                i4 = i3 + 1
            
            if i2>=total_vertices:    i2 = i2-total_vertices
            if i3>=total_vertices:    i3 = i3-total_vertices
            if i4>=total_vertices:    i4 = i4-total_vertices
            faces.append( (i3,i4,i2,i1) )
            i1+=1
                
    return vertices, faces

def main():

    Draw = Blender.Draw
    Raio_Torus = Draw.Create(1.0)        # Raio do torus
    Raio_Circulo = Draw.Create(0.25)        # Raio do circulo que vai formar o torus
    Seccao_Torus = Draw.Create(48)        # Nº de secções do torus
    Vertices_Circulo = Draw.Create(16)    # Nº de vertices do circulo q vai formar o torus
    Voltas = Draw.Create(1)            # Nº de voltas

    if not Draw.PupBlock('Adiciona Twisted Torus', [\
    ('Raio do Torus:', Raio_Torus,  0.01, 100, ''),\
    ('Raio do Circulo:', Raio_Circulo,  0.01, 100, ''),\
    ('Seccoes do Torus:', Seccao_Torus,  3, 256, ''),\
    ('Vertices do Circulo:', Vertices_Circulo,  3, 256, ''),\
    ('N. de Voltas:', Voltas,  0, 5, ''),\
    ]):
        return
    
    # Chama a função add_torus e atribui o resultado nas variáveis vertices e faces
    vertices, faces = add_torus(Raio_Torus.val, Raio_Circulo.val, Seccao_Torus.val, Vertices_Circulo.val, Voltas.val)
            
    # Função para adicionar uma mesh
    BPyAddMesh.add_mesh_simple('Torus', vertices, [], faces)

main()
