/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.copilot.dto;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotMessage;

public record CopilotChatRequest(String model, boolean intent, List<CopilotMessage> messages, boolean stream, int n, @SerializedName(value="top_p") int topP, double temperature) {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String model;
        private boolean intent;
        private List<CopilotMessage> messages;
        private boolean stream;
        private int n;
        private int topP;
        private double temperature;

        public Builder withModel(String model) {
            this.model = model;
            return this;
        }

        public Builder withIntent(boolean intent) {
            this.intent = intent;
            return this;
        }

        public Builder withMessages(List<CopilotMessage> messages) {
            this.messages = messages;
            return this;
        }

        public Builder withStream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public Builder withN(int n) {
            this.n = n;
            return this;
        }

        public Builder withTopP(int topP) {
            this.topP = topP;
            return this;
        }

        public Builder withTemperature(double temperature) {
            this.temperature = temperature;
            return this;
        }

        public CopilotChatRequest build() {
            return new CopilotChatRequest(this.model, this.intent, this.messages, this.stream, this.n, this.topP, this.temperature);
        }
    }
}

