/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.dbcp.dbcp2.SwallowedExceptionLogger;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.dbcp2.datasources.CPDSConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyDataSource;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyDataSourceFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.PerUserPoolDataSourceFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.PoolKey;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.dbcp2.datasources.UserPassKey;
import org.apache.tomcat.dbcp.pool2.ObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.GenericObjectPool;

public class PerUserPoolDataSource
extends InstanceKeyDataSource {
    private static final long serialVersionUID = 7872747993848065028L;
    private static final Log log = LogFactory.getLog(PerUserPoolDataSource.class);
    private Map<String, Boolean> perUserBlockWhenExhausted;
    private Map<String, String> perUserEvictionPolicyClassName;
    private Map<String, Boolean> perUserLifo;
    private Map<String, Integer> perUserMaxIdle;
    private Map<String, Integer> perUserMaxTotal;
    private Map<String, Duration> perUserMaxWaitDuration;
    private Map<String, Duration> perUserMinEvictableIdleDuration;
    private Map<String, Integer> perUserMinIdle;
    private Map<String, Integer> perUserNumTestsPerEvictionRun;
    private Map<String, Duration> perUserSoftMinEvictableIdleDuration;
    private Map<String, Boolean> perUserTestOnCreate;
    private Map<String, Boolean> perUserTestOnBorrow;
    private Map<String, Boolean> perUserTestOnReturn;
    private Map<String, Boolean> perUserTestWhileIdle;
    private Map<String, Duration> perUserDurationBetweenEvictionRuns;
    private Map<String, Boolean> perUserDefaultAutoCommit;
    private Map<String, Integer> perUserDefaultTransactionIsolation;
    private Map<String, Boolean> perUserDefaultReadOnly;
    private transient Map<PoolKey, PooledConnectionManager> managers = PerUserPoolDataSource.createMap();

    private static <K, V> HashMap<K, V> createMap() {
        return new HashMap();
    }

    public void clear() {
        this.managers.values().forEach(pooledConnectionManager -> {
            try {
                this.getCPDSConnectionFactoryPool((PooledConnectionManager)pooledConnectionManager).clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        InstanceKeyDataSourceFactory.removeInstance(this.getInstanceKey());
    }

    @Override
    public void close() {
        this.managers.values().forEach(pooledConnectionManager -> Utils.closeQuietly(this.getCPDSConnectionFactoryPool((PooledConnectionManager)pooledConnectionManager)));
        InstanceKeyDataSourceFactory.removeInstance(this.getInstanceKey());
    }

    private Map<String, Duration> convertMap(Map<String, Duration> map, Map<String, Long> map2) {
        HashMap<String, Duration> hashMap = PerUserPoolDataSource.createMap();
        map2.forEach((string, l) -> hashMap.put((String)string, this.toDurationOrNull((Long)l)));
        if (map == null) {
            return hashMap;
        }
        map.clear();
        map.putAll(hashMap);
        return map;
    }

    private <V> V get(Map<String, V> map, String string) {
        return map != null ? (V)map.get(string) : null;
    }

    private <V> V get(Map<String, V> map, String string, Supplier<V> supplier) {
        V v = this.get(map, string);
        return v != null ? v : supplier.get();
    }

    @Override
    protected PooledConnectionManager getConnectionManager(UserPassKey userPassKey) {
        return this.managers.get(this.getPoolKey(userPassKey.getUserName()));
    }

    private ObjectPool<PooledConnectionAndInfo> getCPDSConnectionFactoryPool(PooledConnectionManager pooledConnectionManager) {
        return ((CPDSConnectionFactory)pooledConnectionManager).getPool();
    }

    public int getNumActive() {
        return this.getNumActive(null);
    }

    public int getNumActive(String string) {
        ObjectPool<PooledConnectionAndInfo> objectPool = this.getPool(this.getPoolKey(string));
        return objectPool == null ? 0 : objectPool.getNumActive();
    }

    public int getNumIdle() {
        return this.getNumIdle(null);
    }

    public int getNumIdle(String string) {
        ObjectPool<PooledConnectionAndInfo> objectPool = this.getPool(this.getPoolKey(string));
        return objectPool == null ? 0 : objectPool.getNumIdle();
    }

    public boolean getPerUserBlockWhenExhausted(String string) {
        return this.get(this.perUserBlockWhenExhausted, string, this::getDefaultBlockWhenExhausted);
    }

    public Boolean getPerUserDefaultAutoCommit(String string) {
        return this.get(this.perUserDefaultAutoCommit, string);
    }

    public Boolean getPerUserDefaultReadOnly(String string) {
        return this.get(this.perUserDefaultReadOnly, string);
    }

    public Integer getPerUserDefaultTransactionIsolation(String string) {
        return this.get(this.perUserDefaultTransactionIsolation, string);
    }

    public Duration getPerUserDurationBetweenEvictionRuns(String string) {
        return this.get(this.perUserDurationBetweenEvictionRuns, string, this::getDefaultDurationBetweenEvictionRuns);
    }

    public String getPerUserEvictionPolicyClassName(String string) {
        return this.get(this.perUserEvictionPolicyClassName, string, this::getDefaultEvictionPolicyClassName);
    }

    public boolean getPerUserLifo(String string) {
        return this.get(this.perUserLifo, string, this::getDefaultLifo);
    }

    public int getPerUserMaxIdle(String string) {
        return this.get(this.perUserMaxIdle, string, this::getDefaultMaxIdle);
    }

    public int getPerUserMaxTotal(String string) {
        return this.get(this.perUserMaxTotal, string, this::getDefaultMaxTotal);
    }

    public Duration getPerUserMaxWaitDuration(String string) {
        return this.get(this.perUserMaxWaitDuration, string, this::getDefaultMaxWait);
    }

    @Deprecated
    public long getPerUserMaxWaitMillis(String string) {
        return this.getPerUserMaxWaitDuration(string).toMillis();
    }

    public Duration getPerUserMinEvictableIdleDuration(String string) {
        return this.get(this.perUserMinEvictableIdleDuration, string, this::getDefaultMinEvictableIdleDuration);
    }

    @Deprecated
    public long getPerUserMinEvictableIdleTimeMillis(String string) {
        return this.getPerUserMinEvictableIdleDuration(string).toMillis();
    }

    public int getPerUserMinIdle(String string) {
        return this.get(this.perUserMinIdle, string, this::getDefaultMinIdle);
    }

    public int getPerUserNumTestsPerEvictionRun(String string) {
        return this.get(this.perUserNumTestsPerEvictionRun, string, this::getDefaultNumTestsPerEvictionRun);
    }

    public Duration getPerUserSoftMinEvictableIdleDuration(String string) {
        return this.get(this.perUserSoftMinEvictableIdleDuration, string, this::getDefaultSoftMinEvictableIdleDuration);
    }

    @Deprecated
    public long getPerUserSoftMinEvictableIdleTimeMillis(String string) {
        return this.getPerUserSoftMinEvictableIdleDuration(string).toMillis();
    }

    public boolean getPerUserTestOnBorrow(String string) {
        return this.get(this.perUserTestOnBorrow, string, this::getDefaultTestOnBorrow);
    }

    public boolean getPerUserTestOnCreate(String string) {
        return this.get(this.perUserTestOnCreate, string, this::getDefaultTestOnCreate);
    }

    public boolean getPerUserTestOnReturn(String string) {
        return this.get(this.perUserTestOnReturn, string, this::getDefaultTestOnReturn);
    }

    public boolean getPerUserTestWhileIdle(String string) {
        return this.get(this.perUserTestWhileIdle, string, this::getDefaultTestWhileIdle);
    }

    @Deprecated
    public long getPerUserTimeBetweenEvictionRunsMillis(String string) {
        return this.getPerUserDurationBetweenEvictionRuns(string).toMillis();
    }

    private ObjectPool<PooledConnectionAndInfo> getPool(PoolKey poolKey) {
        CPDSConnectionFactory cPDSConnectionFactory = (CPDSConnectionFactory)this.managers.get(poolKey);
        return cPDSConnectionFactory == null ? null : cPDSConnectionFactory.getPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PooledConnectionAndInfo getPooledConnectionAndInfo(String string, String string2) throws SQLException {
        ObjectPool<PooledConnectionAndInfo> objectPool;
        PooledConnectionManager pooledConnectionManager;
        PoolKey poolKey = this.getPoolKey(string);
        Object object = this;
        synchronized (object) {
            pooledConnectionManager = this.managers.get(poolKey);
            if (pooledConnectionManager == null) {
                try {
                    this.registerPool(string, string2);
                    pooledConnectionManager = this.managers.get(poolKey);
                }
                catch (NamingException namingException) {
                    throw new SQLException("RegisterPool failed", namingException);
                }
            }
            objectPool = this.getCPDSConnectionFactoryPool(pooledConnectionManager);
        }
        object = null;
        try {
            object = objectPool.borrowObject();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException("Could not retrieve connection info from pool", noSuchElementException);
        }
        catch (Exception exception) {
            try {
                this.testCPDS(string, string2);
            }
            catch (Exception exception2) {
                throw new SQLException("Could not retrieve connection info from pool", exception2);
            }
            pooledConnectionManager.closePool(string);
            PerUserPoolDataSource perUserPoolDataSource = this;
            synchronized (perUserPoolDataSource) {
                this.managers.remove(poolKey);
            }
            try {
                this.registerPool(string, string2);
                objectPool = this.getPool(poolKey);
            }
            catch (NamingException namingException) {
                throw new SQLException("RegisterPool failed", namingException);
            }
            try {
                object = objectPool.borrowObject();
            }
            catch (Exception exception3) {
                throw new SQLException("Could not retrieve connection info from pool", exception3);
            }
        }
        return object;
    }

    private PoolKey getPoolKey(String string) {
        return new PoolKey(this.getDataSourceName(), string);
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), PerUserPoolDataSourceFactory.class.getName(), null);
        reference.add(new StringRefAddr("instanceKey", this.getInstanceKey()));
        return reference;
    }

    <K, V> Map<K, V> put(Map<K, V> map, K k, V v) {
        if (map == null) {
            map = PerUserPoolDataSource.createMap();
        }
        map.put(k, v);
        return map;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.managers = this.readObjectImpl().managers;
    }

    private PerUserPoolDataSource readObjectImpl() throws IOException, ClassNotFoundException {
        try {
            return (PerUserPoolDataSource)new PerUserPoolDataSourceFactory().getObjectInstance((Object)this.getReference(), (Name)null, (Context)null, (Hashtable)null);
        }
        catch (NamingException namingException) {
            throw new IOException("NamingException: " + String.valueOf(namingException));
        }
    }

    private synchronized void registerPool(String string, String string2) throws NamingException, SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = this.testCPDS(string, string2);
        CPDSConnectionFactory cPDSConnectionFactory = new CPDSConnectionFactory(connectionPoolDataSource, this.getValidationQuery(), this.getValidationQueryTimeoutDuration(), this.isRollbackAfterValidation(), string, Utils.toCharArray(string2));
        cPDSConnectionFactory.setMaxConn(this.getMaxConnDuration());
        GenericObjectPool<PooledConnectionAndInfo> genericObjectPool = new GenericObjectPool<PooledConnectionAndInfo>(cPDSConnectionFactory);
        cPDSConnectionFactory.setPool(genericObjectPool);
        genericObjectPool.setBlockWhenExhausted(this.getPerUserBlockWhenExhausted(string));
        genericObjectPool.setEvictionPolicyClassName(this.getPerUserEvictionPolicyClassName(string));
        genericObjectPool.setLifo(this.getPerUserLifo(string));
        genericObjectPool.setMaxIdle(this.getPerUserMaxIdle(string));
        genericObjectPool.setMaxTotal(this.getPerUserMaxTotal(string));
        genericObjectPool.setMaxWait(this.getPerUserMaxWaitDuration(string));
        genericObjectPool.setMinEvictableIdleDuration(this.getPerUserMinEvictableIdleDuration(string));
        genericObjectPool.setMinIdle(this.getPerUserMinIdle(string));
        genericObjectPool.setNumTestsPerEvictionRun(this.getPerUserNumTestsPerEvictionRun(string));
        genericObjectPool.setSoftMinEvictableIdleDuration(this.getPerUserSoftMinEvictableIdleDuration(string));
        genericObjectPool.setTestOnCreate(this.getPerUserTestOnCreate(string));
        genericObjectPool.setTestOnBorrow(this.getPerUserTestOnBorrow(string));
        genericObjectPool.setTestOnReturn(this.getPerUserTestOnReturn(string));
        genericObjectPool.setTestWhileIdle(this.getPerUserTestWhileIdle(string));
        genericObjectPool.setDurationBetweenEvictionRuns(this.getPerUserDurationBetweenEvictionRuns(string));
        genericObjectPool.setSwallowedExceptionListener(new SwallowedExceptionLogger(log));
        PoolKey poolKey = this.getPoolKey(string);
        if (this.managers.containsKey(poolKey)) {
            genericObjectPool.close();
            throw new IllegalStateException("Pool already contains an entry for this user/password: " + string);
        }
        this.managers.put(poolKey, cPDSConnectionFactory);
    }

    private <K, V> Map<K, V> replaceAll(Map<K, V> map, Map<K, V> map2) {
        if (map == null) {
            return new HashMap<K, V>(map2);
        }
        map.clear();
        map.putAll(map2);
        return map;
    }

    void setPerUserBlockWhenExhausted(Map<String, Boolean> map) {
        this.assertInitializationAllowed();
        this.perUserBlockWhenExhausted = this.replaceAll(this.perUserBlockWhenExhausted, map);
    }

    public void setPerUserBlockWhenExhausted(String string, Boolean bl) {
        this.assertInitializationAllowed();
        this.perUserBlockWhenExhausted = this.put(this.perUserBlockWhenExhausted, string, bl);
    }

    void setPerUserDefaultAutoCommit(Map<String, Boolean> map) {
        this.assertInitializationAllowed();
        this.perUserDefaultAutoCommit = this.replaceAll(this.perUserDefaultAutoCommit, map);
    }

    public void setPerUserDefaultAutoCommit(String string, Boolean bl) {
        this.assertInitializationAllowed();
        this.perUserDefaultAutoCommit = this.put(this.perUserDefaultAutoCommit, string, bl);
    }

    void setPerUserDefaultReadOnly(Map<String, Boolean> map) {
        this.assertInitializationAllowed();
        this.perUserDefaultReadOnly = this.replaceAll(this.perUserDefaultReadOnly, map);
    }

    public void setPerUserDefaultReadOnly(String string, Boolean bl) {
        this.assertInitializationAllowed();
        this.perUserDefaultReadOnly = this.put(this.perUserDefaultReadOnly, string, bl);
    }

    void setPerUserDefaultTransactionIsolation(Map<String, Integer> map) {
        this.assertInitializationAllowed();
        this.perUserDefaultTransactionIsolation = this.replaceAll(this.perUserDefaultTransactionIsolation, map);
    }

    public void setPerUserDefaultTransactionIsolation(String string, Integer n) {
        this.assertInitializationAllowed();
        this.perUserDefaultTransactionIsolation = this.put(this.perUserDefaultTransactionIsolation, string, n);
    }

    void setPerUserDurationBetweenEvictionRuns(Map<String, Duration> map) {
        this.assertInitializationAllowed();
        this.perUserDurationBetweenEvictionRuns = this.replaceAll(this.perUserDurationBetweenEvictionRuns, map);
    }

    public void setPerUserDurationBetweenEvictionRuns(String string, Duration duration) {
        this.assertInitializationAllowed();
        this.perUserDurationBetweenEvictionRuns = this.put(this.perUserDurationBetweenEvictionRuns, string, duration);
    }

    void setPerUserEvictionPolicyClassName(Map<String, String> map) {
        this.assertInitializationAllowed();
        this.perUserEvictionPolicyClassName = this.replaceAll(this.perUserEvictionPolicyClassName, map);
    }

    public void setPerUserEvictionPolicyClassName(String string, String string2) {
        this.assertInitializationAllowed();
        this.perUserEvictionPolicyClassName = this.put(this.perUserEvictionPolicyClassName, string, string2);
    }

    void setPerUserLifo(Map<String, Boolean> map) {
        this.assertInitializationAllowed();
        this.perUserLifo = this.replaceAll(this.perUserLifo, map);
    }

    public void setPerUserLifo(String string, Boolean bl) {
        this.assertInitializationAllowed();
        this.perUserLifo = this.put(this.perUserLifo, string, bl);
    }

    void setPerUserMaxIdle(Map<String, Integer> map) {
        this.assertInitializationAllowed();
        this.perUserMaxIdle = this.replaceAll(this.perUserMaxIdle, map);
    }

    public void setPerUserMaxIdle(String string, Integer n) {
        this.assertInitializationAllowed();
        this.perUserMaxIdle = this.put(this.perUserMaxIdle, string, n);
    }

    void setPerUserMaxTotal(Map<String, Integer> map) {
        this.assertInitializationAllowed();
        this.perUserMaxTotal = this.replaceAll(this.perUserMaxTotal, map);
    }

    public void setPerUserMaxTotal(String string, Integer n) {
        this.assertInitializationAllowed();
        this.perUserMaxTotal = this.put(this.perUserMaxTotal, string, n);
    }

    public void setPerUserMaxWait(String string, Duration duration) {
        this.assertInitializationAllowed();
        this.perUserMaxWaitDuration = this.put(this.perUserMaxWaitDuration, string, duration);
    }

    void setPerUserMaxWaitDuration(Map<String, Duration> map) {
        this.assertInitializationAllowed();
        this.perUserMaxWaitDuration = this.replaceAll(this.perUserMaxWaitDuration, map);
    }

    void setPerUserMaxWaitMillis(Map<String, Long> map) {
        this.assertInitializationAllowed();
        this.perUserMaxWaitDuration = this.convertMap(this.perUserMaxWaitDuration, map);
    }

    @Deprecated
    public void setPerUserMaxWaitMillis(String string, Long l) {
        this.setPerUserMaxWait(string, this.toDurationOrNull(l));
    }

    void setPerUserMinEvictableIdle(Map<String, Duration> map) {
        this.assertInitializationAllowed();
        this.perUserMinEvictableIdleDuration = this.replaceAll(this.perUserMinEvictableIdleDuration, map);
    }

    public void setPerUserMinEvictableIdle(String string, Duration duration) {
        this.assertInitializationAllowed();
        this.perUserMinEvictableIdleDuration = this.put(this.perUserMinEvictableIdleDuration, string, duration);
    }

    @Deprecated
    public void setPerUserMinEvictableIdleTimeMillis(String string, Long l) {
        this.setPerUserMinEvictableIdle(string, this.toDurationOrNull(l));
    }

    void setPerUserMinIdle(Map<String, Integer> map) {
        this.assertInitializationAllowed();
        this.perUserMinIdle = this.replaceAll(this.perUserMinIdle, map);
    }

    public void setPerUserMinIdle(String string, Integer n) {
        this.assertInitializationAllowed();
        this.perUserMinIdle = this.put(this.perUserMinIdle, string, n);
    }

    void setPerUserNumTestsPerEvictionRun(Map<String, Integer> map) {
        this.assertInitializationAllowed();
        this.perUserNumTestsPerEvictionRun = this.replaceAll(this.perUserNumTestsPerEvictionRun, map);
    }

    public void setPerUserNumTestsPerEvictionRun(String string, Integer n) {
        this.assertInitializationAllowed();
        this.perUserNumTestsPerEvictionRun = this.put(this.perUserNumTestsPerEvictionRun, string, n);
    }

    void setPerUserSoftMinEvictableIdle(Map<String, Duration> map) {
        this.assertInitializationAllowed();
        this.perUserSoftMinEvictableIdleDuration = this.replaceAll(this.perUserSoftMinEvictableIdleDuration, map);
    }

    public void setPerUserSoftMinEvictableIdle(String string, Duration duration) {
        this.assertInitializationAllowed();
        this.perUserSoftMinEvictableIdleDuration = this.put(this.perUserSoftMinEvictableIdleDuration, string, duration);
    }

    @Deprecated
    public void setPerUserSoftMinEvictableIdleTimeMillis(String string, Long l) {
        this.setPerUserSoftMinEvictableIdle(string, this.toDurationOrNull(l));
    }

    void setPerUserTestOnBorrow(Map<String, Boolean> map) {
        this.assertInitializationAllowed();
        this.perUserTestOnBorrow = this.replaceAll(this.perUserTestOnBorrow, map);
    }

    public void setPerUserTestOnBorrow(String string, Boolean bl) {
        this.assertInitializationAllowed();
        this.perUserTestOnBorrow = this.put(this.perUserTestOnBorrow, string, bl);
    }

    void setPerUserTestOnCreate(Map<String, Boolean> map) {
        this.assertInitializationAllowed();
        this.perUserTestOnCreate = this.replaceAll(this.perUserTestOnCreate, map);
    }

    public void setPerUserTestOnCreate(String string, Boolean bl) {
        this.assertInitializationAllowed();
        this.perUserTestOnCreate = this.put(this.perUserTestOnCreate, string, bl);
    }

    void setPerUserTestOnReturn(Map<String, Boolean> map) {
        this.assertInitializationAllowed();
        this.perUserTestOnReturn = this.replaceAll(this.perUserTestOnReturn, map);
    }

    public void setPerUserTestOnReturn(String string, Boolean bl) {
        this.assertInitializationAllowed();
        this.perUserTestOnReturn = this.put(this.perUserTestOnReturn, string, bl);
    }

    void setPerUserTestWhileIdle(Map<String, Boolean> map) {
        this.assertInitializationAllowed();
        this.perUserTestWhileIdle = this.replaceAll(this.perUserTestWhileIdle, map);
    }

    public void setPerUserTestWhileIdle(String string, Boolean bl) {
        this.assertInitializationAllowed();
        this.perUserTestWhileIdle = this.put(this.perUserTestWhileIdle, string, bl);
    }

    @Deprecated
    public void setPerUserTimeBetweenEvictionRunsMillis(String string, Long l) {
        this.setPerUserDurationBetweenEvictionRuns(string, this.toDurationOrNull(l));
    }

    @Override
    protected void setupDefaults(Connection connection, String string) throws SQLException {
        Integer n;
        Boolean bl;
        Boolean bl2;
        Boolean bl3 = this.isDefaultAutoCommit();
        if (string != null && (bl2 = this.getPerUserDefaultAutoCommit(string)) != null) {
            bl3 = bl2;
        }
        bl2 = this.isDefaultReadOnly();
        if (string != null && (bl = this.getPerUserDefaultReadOnly(string)) != null) {
            bl2 = bl;
        }
        int n2 = this.getDefaultTransactionIsolation();
        if (string != null && (n = this.getPerUserDefaultTransactionIsolation(string)) != null) {
            n2 = n;
        }
        if (bl3 != null && connection.getAutoCommit() != bl3.booleanValue()) {
            connection.setAutoCommit(bl3);
        }
        if (n2 != -1) {
            connection.setTransactionIsolation(n2);
        }
        if (bl2 != null && connection.isReadOnly() != bl2.booleanValue()) {
            connection.setReadOnly(bl2);
        }
    }

    private Duration toDurationOrNull(Long l) {
        return l == null ? null : Duration.ofMillis(l);
    }
}

