/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.change.AddAxiomData;
import org.semanticweb.owlapi.change.AxiomChangeData;
import org.semanticweb.owlapi.change.RemoveAxiomData;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWLFacet;

public class OWLObjectTransformer<T> {
    private final Function<T, T> transformer;
    private final Predicate<Object> predicate;
    private final Class<T> witness;
    private final OWLDataFactory df;

    public OWLObjectTransformer(@Nonnull Predicate<Object> predicate, @Nonnull Function<T, T> transformer, @Nonnull OWLDataFactory df, @Nonnull Class<T> witness) {
        this.predicate = OWLAPIPreconditions.checkNotNull(predicate, "predicate cannot be null");
        this.transformer = OWLAPIPreconditions.checkNotNull(transformer, "transformer cannot be null");
        this.df = OWLAPIPreconditions.checkNotNull(df, "df cannot be null");
        this.witness = OWLAPIPreconditions.checkNotNull(witness, "witness cannot be null");
    }

    @Nonnull
    public List<AxiomChangeData> change(@Nonnull OWLObject o) {
        OWLAPIPreconditions.checkNotNull(o, "o cannot be null");
        ArrayList<AxiomChangeData> changes = new ArrayList<AxiomChangeData>();
        Visitor<T> v = new Visitor<T>(new ArrayList<OWLOntologyChange>(), changes, this.predicate, this.transformer, this.df, this.witness);
        o.accept(v);
        return changes;
    }

    @Nonnull
    public List<OWLOntologyChange> change(@Nonnull OWLOntology ontology) {
        OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null");
        ArrayList<AxiomChangeData> changes = new ArrayList<AxiomChangeData>();
        ArrayList<OWLOntologyChange> ontologyChanges = new ArrayList<OWLOntologyChange>();
        Visitor<T> v = new Visitor<T>(ontologyChanges, changes, this.predicate, this.transformer, this.df, this.witness);
        ontology.accept(v);
        for (AxiomChangeData change : changes) {
            ontologyChanges.add(change.createOntologyChange(ontology));
        }
        return ontologyChanges;
    }

    private static class Visitor<T>
    implements OWLObjectVisitorEx<Object> {
        private final List<AxiomChangeData> changes;
        private final List<OWLOntologyChange> ontologyChanges;
        private final Predicate<Object> predicate;
        private final Function<T, T> transformer;
        private final Class<T> witness;
        private final OWLDataFactory df;

        Visitor(List<OWLOntologyChange> ontologyChanges, List<AxiomChangeData> changes, Predicate<Object> predicate, Function<T, T> transformer, OWLDataFactory df, Class<T> witness) {
            this.changes = changes;
            this.ontologyChanges = ontologyChanges;
            this.predicate = predicate;
            this.transformer = transformer;
            this.df = df;
            this.witness = witness;
        }

        @Nullable
        protected OWLAxiom checkAxiom(OWLAxiom axiom) {
            OWLAxiom transform;
            if (this.witness.isInstance(axiom) && this.update(transform = (OWLAxiom)this.transformer.apply((Object)axiom), axiom) != null) {
                return transform;
            }
            return null;
        }

        protected OWLAxiom update(OWLAxiom transform, OWLAxiom axiom) {
            if (!axiom.equals(transform)) {
                this.changes.add(new RemoveAxiomData(axiom));
                this.changes.add(new AddAxiomData(transform));
                return transform;
            }
            return null;
        }

        @Nullable
        protected <Q> Q check(Q o) {
            Object transform;
            if (this.witness.isInstance(o) && (transform = this.transformer.apply(this.witness.cast(o))) != o) {
                return (Q)transform;
            }
            return null;
        }

        protected <Q extends OWLObject> Q t(Q t) {
            return (Q)((OWLObject)t.accept(this));
        }

        protected OWLFacet t(OWLFacet t) {
            return (OWLFacet)this.transformer.apply((Object)t);
        }

        protected <Q extends OWLObject> Set<Q> t(Collection<Q> c) {
            HashSet<OWLObject> list = new HashSet<OWLObject>();
            for (OWLObject t : c) {
                list.add(this.t(t));
            }
            return list;
        }

        protected <Q extends OWLObject> List<Q> t(List<Q> c) {
            ArrayList<OWLObject> list = new ArrayList<OWLObject>();
            for (OWLObject t : c) {
                list.add(this.t(t));
            }
            return list;
        }

        @Override
        public Object visit(OWLDeclarationAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLDeclarationAxiom(this.t(axiom.getEntity()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLDatatypeDefinitionAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLDatatypeDefinitionAxiom(this.t(axiom.getDatatype()), this.t(axiom.getDataRange()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLAnnotationAssertionAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLAnnotationAssertionAxiom(this.t(axiom.getSubject()), this.t(axiom.getAnnotation()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLSubAnnotationPropertyOfAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLSubAnnotationPropertyOfAxiom(this.t(axiom.getSubProperty()), this.t(axiom.getSuperProperty()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLAnnotationPropertyDomainAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLAnnotationPropertyDomainAxiom(this.t(axiom.getProperty()), this.t(axiom.getDomain()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLAnnotationPropertyRangeAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLAnnotationPropertyRangeAxiom(this.t(axiom.getProperty()), this.t(axiom.getRange()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLSubClassOfAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLSubClassOfAxiom(this.t(axiom.getSubClass()), this.t(axiom.getSuperClass()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLNegativeObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)this.t(axiom.getProperty()), this.t(axiom.getSubject()), (OWLIndividual)this.t(axiom.getObject()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLAsymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.t(axiom.getProperty()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLReflexiveObjectPropertyAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLReflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.t(axiom.getProperty()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLDisjointClassesAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLDisjointClassesAxiom(this.t(axiom.getClassExpressions()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLDataPropertyDomainAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)this.t(axiom.getProperty()), this.t(axiom.getDomain()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLObjectPropertyDomainAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)this.t(axiom.getProperty()), this.t(axiom.getDomain()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLEquivalentObjectPropertiesAxiom(this.t(axiom.getProperties()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLNegativeDataPropertyAssertionAxiom((OWLDataPropertyExpression)this.t(axiom.getProperty()), this.t(axiom.getSubject()), (OWLLiteral)this.t(axiom.getObject()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLDifferentIndividualsAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLDifferentIndividualsAxiom(this.t(axiom.getIndividuals()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLDisjointDataPropertiesAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLDisjointDataPropertiesAxiom(this.t(axiom.getProperties()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLDisjointObjectPropertiesAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLDisjointObjectPropertiesAxiom(this.t(axiom.getProperties()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLObjectPropertyRangeAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)this.t(axiom.getProperty()), (OWLClassExpression)this.t(axiom.getRange()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLObjectPropertyAssertionAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)this.t(axiom.getProperty()), this.t(axiom.getSubject()), (OWLIndividual)this.t(axiom.getObject()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLFunctionalObjectPropertyAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.t(axiom.getProperty()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLSubObjectPropertyOfAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)this.t((OWLObject)axiom.getSubProperty()), (OWLObjectPropertyExpression)this.t((OWLObject)axiom.getSuperProperty()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLDisjointUnionAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLDisjointUnionAxiom(this.t(axiom.getOWLClass()), this.t(axiom.getClassExpressions()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLSymmetricObjectPropertyAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)this.t(axiom.getProperty()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLDataPropertyRangeAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)this.t(axiom.getProperty()), (OWLDataRange)this.t(axiom.getRange()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLFunctionalDataPropertyAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)this.t(axiom.getProperty()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLEquivalentDataPropertiesAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLEquivalentDataPropertiesAxiom(this.t(axiom.getProperties()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLClassAssertionAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLClassAssertionAxiom(this.t(axiom.getClassExpression()), this.t(axiom.getIndividual()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLEquivalentClassesAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLEquivalentClassesAxiom(this.t(axiom.getClassExpressions()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLDataPropertyAssertionAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)this.t(axiom.getProperty()), this.t(axiom.getSubject()), (OWLLiteral)this.t(axiom.getObject()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLTransitiveObjectPropertyAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.t(axiom.getProperty()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLIrreflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)this.t(axiom.getProperty()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLSubDataPropertyOfAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)this.t((OWLObject)axiom.getSubProperty()), (OWLDataPropertyExpression)this.t((OWLObject)axiom.getSuperProperty()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)this.t(axiom.getProperty()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLSameIndividualAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLSameIndividualAxiom(this.t(axiom.getIndividuals()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLSubPropertyChainOfAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLSubPropertyChainOfAxiom(this.t(axiom.getPropertyChain()), this.t(axiom.getSuperProperty()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLInverseObjectPropertiesAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLInverseObjectPropertiesAxiom(this.t(axiom.getFirstProperty()), this.t(axiom.getSecondProperty()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(OWLHasKeyAxiom axiom) {
            OWLAxiom transform = this.checkAxiom(axiom);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)axiom)) {
                return axiom;
            }
            return this.update(this.df.getOWLHasKeyAxiom(this.t(axiom.getClassExpression()), this.t(axiom.getPropertyExpressions()), this.t(axiom.getAnnotations())), axiom);
        }

        @Override
        public Object visit(SWRLRule rule) {
            OWLAxiom transform = this.checkAxiom(rule);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)rule)) {
                return rule;
            }
            return this.update(this.df.getSWRLRule(this.t(rule.getBody()), this.t(rule.getHead()), this.t(rule.getAnnotations())), rule);
        }

        @Override
        public Object visit(OWLClass ce) {
            OWLObject transform = this.check(ce);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)ce)) {
                return ce;
            }
            return this.df.getOWLClass(this.t(ce.getIRI()));
        }

        @Override
        public Object visit(OWLObjectIntersectionOf ce) {
            OWLObject transform = this.check(ce);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)ce)) {
                return ce;
            }
            return this.df.getOWLObjectIntersectionOf(this.t(ce.getOperands()));
        }

        @Override
        public Object visit(OWLObjectUnionOf ce) {
            OWLObject transform = this.check(ce);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)ce)) {
                return ce;
            }
            return this.df.getOWLObjectUnionOf(this.t(ce.getOperands()));
        }

        @Override
        public Object visit(OWLObjectComplementOf ce) {
            OWLObject transform = this.check(ce);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)ce)) {
                return ce;
            }
            return this.df.getOWLObjectComplementOf(this.t(ce.getOperand()));
        }

        @Override
        public Object visit(OWLObjectSomeValuesFrom ce) {
            OWLObject transform = this.check(ce);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)ce)) {
                return ce;
            }
            return this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.t(ce.getProperty()), (OWLClassExpression)this.t(ce.getFiller()));
        }

        @Override
        public Object visit(OWLObjectAllValuesFrom ce) {
            OWLObject transform = this.check(ce);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)ce)) {
                return ce;
            }
            return this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)this.t(ce.getProperty()), (OWLClassExpression)this.t(ce.getFiller()));
        }

        @Override
        public Object visit(OWLObjectHasValue ce) {
            OWLObject transform = this.check(ce);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)ce)) {
                return ce;
            }
            return this.df.getOWLObjectHasValue((OWLObjectPropertyExpression)this.t(ce.getProperty()), (OWLIndividual)this.t((OWLObject)ce.getFiller()));
        }

        @Override
        public Object visit(OWLObjectMinCardinality ce) {
            OWLObject transform = this.check(ce);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)ce)) {
                return ce;
            }
            return this.df.getOWLObjectMinCardinality(ce.getCardinality(), (OWLObjectPropertyExpression)this.t(ce.getProperty()), (OWLClassExpression)this.t(ce.getFiller()));
        }

        @Override
        public Object visit(OWLObjectExactCardinality ce) {
            OWLObject transform = this.check(ce);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)ce)) {
                return ce;
            }
            return this.df.getOWLObjectExactCardinality(ce.getCardinality(), (OWLObjectPropertyExpression)this.t(ce.getProperty()), (OWLClassExpression)this.t(ce.getFiller()));
        }

        @Override
        public Object visit(OWLObjectMaxCardinality ce) {
            OWLObject transform = this.check(ce);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)ce)) {
                return ce;
            }
            return this.df.getOWLObjectMaxCardinality(ce.getCardinality(), (OWLObjectPropertyExpression)this.t(ce.getProperty()), (OWLClassExpression)this.t(ce.getFiller()));
        }

        @Override
        public Object visit(OWLObjectHasSelf ce) {
            OWLObject transform = this.check(ce);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)ce)) {
                return ce;
            }
            return this.df.getOWLObjectHasSelf((OWLObjectPropertyExpression)this.t(ce.getProperty()));
        }

        @Override
        public Object visit(OWLObjectOneOf ce) {
            OWLObject transform = this.check(ce);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)ce)) {
                return ce;
            }
            return this.df.getOWLObjectOneOf(this.t(ce.getIndividuals()));
        }

        @Override
        public Object visit(OWLDataSomeValuesFrom ce) {
            OWLObject transform = this.check(ce);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)ce)) {
                return ce;
            }
            return this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)this.t(ce.getProperty()), (OWLDataRange)this.t(ce.getFiller()));
        }

        @Override
        public Object visit(OWLDataAllValuesFrom ce) {
            OWLObject transform = this.check(ce);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)ce)) {
                return ce;
            }
            return this.df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)this.t(ce.getProperty()), (OWLDataRange)this.t(ce.getFiller()));
        }

        @Override
        public Object visit(OWLDataHasValue ce) {
            OWLObject transform = this.check(ce);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)ce)) {
                return ce;
            }
            return this.df.getOWLDataHasValue((OWLDataPropertyExpression)this.t(ce.getProperty()), (OWLLiteral)this.t((OWLObject)ce.getFiller()));
        }

        @Override
        public Object visit(OWLDataMinCardinality ce) {
            OWLObject transform = this.check(ce);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)ce)) {
                return ce;
            }
            return this.df.getOWLDataMinCardinality(ce.getCardinality(), (OWLDataPropertyExpression)this.t(ce.getProperty()), (OWLDataRange)this.t(ce.getFiller()));
        }

        @Override
        public Object visit(OWLDataExactCardinality ce) {
            OWLObject transform = this.check(ce);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)ce)) {
                return ce;
            }
            return this.df.getOWLDataExactCardinality(ce.getCardinality(), (OWLDataPropertyExpression)this.t(ce.getProperty()), (OWLDataRange)this.t(ce.getFiller()));
        }

        @Override
        public Object visit(OWLDataMaxCardinality ce) {
            OWLObject transform = this.check(ce);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)ce)) {
                return ce;
            }
            return this.df.getOWLDataMaxCardinality(ce.getCardinality(), (OWLDataPropertyExpression)this.t(ce.getProperty()), (OWLDataRange)this.t(ce.getFiller()));
        }

        @Override
        public Object visit(OWLDatatype node) {
            OWLObject transform = this.check(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)node)) {
                return node;
            }
            return this.df.getOWLDatatype(this.t(node.getIRI()));
        }

        @Override
        public Object visit(OWLDataComplementOf node) {
            OWLObject transform = this.check(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)node)) {
                return node;
            }
            return this.df.getOWLDataComplementOf(this.t(node.getDataRange()));
        }

        @Override
        public Object visit(OWLDataOneOf node) {
            OWLObject transform = this.check(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)node)) {
                return node;
            }
            return this.df.getOWLDataOneOf(this.t(node.getValues()));
        }

        @Override
        public Object visit(OWLDataIntersectionOf node) {
            OWLObject transform = this.check(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)node)) {
                return node;
            }
            return this.df.getOWLDataIntersectionOf(this.t(node.getOperands()));
        }

        @Override
        public Object visit(OWLDataUnionOf node) {
            OWLObject transform = this.check(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)node)) {
                return node;
            }
            return this.df.getOWLDataUnionOf(this.t(node.getOperands()));
        }

        @Override
        public Object visit(OWLDatatypeRestriction node) {
            OWLObject transform = this.check(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)node)) {
                return node;
            }
            return this.df.getOWLDatatypeRestriction(this.t(node.getDatatype()), this.t(node.getFacetRestrictions()));
        }

        @Override
        public Object visit(OWLLiteral node) {
            OWLObject transform = this.check(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)node)) {
                return node;
            }
            if (node.isRDFPlainLiteral()) {
                return node;
            }
            return this.df.getOWLLiteral(node.getLiteral(), this.t(node.getDatatype()));
        }

        @Override
        public Object visit(OWLFacetRestriction node) {
            OWLObject transform = this.check(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)node)) {
                return node;
            }
            return this.df.getOWLFacetRestriction(this.t(node.getFacet()), this.t(node.getFacetValue()));
        }

        @Override
        public Object visit(OWLObjectProperty property) {
            OWLObject transform = this.check(property);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)property)) {
                return property;
            }
            return this.df.getOWLObjectProperty(this.t(property.getIRI()));
        }

        @Override
        public Object visit(OWLObjectInverseOf property) {
            OWLObject transform = this.check(property);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)property)) {
                return property;
            }
            return this.df.getOWLObjectInverseOf(this.t(property.getNamedProperty()));
        }

        @Override
        public Object visit(OWLDataProperty property) {
            OWLObject transform = this.check(property);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)property)) {
                return property;
            }
            return this.df.getOWLDataProperty(this.t(property.getIRI()));
        }

        @Override
        public Object visit(OWLAnnotationProperty property) {
            OWLObject transform = this.check(property);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)property)) {
                return property;
            }
            return this.df.getOWLAnnotationProperty(this.t(property.getIRI()));
        }

        @Override
        public Object visit(OWLNamedIndividual individual) {
            OWLObject transform = this.check(individual);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)individual)) {
                return individual;
            }
            return this.df.getOWLNamedIndividual(this.t(individual.getIRI()));
        }

        @Override
        public Object visit(OWLAnnotation node) {
            OWLObject transform = this.check(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)node)) {
                return node;
            }
            return this.df.getOWLAnnotation(this.t(node.getProperty()), this.t(node.getValue()), this.t(node.getAnnotations()));
        }

        @Override
        public Object visit(IRI iri) {
            OWLObject transform = this.check(iri);
            if (transform != null) {
                return transform;
            }
            return iri;
        }

        @Override
        public Object visit(OWLAnonymousIndividual individual) {
            OWLObject transform = this.check(individual);
            if (transform != null) {
                return transform;
            }
            return individual;
        }

        @Override
        public Object visit(SWRLClassAtom node) {
            OWLObject transform = this.check(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)node)) {
                return node;
            }
            return this.df.getSWRLClassAtom(this.t(node.getPredicate()), (SWRLIArgument)this.t((OWLObject)node.getArgument()));
        }

        @Override
        public Object visit(SWRLDataRangeAtom node) {
            OWLObject transform = this.check(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)node)) {
                return node;
            }
            return this.df.getSWRLDataRangeAtom(this.t(node.getPredicate()), (SWRLDArgument)this.t((OWLObject)node.getArgument()));
        }

        @Override
        public Object visit(SWRLObjectPropertyAtom node) {
            OWLObject transform = this.check(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)node)) {
                return node;
            }
            return this.df.getSWRLObjectPropertyAtom(this.t(node.getPredicate()), (SWRLIArgument)this.t((OWLObject)node.getFirstArgument()), (SWRLIArgument)this.t((OWLObject)node.getSecondArgument()));
        }

        @Override
        public Object visit(SWRLDataPropertyAtom node) {
            OWLObject transform = this.check(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)node)) {
                return node;
            }
            return this.df.getSWRLDataPropertyAtom(this.t(node.getPredicate()), (SWRLIArgument)this.t((OWLObject)node.getFirstArgument()), (SWRLDArgument)this.t((OWLObject)node.getSecondArgument()));
        }

        @Override
        public Object visit(SWRLBuiltInAtom node) {
            OWLObject transform = this.check(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)node)) {
                return node;
            }
            return this.df.getSWRLBuiltInAtom(this.t(node.getPredicate()), this.t(node.getArguments()));
        }

        @Override
        public Object visit(SWRLVariable node) {
            OWLObject transform = this.check(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)node)) {
                return node;
            }
            return this.df.getSWRLVariable(this.t(node.getIRI()));
        }

        @Override
        public Object visit(SWRLIndividualArgument node) {
            OWLObject transform = this.check(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)node)) {
                return node;
            }
            return this.df.getSWRLIndividualArgument(this.t(node.getIndividual()));
        }

        @Override
        public Object visit(SWRLLiteralArgument node) {
            OWLObject transform = this.check(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)node)) {
                return node;
            }
            return this.df.getSWRLLiteralArgument(this.t(node.getLiteral()));
        }

        @Override
        public Object visit(SWRLSameIndividualAtom node) {
            OWLObject transform = this.check(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)node)) {
                return node;
            }
            return this.df.getSWRLSameIndividualAtom((SWRLIArgument)this.t((OWLObject)node.getFirstArgument()), (SWRLIArgument)this.t((OWLObject)node.getSecondArgument()));
        }

        @Override
        public Object visit(SWRLDifferentIndividualsAtom node) {
            OWLObject transform = this.check(node);
            if (transform != null) {
                return transform;
            }
            if (!this.predicate.apply((Object)node)) {
                return node;
            }
            return this.df.getSWRLDifferentIndividualsAtom((SWRLIArgument)this.t((OWLObject)node.getFirstArgument()), (SWRLIArgument)this.t((OWLObject)node.getSecondArgument()));
        }

        @Override
        public Object visit(OWLOntology ontology) {
            Serializable transform;
            for (AxiomType<?> t : AxiomType.AXIOM_TYPES) {
                for (OWLAxiom ax : ontology.getAxioms(t)) {
                    ax.accept(this);
                }
            }
            for (OWLAnnotation a : ontology.getAnnotations()) {
                transform = this.t(a);
                if (transform == a) continue;
                this.ontologyChanges.add(new RemoveOntologyAnnotation(ontology, a));
                this.ontologyChanges.add(new AddOntologyAnnotation(ontology, (OWLAnnotation)transform));
            }
            for (OWLImportsDeclaration id : ontology.getImportsDeclarations()) {
                transform = this.check(id);
                if (transform == null) continue;
                this.ontologyChanges.add(new RemoveImport(ontology, id));
                this.ontologyChanges.add(new AddImport(ontology, (OWLImportsDeclaration)transform));
            }
            OWLOntologyID transform2 = this.check(ontology.getOntologyID());
            if (transform2 != null) {
                this.ontologyChanges.add(new SetOntologyID(ontology, transform2));
            }
            return ontology;
        }
    }
}

