/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.lang;

import com.google.common.base.Preconditions;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.swing.ComboBoxEditor;
import javax.swing.JTextField;
import org.protege.editor.owl.model.lang.LangCode;
import org.protege.editor.owl.model.lang.LangCodeRegistry;

public class LangCodeEditor
implements ComboBoxEditor {
    @Nonnull
    private final LangCodeRegistry langCodeRegistry;
    private final JTextField textField = new JTextField();

    public LangCodeEditor(@Nonnull LangCodeRegistry langCodeRegistry) {
        this.langCodeRegistry = (LangCodeRegistry)Preconditions.checkNotNull((Object)langCodeRegistry);
    }

    private String getText() {
        return this.textField.getText().trim().toLowerCase();
    }

    @Override
    public Component getEditorComponent() {
        return this.textField;
    }

    @Override
    public void setItem(Object anObject) {
        if (anObject == null) {
            this.textField.setText("");
        } else if (anObject instanceof LangCode) {
            this.textField.setText(((LangCode)anObject).getLangCode());
        } else {
            this.textField.setText(anObject.toString());
        }
    }

    @Override
    public Object getItem() {
        Optional<LangCode> langCode = this.langCodeRegistry.getLangCode(this.getText());
        return langCode.orElse(null);
    }

    @Override
    public void selectAll() {
        this.textField.selectAll();
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.textField.addActionListener(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.textField.removeActionListener(l);
    }
}

