/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.graphic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.timingdiagram.ChangeState;
import net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.graphic.IntricatedPoint;
import net.sourceforge.plantuml.timingdiagram.graphic.Panels;

public class PanelsRobust
extends Panels {
    private static final double HISTOGRAM_BOTTOM_MARGIN = 12.0;
    private static final double HISTOGRAM_INITIAL_WIDTH = 40.0;
    private final List<ChangeState> changes = new ArrayList<ChangeState>();
    private List<String> allStates;
    private String initialState;

    public PanelsRobust(TimingRuler ruler, ISkinParam skinParam, Collection<String> someStates, int suggestedHeight, Style style, List<TimeConstraint> constraints) {
        super(ruler, skinParam, suggestedHeight, style, null, constraints);
        this.allStates = new ArrayList<String>(someStates);
        Collections.reverse(this.allStates);
    }

    @Override
    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        if (tick == null) {
            return null;
        }
        double x = this.ruler.getPosInPixel(tick);
        List<String> states = this.getStatesAt(tick);
        if (states.size() == 0) {
            return null;
        }
        double heightForConstraints = this.getHeightForConstraints(stringBounder);
        if (states.size() == 1) {
            double y = this.yOfState(states.get(0)) + heightForConstraints;
            return new IntricatedPoint(new XPoint2D(x, y), new XPoint2D(x, y));
        }
        assert (states.size() == 2);
        double y1 = this.yOfState(states.get(0)) + heightForConstraints;
        double y2 = this.yOfState(states.get(1)) + heightForConstraints;
        assert (y1 != y2);
        return new IntricatedPoint(new XPoint2D(x, y1), new XPoint2D(x, y2));
    }

    private List<String> getStatesAt(TimeTick tick) {
        if (this.changes.size() == 0) {
            return Collections.emptyList();
        }
        for (int i = 0; i < this.changes.size(); ++i) {
            int comparaison = this.changes.get(i).getWhen().compareTo(tick);
            if (comparaison == 0) {
                if (i == 0 && this.initialState == null) {
                    return Arrays.asList(this.changes.get(i).getState());
                }
                if (i == 0 && this.initialState != null) {
                    return Arrays.asList(this.initialState, this.changes.get(i).getState());
                }
                return Arrays.asList(this.changes.get(i - 1).getState(), this.changes.get(i).getState());
            }
            if (comparaison <= 0) continue;
            int changeIndex = i == 0 ? 0 : i - 1;
            return Collections.singletonList(this.changes.get(changeIndex).getState());
        }
        return Collections.singletonList(this.changes.get(this.changes.size() - 1).getState());
    }

    public void addChange(ChangeState change) {
        this.changes.add(change);
        if (change.isCompletelyHidden()) {
            return;
        }
        List<String> states = change.getStates();
        for (String state : states) {
            if (this.allStates.contains(state)) continue;
            this.allStates.add(state);
        }
    }

    private XPoint2D[] getPoints(int n) {
        ChangeState change = this.changes.get(n);
        double x = this.ruler.getPosInPixel(change.getWhen());
        List<String> states = change.getStates();
        if (states.size() == 2) {
            return new XPoint2D[]{new XPoint2D(x, this.yOfState(states.get(0))), new XPoint2D(x, this.yOfState(states.get(1)))};
        }
        return new XPoint2D[]{new XPoint2D(x, this.yOfState(states.get(0)))};
    }

    private double getPointx(int n) {
        ChangeState change = this.changes.get(n);
        return this.ruler.getPosInPixel(change.getWhen());
    }

    private double getPointMinY(int n) {
        List<String> states = this.changes.get(n).getStates();
        if (states.size() == 2) {
            return Math.min(this.yOfState(states.get(0)), this.yOfState(states.get(1)));
        }
        return this.yOfState(states.get(0));
    }

    private double getPointMaxY(int n) {
        List<String> states = this.changes.get(n).getStates();
        if (states.size() == 2) {
            return Math.max(this.yOfState(states.get(0)), this.yOfState(states.get(1)));
        }
        return this.yOfState(states.get(0));
    }

    @Override
    public void drawLeftPanel(UGraphic ug, double fullAvailableWidth) {
        StringBounder stringBounder = ug.getStringBounder();
        ug = ug.apply(UTranslate.dy(this.getHeightForConstraints(stringBounder)));
        double width = this.getStatesWidth(stringBounder);
        if (this.initialState != null) {
            width += 40.0;
        }
        ug = fullAvailableWidth > width + 5.0 ? ug.apply(UTranslate.dx(fullAvailableWidth - width - 5.0)) : ug.apply(UTranslate.dx(fullAvailableWidth - width));
        for (String state : this.allStates) {
            TextBlock label = this.getTextBlock(state);
            XDimension2D dim = label.calculateDimension(stringBounder);
            label.drawU(ug.apply(UTranslate.dy(this.yOfState(state) - dim.getHeight() / 2.0 + 1.0)));
        }
    }

    @Override
    public void drawRightPanel(UGraphic ug) {
        if (this.changes.size() == 0) {
            return;
        }
        ug = this.getContext().apply(ug);
        ug = ug.apply(UTranslate.dy(this.getHeightForConstraints(ug.getStringBounder())));
        this.drawHlines(ug);
        this.drawVlines(ug);
        this.drawLabels(ug);
        this.drawConstraints(ug.apply(UTranslate.dy(-TimeConstraint.getTopMargin())));
    }

    private double getStatesWidth(StringBounder stringBounder) {
        double result = 0.0;
        for (String state : this.allStates) {
            TextBlock label = this.getTextBlock(state);
            XDimension2D dim = label.calculateDimension(stringBounder);
            result = Math.max(result, dim.getWidth());
        }
        return result;
    }

    @Override
    public double getLeftPanelWidth(StringBounder stringBounder) {
        if (this.initialState == null) {
            return this.getStatesWidth(stringBounder);
        }
        return this.getStatesWidth(stringBounder) + 40.0;
    }

    private void drawHlines(UGraphic ug) {
        if (this.initialState != null) {
            for (XPoint2D pt : this.getPoints(0)) {
                this.drawHLineFromPoint(ug, this.getInitialPoint(), 40.0 + pt.getX());
            }
        }
        for (int i = 0; i < this.changes.size(); ++i) {
            if (this.changes.get(i).isCompletelyHidden()) continue;
            double x2 = i < this.changes.size() - 1 ? this.getPointx(i + 1) : this.ruler.getWidth();
            double len = x2 - this.getPointx(i);
            XPoint2D[] points = this.getPoints(i);
            if (points.length == 2) {
                this.drawHBlock(ug.apply(this.changes.get(i).getBackColor(this.skinParam, this.style).bg()), points[0], points[1], len);
            }
            if (i >= this.changes.size() - 1) continue;
            for (XPoint2D pt : points) {
                this.drawHLineFromPoint(ug, pt, len);
            }
        }
        if (!this.changes.get(this.changes.size() - 1).isCompletelyHidden()) {
            for (XPoint2D pt : this.getPoints(this.changes.size() - 1)) {
                double len = this.ruler.getWidth() - pt.getX();
                this.drawHLineFromPoint(ug, pt, len);
            }
        }
    }

    private void drawHBlock(UGraphic ug, XPoint2D pt1, XPoint2D pt2, double len) {
        double minY = Math.min(pt1.getY(), pt2.getY());
        double maxY = Math.max(pt1.getY(), pt2.getY());
        XPoint2D pt = new XPoint2D(pt1.getX(), minY);
        ug = ug.apply(UTranslate.point(pt));
        ug.draw(URectangle.build(len, maxY - minY));
        for (double x = 0.0; x < len; x += 5.0) {
            ug.apply(UTranslate.dx(x)).draw(ULine.vline(maxY - minY));
        }
    }

    private void drawVlines(UGraphic ug) {
        if (this.initialState != null) {
            XPoint2D before = this.getInitialPoint();
            XPoint2D current = this.getPoints(0)[0];
            this.drawVline(ug, current.getX(), current.getY(), ULine.vline(before.getY() - current.getY()));
        }
        for (int i = 1; i < this.changes.size(); ++i) {
            if (this.changes.get(i - 1).isCompletelyHidden() || this.changes.get(i).isCompletelyHidden()) continue;
            double minY = Math.min(this.getPointMinY(i), this.getPointMinY(i - 1));
            double maxY = Math.max(this.getPointMaxY(i), this.getPointMaxY(i - 1));
            this.drawVline(ug, this.getPointx(i), minY, ULine.vline(maxY - minY));
        }
    }

    private void drawLabels(UGraphic ug) {
        for (int i = 0; i < this.changes.size(); ++i) {
            XPoint2D ptLabel = this.getPoints(i)[0];
            String comment = this.changes.get(i).getComment();
            if (comment == null) continue;
            TextBlock label = this.getTextBlock(comment);
            XDimension2D dim = label.calculateDimension(ug.getStringBounder());
            label.drawU(ug.apply(UTranslate.point(ptLabel).compose(new UTranslate(2.0, -dim.getHeight()))));
        }
    }

    @Override
    protected double getConstraintDeltaY(TimeConstraint constraint) {
        double y = this.yOfState(constraint.getTick1());
        for (ChangeState change : this.changes) {
            if (!constraint.containsStrict(change.getWhen())) continue;
            y = Math.min(y, this.yOfState(change.getWhen()));
        }
        return y;
    }

    private XPoint2D getInitialPoint() {
        return new XPoint2D(-40.0, this.yOfState(this.initialState));
    }

    @Override
    protected double getHeightForConstraints(StringBounder stringBounder) {
        return Math.max(10.0, super.getHeightForConstraints(stringBounder));
    }

    @Override
    public double getFullHeight(StringBounder stringBounder) {
        double height = this.getHeightForConstraints(stringBounder);
        if (this.allStates.size() > 0) {
            height += this.stepHeight() * (double)(this.allStates.size() - 1);
        }
        return (height += 12.0) + 6.0;
    }

    private double yOfState(String state) {
        int nb = this.allStates.size() - 1 - this.allStates.indexOf(state);
        return this.stepHeight() * (double)nb;
    }

    private double yOfState(TimeTick when) {
        return this.yOfState(PanelsRobust.last(this.getStatesAt(when)));
    }

    private static String last(List<String> list) {
        return list.get(list.size() - 1);
    }

    private double stepHeight() {
        if (this.suggestedHeight == 0 || this.allStates.size() <= 1) {
            return 20.0;
        }
        return this.suggestedHeight / (this.allStates.size() - 1);
    }

    public void setInitialState(String initialState, Colors initialColors) {
        this.initialState = initialState;
        if (initialState != null && !this.allStates.contains(initialState)) {
            this.allStates.add(initialState);
        }
    }
}

