/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.metrics.CardinalityAggregatorFactory;
import org.opensearch.search.aggregations.metrics.CardinalityAggregatorSupplier;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.opensearch.search.aggregations.support.ValuesSourceType;

public final class CardinalityAggregationBuilder
extends ValuesSourceAggregationBuilder.LeafOnly<ValuesSource, CardinalityAggregationBuilder> {
    public static final String NAME = "cardinality";
    public static final ValuesSourceRegistry.RegistryKey<CardinalityAggregatorSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey<CardinalityAggregatorSupplier>("cardinality", CardinalityAggregatorSupplier.class);
    private static final ParseField REHASH = new ParseField("rehash", new String[0]).withAllDeprecated("no replacement - values will always be rehashed");
    public static final ParseField PRECISION_THRESHOLD_FIELD = new ParseField("precision_threshold", new String[0]);
    public static final ParseField EXECUTION_HINT_FIELD = new ParseField("execution_hint", new String[0]);
    public static final ObjectParser<CardinalityAggregationBuilder, String> PARSER = ObjectParser.fromBuilder((String)"cardinality", CardinalityAggregationBuilder::new);
    private Long precisionThreshold = null;
    private String executionHint = null;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        CardinalityAggregatorFactory.registerAggregators(builder);
    }

    public CardinalityAggregationBuilder(String name) {
        super(name);
    }

    public CardinalityAggregationBuilder(CardinalityAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.precisionThreshold = clone.precisionThreshold;
        this.executionHint = clone.executionHint;
    }

    @Override
    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.BYTES;
    }

    public CardinalityAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.precisionThreshold = in.readLong();
        }
        if (in.getVersion().onOrAfter(Version.V_2_19_1)) {
            this.executionHint = in.readOptionalString();
        }
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new CardinalityAggregationBuilder(this, factoriesBuilder, metadata);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        boolean hasPrecisionThreshold = this.precisionThreshold != null;
        out.writeBoolean(hasPrecisionThreshold);
        if (hasPrecisionThreshold) {
            out.writeLong(this.precisionThreshold.longValue());
        }
        if (out.getVersion().onOrAfter(Version.V_2_19_1)) {
            out.writeOptionalString(this.executionHint);
        }
    }

    @Override
    protected boolean serializeTargetValueType(Version version) {
        return true;
    }

    public CardinalityAggregationBuilder precisionThreshold(long precisionThreshold) {
        if (precisionThreshold < 0L) {
            throw new IllegalArgumentException("[precisionThreshold] must be greater than or equal to 0. Found [" + precisionThreshold + "] in [" + this.name + "]");
        }
        this.precisionThreshold = precisionThreshold;
        return this;
    }

    public CardinalityAggregationBuilder executionHint(String executionHint) {
        this.executionHint = executionHint;
        return this;
    }

    @Override
    protected CardinalityAggregatorFactory innerBuild(QueryShardContext queryShardContext, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new CardinalityAggregatorFactory(this.name, config, this.precisionThreshold, queryShardContext, parent, subFactoriesBuilder, this.metadata, this.executionHint);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.precisionThreshold != null) {
            builder.field(PRECISION_THRESHOLD_FIELD.getPreferredName(), this.precisionThreshold);
        }
        if (this.executionHint != null) {
            builder.field(EXECUTION_HINT_FIELD.getPreferredName(), this.executionHint);
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precisionThreshold, this.executionHint);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CardinalityAggregationBuilder other = (CardinalityAggregationBuilder)obj;
        return Objects.equals(this.precisionThreshold, other.precisionThreshold) && Objects.equals(this.executionHint, other.executionHint);
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    protected ValuesSourceRegistry.RegistryKey<?> getRegistryKey() {
        return REGISTRY_KEY;
    }

    static {
        ValuesSourceAggregationBuilder.declareFields(PARSER, true, false, false);
        PARSER.declareLong(CardinalityAggregationBuilder::precisionThreshold, PRECISION_THRESHOLD_FIELD);
        PARSER.declareString(CardinalityAggregationBuilder::executionHint, EXECUTION_HINT_FIELD);
        PARSER.declareLong((b, v) -> {}, REHASH);
    }
}

