/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffmpeg;

import com.github.kokorin.jaffree.StreamType;
import com.github.kokorin.jaffree.process.ProcessHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class BaseInOut<T extends BaseInOut<T>> {
    private String format;
    private Long duration;
    private Long position;
    private Long positionEof;
    private final Map<String, Object> frameRates = new LinkedHashMap<String, Object>();
    private final Map<String, Object> frameSizes = new LinkedHashMap<String, Object>();
    private final Map<String, Object> codecs = new LinkedHashMap<String, Object>();
    private final Map<String, Object> pixelFormats = new LinkedHashMap<String, Object>();
    private final List<String> additionalArguments = new ArrayList<String>();

    public T setFormat(String format) {
        this.format = format;
        return this.thisAsT();
    }

    public T setDuration(long durationMillis) {
        this.duration = durationMillis;
        return this.thisAsT();
    }

    public T setDuration(Number duration, TimeUnit timeUnit) {
        long millis = (long)(duration.doubleValue() * (double)timeUnit.toMillis(1L));
        return this.setDuration(millis);
    }

    public T setPosition(long positionMillis) {
        this.position = positionMillis;
        return this.thisAsT();
    }

    public T setPosition(Number position, TimeUnit unit) {
        long millis = (long)(position.doubleValue() * (double)unit.toMillis(1L));
        return this.setPosition(millis);
    }

    public T setPositionEof(long positionEofMillis) {
        this.positionEof = positionEofMillis;
        return this.thisAsT();
    }

    public T setPositionEof(Number positionEof, TimeUnit unit) {
        long millis = (long)(positionEof.doubleValue() * (double)unit.toMillis(1L));
        return this.setPositionEof(millis);
    }

    public T setFrameRate(Number frameRate) {
        return this.setFrameRate(null, frameRate);
    }

    public T setFrameRate(String streamSpecifier, Number frameRate) {
        this.frameRates.put(streamSpecifier, frameRate);
        return this.thisAsT();
    }

    public T setFrameSize(Number width, Number height) {
        return this.setFrameSize(null, width, height);
    }

    public T setFrameSize(String streamSpecifier, Number width, Number height) {
        return this.setFrameSize(streamSpecifier, width + "x" + height);
    }

    public T setFrameSize(String streamSpecifier, String resolution) {
        this.frameSizes.put(streamSpecifier, resolution);
        return this.thisAsT();
    }

    public T setCodec(StreamType streamType, String codec) {
        return this.setCodec(streamType.code(), codec);
    }

    public T setCodec(String streamSpecifier, String codec) {
        this.codecs.put(streamSpecifier, codec);
        return this.thisAsT();
    }

    public T setPixelFormat(String pixelFormat) {
        return this.setPixelFormat(null, pixelFormat);
    }

    public T setPixelFormat(String streamSpecifier, String pixelFormat) {
        this.pixelFormats.put(streamSpecifier, pixelFormat);
        return this.thisAsT();
    }

    public T addArguments(String key, String value) {
        this.additionalArguments.addAll(Arrays.asList(key, value));
        return this.thisAsT();
    }

    public T addArgument(String argument) {
        this.additionalArguments.add(argument);
        return this.thisAsT();
    }

    public ProcessHelper helperThread() {
        return null;
    }

    protected List<String> buildArguments() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.format != null) {
            result.addAll(Arrays.asList("-f", this.format));
        }
        if (this.duration != null) {
            result.addAll(Arrays.asList("-t", BaseInOut.formatDuration(this.duration)));
        }
        if (this.position != null) {
            result.addAll(Arrays.asList("-ss", BaseInOut.formatDuration(this.position)));
        }
        if (this.positionEof != null) {
            result.addAll(Arrays.asList("-sseof", BaseInOut.formatDuration(this.positionEof)));
        }
        result.addAll(BaseInOut.toArguments("-r", this.frameRates));
        result.addAll(BaseInOut.toArguments("-s", this.frameSizes));
        result.addAll(BaseInOut.toArguments("-c", this.codecs));
        result.addAll(BaseInOut.toArguments("-pix_fmt", this.pixelFormats));
        return result;
    }

    protected final List<String> getAdditionalArguments() {
        return Collections.unmodifiableList(this.additionalArguments);
    }

    protected final T thisAsT() {
        return (T)this;
    }

    static String formatDuration(long durationMillis) {
        long divider = TimeUnit.SECONDS.toMillis(1L);
        long seconds = durationMillis / divider;
        long millis = Math.abs(durationMillis) % divider;
        return String.format("%d.%03d", seconds, millis);
    }

    protected static List<String> toArguments(String key, Map<String, Object> args) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Object> arg : args.entrySet()) {
            String specifier = arg.getKey();
            Object valueObj = arg.getValue();
            String value = valueObj != null ? valueObj.toString() : null;
            if (value == null) continue;
            if (specifier == null || specifier.isEmpty()) {
                result.add(key);
                result.add(value);
                continue;
            }
            result.add(key + ":" + specifier);
            result.add(value);
        }
        return result;
    }
}

