/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.io.BufferedReader;
import java.io.File;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.PT;
import jspecview.api.ExportInterface;
import jspecview.api.JSVExporter;
import jspecview.api.JSVPanel;
import jspecview.common.Annotation;
import jspecview.common.ExportType;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PrintLayout;
import jspecview.common.Spectrum;
import org.jmol.api.GenericFileInterface;

public class Exporter
implements ExportInterface {
    static final String newLine = System.getProperty("line.separator");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String write(JSViewer jSViewer, Lst<String> lst, boolean bl) {
        if (lst == null) {
            return this.printPDF(jSViewer, null, null, false);
        }
        String string = null;
        String string2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        JSVPanel jSVPanel = jSViewer.selectedPanel;
        try {
            switch (lst.size()) {
                default: {
                    return "WRITE what?";
                }
                case 1: {
                    int n4;
                    String string3 = string2 = PT.trimQuotes((String)lst.get(0));
                    int n5 = string2.lastIndexOf(".");
                    if (n5 >= 0) {
                        string3 = string2.substring(n5 + 1);
                        string = "XY";
                    }
                    if (jSVPanel == null) {
                        return null;
                    }
                    ExportType exportType = ExportType.getType(string3);
                    switch (exportType) {
                        case PNG: 
                        case JPG: 
                        case PDF: {
                            OC oC = n5 >= 0 ? jSViewer.getOutputChannel(new File(string2).getAbsolutePath(), false) : null;
                            return this.exportTheSpectrum(jSViewer, exportType, oC, null, -1, -1, null, false);
                        }
                    }
                    jSViewer.fileHelper.setFileChooser(exportType);
                    String[] stringArray = this.getExportableItems(jSViewer, exportType.equals((Object)ExportType.SOURCE));
                    int n6 = n4 = stringArray == null ? -1 : jSViewer.getOptionFromDialog(stringArray, "Export", "Choose a spectrum to export");
                    if (n4 == Integer.MIN_VALUE) {
                        return null;
                    }
                    GenericFileInterface genericFileInterface = jSViewer.fileHelper.getFile(this.getSuggestedFileName(jSViewer, exportType), jSVPanel, true);
                    if (genericFileInterface == null) {
                        return null;
                    }
                    OC oC = jSViewer.getOutputChannel(genericFileInterface.getFullPath(), false);
                    String string4 = this.exportSpectrumOrImage(jSViewer, exportType, n4, oC, 0, 0);
                    boolean bl2 = string4.startsWith("OK");
                    if (bl2) {
                        jSViewer.si.siUpdateRecentMenus(genericFileInterface.getFullPath());
                    }
                    oC.closeChannel();
                    return string4;
                }
                case 4: {
                    n = PT.parseInt((String)lst.get(1));
                    n2 = PT.parseInt((String)lst.get(2));
                    if (n < 0 || n2 < 0) {
                        return "width and height must be positive: " + (String)lst.get(1) + " " + (String)lst.get(2);
                    }
                    n3 = 3;
                    break;
                }
                case 2: 
            }
            string = ((String)lst.get(0)).toUpperCase();
            string2 = PT.trimQuotes((String)lst.get(n3));
            String string5 = string2.substring(string2.lastIndexOf(".") + 1).toUpperCase();
            if (string5.equals("BASE64")) {
                string2 = ";base64,";
            } else if (string5.equals("JDX")) {
                if (string == null) {
                    string = "XY";
                }
            } else if (ExportType.isExportMode(string5)) {
                string = string5;
            } else if (ExportType.isExportMode(string)) {
                string2 = String.valueOf(string2) + "." + string;
            }
            ExportType exportType = ExportType.getType(string);
            if (bl && exportType == ExportType.SVG) {
                exportType = ExportType.SVGI;
            }
            OC oC = jSViewer.getOutputChannel(string2, false);
            return this.exportSpectrumOrImage(jSViewer, exportType, -1, oC, n, n2);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    private String exportSpectrumOrImage(JSViewer jSViewer, ExportType exportType, int n, OC oC, int n2, int n3) {
        PanelData panelData = jSViewer.pd();
        if (n < 0 && (n = panelData.getCurrentSpectrumIndex()) < 0) {
            return "Error exporting spectrum: No spectrum selected";
        }
        Spectrum spectrum = panelData.getSpectrumAt(n);
        int n4 = panelData.getStartingPointIndex(n);
        int n5 = panelData.getEndingPointIndex(n);
        String string = null;
        try {
            boolean bl = oC.isBase64();
            string = this.exportTheSpectrumWH(jSViewer, exportType, oC, spectrum, n4, n5, n2, n3, bl);
            if (bl) {
                return string;
            }
            if (string.startsWith("OK")) {
                return "OK - Exported " + exportType.name() + ": " + oC.getFileName() + string.substring(2);
            }
        }
        catch (Exception exception) {
            string = exception.toString();
        }
        return "Error exporting " + oC.getFileName() + ": " + string;
    }

    @Override
    public String exportTheSpectrum(JSViewer jSViewer, ExportType exportType, OC oC, Spectrum spectrum, int n, int n2, PanelData panelData, boolean bl) throws Exception {
        return this.exportTheSpectrumWH(jSViewer, exportType, oC, spectrum, n, n2, 0, 0, bl);
    }

    private String exportTheSpectrumWH(JSViewer jSViewer, ExportType exportType, OC oC, Spectrum spectrum, int n, int n2, int n3, int n4, boolean bl) throws Exception {
        GenericFileInterface genericFileInterface = null;
        JSVPanel jSVPanel = jSViewer.selectedPanel;
        String string = exportType.name();
        switch (exportType) {
            case SVG: 
            case SVGI: 
            case CML: 
            case AML: {
                break;
            }
            case DIF: 
            case FIX: 
            case SQZ: 
            case PAC: 
            case XY: 
            case DIFDUP: {
                string = "JDX";
                break;
            }
            case PNG: 
            case JPG: {
                String string2;
                if (jSVPanel == null) {
                    return null;
                }
                if (oC == null) {
                    jSViewer.fileHelper.setFileChooser(exportType);
                    string2 = this.getSuggestedFileName(jSViewer, exportType);
                    genericFileInterface = jSViewer.fileHelper.getFile(string2, jSVPanel, true);
                    if (genericFileInterface == null) {
                        return null;
                    }
                }
                jSViewer.setCreatingImage(true);
                string2 = jSVPanel.saveImage(string.toLowerCase(), genericFileInterface, oC, n3, n4);
                jSViewer.setCreatingImage(false);
                return string2;
            }
            case PDF: {
                return this.printPDF(jSViewer, oC == null ? "PDF" : null, oC, bl);
            }
            case SOURCE: {
                if (jSVPanel == null) {
                    return null;
                }
                String string3 = jSVPanel.getPanelData().getSpectrum().getInlineData();
                if (string3 != null) {
                    oC.append(string3);
                    oC.closeChannel();
                    return "OK " + oC.getByteCount() + " bytes";
                }
                String string4 = jSVPanel.getPanelData().getSpectrum().getFilePath();
                return Exporter.fileCopy(string4, oC);
            }
            case UNK: {
                return null;
            }
        }
        return ((JSVExporter)JSViewer.getInterface("jspecview.export." + string.toUpperCase() + "Exporter")).exportTheSpectrum(jSViewer, exportType, oC, spectrum, n, n2, null, false);
    }

    private String printPDF(JSViewer jSViewer, String string, OC oC, boolean bl) {
        Object object;
        Object object2;
        boolean bl2;
        boolean bl3 = bl2 = oC != null;
        if (!bl && !jSViewer.si.isSigned()) {
            return "Error: Applet must be signed for the PRINT command.";
        }
        PanelData panelData = jSViewer.pd();
        if (panelData == null) {
            return null;
        }
        boolean bl4 = false;
        panelData.closeAllDialogsExcept(Annotation.AType.NONE);
        bl4 = oC == null || jSViewer.hasDisplay;
        PrintLayout printLayout = jSViewer.getPrintLayout(bl2);
        if (printLayout == null) {
            return null;
        }
        if (!bl4) {
            printLayout.asPDF = true;
        }
        if (bl2 && printLayout.asPDF && oC == null) {
            bl2 = false;
            string = "PDF";
        }
        JSVPanel jSVPanel = jSViewer.selectedPanel;
        if (!bl && !bl2 && jSViewer.hasDisplay) {
            object2 = jSViewer.fileHelper;
            object2.setFileChooser(ExportType.PDF);
            if (string == null || string.equals("?") || string.equalsIgnoreCase("PDF")) {
                string = this.getSuggestedFileName(jSViewer, ExportType.PDF);
            }
            if ((object = object2.getFile(string, jSVPanel, true)) == null) {
                return null;
            }
            if (!JSViewer.isJS) {
                jSViewer.setProperty("directoryLastExportedFile", object2.setDirLastExported(object.getParentAsFile().getFullPath()));
            }
            string = object.getFullPath();
        }
        object2 = null;
        try {
            if (oC == null) {
                oC = bl2 ? null : (bl ? new OC().setParams(null, ";base64,", false, null) : jSViewer.getOutputChannel(string, true));
            }
            object = "";
            jSVPanel.printPanel(printLayout, oC, (String)object);
            object2 = "OK " + oC.toString();
        }
        catch (Exception exception) {
            jSVPanel.showMessage(exception.toString(), "File Error");
        }
        return object2;
    }

    private String[] getExportableItems(JSViewer jSViewer, boolean bl) {
        PanelData panelData = jSViewer.pd();
        boolean bl2 = jSViewer.currentSource.isView;
        int n = panelData.getNumberOfSpectraInCurrentSet();
        if (n == 1 || !bl2 && bl || panelData.getCurrentSpectrumIndex() >= 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = panelData.getSpectrumAt(n2).getTitle();
            ++n2;
        }
        return stringArray;
    }

    private String getSuggestedFileName(JSViewer jSViewer, ExportType exportType) {
        int n;
        String string;
        PanelData panelData = jSViewer.pd();
        String string2 = panelData.getSpectrum().getFilePath();
        String string3 = JSVFileManager.getTagName(string2);
        if (string3.startsWith("$")) {
            string3 = string3.substring(1);
        }
        String string4 = string = (n = string3.lastIndexOf(".")) < 0 ? string3 : string3.substring(0, n);
        if (string.startsWith("http:") || string.startsWith("https:")) {
            string = string.substring(string.lastIndexOf(47) + 1);
        }
        String string5 = ".jdx";
        switch (exportType) {
            case DIF: 
            case FIX: 
            case SQZ: 
            case PAC: 
            case XY: 
            case DIFDUP: {
                if (!string.endsWith("_" + (Object)((Object)exportType))) {
                    string = String.valueOf(string) + "_" + (Object)((Object)exportType);
                }
                string5 = ".jdx";
                break;
            }
            case AML: {
                string5 = ".xml";
                break;
            }
            case SOURCE: {
                String string6;
                if (!string.endsWith("_" + (Object)((Object)exportType))) {
                    string = String.valueOf(string) + "_" + (Object)((Object)exportType);
                }
                String string7 = string6 = string2 == null ? "jspecview" : string2.toLowerCase();
                string5 = string6.endsWith(".zip") ? ".zip" : (string6.endsWith(".jdx") ? ".jdx" : "");
                break;
            }
            default: {
                string5 = "." + exportType.toString().toLowerCase();
            }
        }
        if (jSViewer.currentSource.isView) {
            string = "view";
        }
        string = String.valueOf(string) + string5;
        return string;
    }

    private static String fileCopy(String string, OC oC) {
        try {
            BufferedReader bufferedReader = JSVFileManager.getBufferedReaderFromName(string);
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                oC.append(string2);
                oC.append(newLine);
            }
            oC.closeChannel();
            return "OK " + oC.getByteCount() + " bytes";
        }
        catch (Exception exception) {
            return exception.toString();
        }
    }
}

