/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import org.apache.commons.lang3.StringUtils;
import org.gradle.api.internal.tasks.testing.TestDefinition;
import org.gradle.api.internal.tasks.testing.filter.TestSelectionMatcher;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ClassTestDefinition
implements TestDefinition {
    private final String testClassName;

    public ClassTestDefinition(String testClassName) {
        if (StringUtils.isEmpty((CharSequence)testClassName)) {
            throw new IllegalArgumentException("testClassName is empty!");
        }
        this.testClassName = testClassName;
    }

    public String getTestClassName() {
        return this.testClassName;
    }

    public String getDisplayName() {
        return "test class '" + this.testClassName + "'";
    }

    @Override
    public String getId() {
        return this.getTestClassName();
    }

    @Override
    public boolean matches(TestSelectionMatcher matcher) {
        return matcher.mayIncludeClass(this.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassTestDefinition that = (ClassTestDefinition)o;
        return this.testClassName.equals(that.testClassName);
    }

    public int hashCode() {
        return this.testClassName.hashCode();
    }

    public String toString() {
        return "ClassTestDefinition(" + this.getId() + ')';
    }
}

