/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.util;

import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.Plugin;
import java.util.ArrayList;
import java.util.List;

public class UndoRedoToolState {
    private List<PluginState> states = new ArrayList<PluginState>();

    public UndoRedoToolState(List<Plugin> plugins, DomainObject domainObject) {
        for (Plugin plugin : plugins) {
            Object state = plugin.getUndoRedoState(domainObject);
            if (state == null) continue;
            this.states.add(new PluginState(plugin, state));
        }
    }

    public void restoreTool(DomainObject domainObject) {
        for (PluginState ps : this.states) {
            ps.restoreUndoRedoState(domainObject);
        }
    }

    private static class PluginState {
        private Plugin plugin;
        private Object state;

        PluginState(Plugin p, Object state) {
            this.plugin = p;
            this.state = state;
        }

        public void restoreUndoRedoState(DomainObject domainObject) {
            if (!this.plugin.isDisposed()) {
                this.plugin.restoreUndoRedoState(domainObject, this.state);
            }
        }
    }
}

