/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.exporter;

import ghidra.graph.exporter.AbstractAttributedGraphExporter;
import ghidra.service.graph.AttributedGraph;
import java.io.File;
import java.io.IOException;
import org.jgrapht.Graph;
import org.jgrapht.nio.matrix.MatrixExporter;

public class MatrixGraphExporter
extends AbstractAttributedGraphExporter {
    private static final MatrixExporter.Format MATRIX_FORMAT = MatrixExporter.Format.SPARSE_ADJACENCY_MATRIX;

    public void exportGraph(AttributedGraph graph, File file) throws IOException {
        MatrixExporter exporter = new MatrixExporter(MATRIX_FORMAT, this.vertexIdProvider);
        try {
            exporter.exportGraph((Graph)graph, file);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String getFileExtension() {
        return "g";
    }

    public String getName() {
        return "MATRIX";
    }

    public String getDesciption() {
        return "JGraphT library export of a graph to a MATRIX file";
    }
}

