/*
 * Decompiled with CFR 0.152.
 */
package generic.util;

import java.util.Iterator;
import java.util.function.Function;

public class FlattenedIterator<O, I>
implements Iterator<I> {
    protected final Iterator<O> outer;
    protected final Function<O, Iterator<? extends I>> innerFactory;
    protected Iterator<? extends I> inner;
    protected Iterator<? extends I> preppedInner;

    public static <O, I> Iterator<I> start(Iterator<O> outer, Function<O, Iterator<? extends I>> innerFactory) {
        return new FlattenedIterator<O, I>(outer, innerFactory);
    }

    protected FlattenedIterator(Iterator<O> outer, Function<O, Iterator<? extends I>> innerFactory) {
        this.outer = outer;
        this.innerFactory = innerFactory;
    }

    private Iterator<? extends I> prepNextIterator() {
        while (this.outer.hasNext()) {
            Iterator<I> candidate = this.innerFactory.apply(this.outer.next());
            if (candidate == null || !candidate.hasNext()) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        if (this.inner != null && this.inner.hasNext() || this.preppedInner != null && this.preppedInner.hasNext()) {
            return true;
        }
        this.preppedInner = this.prepNextIterator();
        return this.preppedInner != null;
    }

    @Override
    public I next() {
        if (this.inner == null || !this.inner.hasNext()) {
            if (this.preppedInner == null) {
                this.preppedInner = this.prepNextIterator();
            }
            if (this.preppedInner == null) {
                return null;
            }
            this.inner = this.preppedInner;
            this.preppedInner = null;
        }
        return this.inner.next();
    }

    @Override
    public void remove() {
        this.inner.remove();
    }
}

