/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.xml;

import ghidra.util.xml.Counter;

class XmlSummary {
    XmlSummary() {
    }

    static String getSummary(Counter counter) {
        StringBuffer buffer = new StringBuffer(256);
        int origTotal = counter.getTotalCount();
        buffer.append("\n");
        buffer.append("\nXML Program Summary:");
        buffer.append("\n--------------------------");
        buffer.append("\nMemory Sections:       " + counter.getCountAndRemove("MEMORY_SECTION"));
        buffer.append("\nMemory Contents:       " + counter.getCountAndRemove("MEMORY_CONTENTS"));
        buffer.append("\nCode Blocks:           " + counter.getCountAndRemove("CODE_BLOCK"));
        buffer.append("\nDefined Data:          " + counter.getCountAndRemove("DEFINED_DATA"));
        buffer.append("\nStructures:            " + counter.getCountAndRemove("STRUCTURE"));
        buffer.append("\nUnions:                " + counter.getCountAndRemove("UNION"));
        buffer.append("\nTypedefs:              " + counter.getCountAndRemove("TYPE_DEF"));
        buffer.append("\nEnums:                 " + counter.getCountAndRemove("ENUM"));
        buffer.append("\nSymbols:               " + counter.getCountAndRemove("SYMBOL"));
        buffer.append("\nEntry Points:          " + counter.getCountAndRemove("PROGRAM_ENTRY_POINT"));
        buffer.append("\nEquates:               " + counter.getCountAndRemove("EQUATE"));
        buffer.append("\n    References:        " + counter.getCountAndRemove("EQUATE_REFERENCE"));
        buffer.append("\nComments:              " + counter.getCountAndRemove("COMMENT"));
        buffer.append("\nBookmarks:             " + counter.getCountAndRemove("BOOKMARK"));
        buffer.append("\nProperties:            " + counter.getCountAndRemove("PROPERTY"));
        buffer.append("\nProgram Trees:         " + counter.getCountAndRemove("TREE"));
        buffer.append("\n    Folders:           " + counter.getCountAndRemove("FOLDER"));
        buffer.append("\n    Fragments:         " + counter.getCountAndRemove("FRAGMENT"));
        buffer.append("\nFunction Signatures:   " + counter.getCountAndRemove("FUNCTION_DEF"));
        buffer.append("\n    Parameters:        " + counter.getCountAndRemove("PARAMETER"));
        buffer.append("\nFunctions:             " + counter.getCountAndRemove("FUNCTION"));
        buffer.append("\n    Stack Frames:      " + counter.getCountAndRemove("STACK_FRAME"));
        buffer.append("\n    Stack Vars:        " + counter.getCountAndRemove("STACK_VAR"));
        buffer.append("\n    Register Vars:     " + counter.getCountAndRemove("REGISTER_VAR"));
        buffer.append("\nReferences:            " + counter.getCountAndRemove("MEMORY_REFERENCE") + counter.getCountAndRemove("STACK_REFERENCE") + counter.getCountAndRemove("EXT_LIBRARY_REFERENCE"));
        buffer.append("\nRelocations:           " + counter.getCountAndRemove("RELOCATION"));
        buffer.append("\n");
        counter.getCountAndRemove("MEMBER");
        buffer.append("\n--------------------------");
        buffer.append("\nTotal XML Elements:    " + origTotal);
        buffer.append("\n    Processed:         " + (origTotal - counter.getTotalCount()));
        buffer.append("\n    Overhead:          " + counter.getTotalCount());
        buffer.append("\n");
        counter.clear();
        return buffer.toString();
    }
}

