/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.strings;

import ghidra.app.plugin.core.strings.CharacterScriptUtils;
import ghidra.app.plugin.core.strings.EncodedStringsFilterStats;
import ghidra.app.plugin.core.strings.EncodedStringsOptions;
import ghidra.app.plugin.core.strings.StringInfo;
import ghidra.program.model.data.StringDataInstance;
import java.util.EnumSet;

record EncodedStringsRow(StringDataInstance sdi, StringInfo stringInfo, int refCount, int offcutCount, boolean validString) {
    boolean matches(EncodedStringsOptions options, EncodedStringsFilterStats stats) {
        ++stats.total;
        String str = this.stringInfo.stringValue();
        if (options.minStringLength() > 0 && str.length() < options.minStringLength()) {
            ++stats.stringLength;
            return false;
        }
        if (options.excludeStringsWithErrors() && this.stringInfo.hasCodecError()) {
            ++stats.codecErrors;
            return false;
        }
        if (options.excludeNonStdCtrlChars() && this.stringInfo.hasNonStdCtrlChars()) {
            ++stats.nonStdCtrlChars;
            return false;
        }
        this.stringInfo.scripts().forEach(foundScript -> stats.foundScriptCounts.merge((Character.UnicodeScript)((Object)foundScript), 1, (prevValue, newValue) -> prevValue + newValue));
        if (options.requiredScripts() != null && !options.requiredScripts().isEmpty() && !this.stringInfo.scripts().containsAll(options.requiredScripts())) {
            ++stats.requiredScripts;
            return false;
        }
        if (options.allowedScripts() != null) {
            EnumSet<Character.UnicodeScript> scripts = EnumSet.copyOf(this.stringInfo.scripts());
            scripts.removeAll(CharacterScriptUtils.IGNORED_SCRIPTS);
            scripts.removeAll(options.requiredScripts());
            boolean hadLatin = scripts.remove((Object)Character.UnicodeScript.LATIN);
            boolean hadCommon = scripts.remove((Object)Character.UnicodeScript.COMMON);
            scripts.removeAll(options.allowedScripts());
            if (!scripts.isEmpty()) {
                ++stats.otherScripts;
                return false;
            }
            if (hadLatin && !options.allowedScripts().contains((Object)Character.UnicodeScript.LATIN)) {
                ++stats.latinScript;
                return false;
            }
            if (hadCommon && !options.allowedScripts().contains((Object)Character.UnicodeScript.COMMON)) {
                ++stats.commonScript;
                return false;
            }
        }
        if (options.requireValidString() && options.stringValidator() != null && !this.validString) {
            ++stats.failedStringModel;
            return false;
        }
        return true;
    }
}

