/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import docking.widgets.fieldpanel.support.Highlight;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReference;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.EventType;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramEvent;
import ghidra.program.util.ProgramLocation;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class LocationDescriptor {
    protected Highlight[] EMPTY_HIGHLIGHTS = new Highlight[0];
    protected ProgramLocation programLocation;
    protected List<LocationReference> referenceAddressList;
    private Comparator<Object> addressToLocationReferenceComparator = new Comparator<Object>(this){

        @Override
        public int compare(Object o1, Object o2) {
            return this.toAddress(o1).compareTo((Object)this.toAddress(o2));
        }

        private Address toAddress(Object obj) {
            if (obj instanceof Address) {
                return (Address)obj;
            }
            LocationReference ref = (LocationReference)obj;
            return ref.getLocationOfUse();
        }
    };
    protected Address homeAddress;
    protected String label;
    protected Program program;
    protected ChangeListener modelFreshnessListener;
    protected boolean useDynamicSearching = true;

    LocationDescriptor(ProgramLocation programLocation, Program program) {
        this.programLocation = programLocation;
        this.program = program;
    }

    ProgramLocation getLocation() {
        return this.programLocation;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.label;
    }

    protected boolean domainObjectChanged(DomainObjectChangedEvent changeEvent) {
        if (this.getHomeAddress() == null) {
            return true;
        }
        block7: for (int i = 0; i < changeEvent.numRecords(); ++i) {
            DomainObjectChangeRecord domainObjectRecord = changeEvent.getChangeRecord(i);
            EventType eventType = domainObjectRecord.getEventType();
            if (eventType == DomainObjectEvent.RESTORED) {
                this.checkForAddressChange(domainObjectRecord);
                return true;
            }
            if (!(eventType instanceof ProgramEvent)) continue;
            ProgramEvent type = (ProgramEvent)eventType;
            switch (type) {
                case MEMORY_BLOCK_MOVED: 
                case MEMORY_BLOCK_REMOVED: {
                    if (!this.program.getMemory().contains(this.getHomeAddress())) continue block7;
                    this.checkForAddressChange(domainObjectRecord);
                    return true;
                }
                case SYMBOL_ADDED: 
                case SYMBOL_RENAMED: 
                case SYMBOL_REMOVED: {
                    this.checkForAddressChange(domainObjectRecord);
                    return true;
                }
                case REFERENCE_ADDED: {
                    ProgramChangeRecord changeRecord = (ProgramChangeRecord)domainObjectRecord;
                    Reference ref = (Reference)changeRecord.getNewValue();
                    if (!this.refersToAddress(ref, this.getHomeAddress())) continue block7;
                    this.checkForAddressChange(domainObjectRecord);
                    return true;
                }
                case REFERENCE_REMOVED: {
                    ProgramChangeRecord changeRecord = (ProgramChangeRecord)domainObjectRecord;
                    Reference ref = (Reference)changeRecord.getOldValue();
                    if (!this.refersToAddress(ref, this.getHomeAddress())) continue block7;
                    this.checkForAddressChange(domainObjectRecord);
                    return true;
                }
                case SYMBOL_ASSOCIATION_ADDED: 
                case SYMBOL_ASSOCIATION_REMOVED: {
                    ProgramChangeRecord changeRecord = (ProgramChangeRecord)domainObjectRecord;
                    Reference ref = (Reference)changeRecord.getObject();
                    if (!this.refersToAddress(ref, this.getHomeAddress())) continue block7;
                    this.checkForAddressChange(domainObjectRecord);
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean checkForAddressChange(DomainObjectChangeRecord changeRecord) {
        if (changeRecord instanceof ProgramChangeRecord) {
            Address address = ((ProgramChangeRecord)changeRecord).getStart();
            if (this.referenceAddressList == null) {
                return false;
            }
            boolean removed = this.removeReferencesFromAddress(address);
            if (this.modelFreshnessListener != null) {
                this.modelFreshnessListener.stateChanged(new ChangeEvent(this));
            }
            return removed;
        }
        if (changeRecord.getEventType() == DomainObjectEvent.RESTORED) {
            if (this.modelFreshnessListener != null) {
                this.modelFreshnessListener.stateChanged(new ChangeEvent(this));
            }
            return true;
        }
        return false;
    }

    protected boolean refersToAddress(Reference reference, Address address) {
        Address toAddress = reference.getToAddress();
        return toAddress.equals((Object)address);
    }

    protected boolean removeReferencesFromAddress(Address address) {
        int result = Collections.binarySearch(this.referenceAddressList, address, this.addressToLocationReferenceComparator);
        if (result < 0) {
            return false;
        }
        while (result >= 0) {
            this.referenceAddressList.remove(result);
            result = Collections.binarySearch(this.referenceAddressList, address, this.addressToLocationReferenceComparator);
        }
        return true;
    }

    protected boolean referencesContain(Address address) {
        if (address == null) {
            return false;
        }
        if (this.referenceAddressList == null) {
            return false;
        }
        int result = Collections.binarySearch(this.referenceAddressList, address, this.addressToLocationReferenceComparator);
        return result >= 0;
    }

    protected Address getAddressForHighlightObject(Object object) {
        if (object instanceof CodeUnit) {
            return ((CodeUnit)object).getMinAddress();
        }
        if (object instanceof Function) {
            return ((Function)object).getEntryPoint();
        }
        if (object instanceof Variable) {
            Variable variable = (Variable)object;
            return variable.getFunction().getEntryPoint();
        }
        return null;
    }

    protected boolean isInAddresses(Address address) {
        return this.referencesContain(address) || this.getHomeAddress().equals((Object)address);
    }

    Program getProgram() {
        return this.program;
    }

    Address getHomeAddress() {
        return this.homeAddress;
    }

    ProgramLocation getHomeLocation() {
        return new ProgramLocation(this.program, this.homeAddress);
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        Class<?> clazz = obj.getClass();
        if (this.getClass() != clazz) {
            return false;
        }
        LocationDescriptor otherDescriptor = (LocationDescriptor)obj;
        return this.label.equals(otherDescriptor.label) && this.program == otherDescriptor.program && this.homeAddress.equals((Object)otherDescriptor.homeAddress) && this.programLocation.getAddress().equals((Object)otherDescriptor.programLocation.getAddress());
    }

    public int hashCode() {
        return this.label.hashCode() + this.program.hashCode() + this.homeAddress.hashCode() + this.programLocation.getAddress().hashCode();
    }

    public void dispose() {
        this.referenceAddressList.clear();
        this.modelFreshnessListener = null;
    }

    abstract Highlight[] getHighlights(String var1, Object var2, Class<? extends FieldFactory> var3, Color var4);

    protected abstract void doGetReferences(Accumulator<LocationReference> var1, TaskMonitor var2) throws CancelledException;

    public String getTypeName() {
        return this.label;
    }

    private void getReferenceAddressSet(Accumulator<LocationReference> accumulator, TaskMonitor monitor, boolean reload) throws CancelledException {
        if (this.referenceAddressList == null || reload) {
            this.doGetReferences(accumulator, monitor);
            this.referenceAddressList = new ArrayList<LocationReference>(accumulator.get());
            Collections.sort(this.referenceAddressList);
            return;
        }
        accumulator.addAll(this.referenceAddressList);
    }

    void getReferences(Accumulator<LocationReference> accumulator, TaskMonitor monitor, boolean reload) throws CancelledException {
        this.getReferenceAddressSet(accumulator, monitor, reload);
    }

    void setUseDynamicSearching(boolean useDynamicSearching) {
        this.useDynamicSearching = useDynamicSearching;
    }

    void setModelFreshnessListener(ChangeListener modelFreshnessListener) {
        this.modelFreshnessListener = modelFreshnessListener;
    }
}

