/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.ModalSatelliteGraphMouse;
import edu.uci.ics.jung.visualization.transform.MutableAffineTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public class SatelliteVisualizationViewer<V, E>
extends VisualizationViewer<V, E> {
    protected VisualizationViewer<V, E> master;

    public SatelliteVisualizationViewer(VisualizationViewer<V, E> master, Dimension preferredSize) {
        super(master.getModel(), preferredSize);
        this.master = master;
        ModalSatelliteGraphMouse gm = new ModalSatelliteGraphMouse();
        this.setGraphMouse(gm);
        this.addPreRenderPaintable(new ViewLens<V, E>(this, master));
        AffineTransform modelLayoutTransform = new AffineTransform(master.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).getTransform());
        this.getRenderContext().getMultiLayerTransformer().setTransformer(Layer.LAYOUT, new MutableAffineTransformer(modelLayoutTransform));
        master.addChangeListener(this);
        this.setPickedVertexState(master.getPickedVertexState());
        this.setPickedEdgeState(master.getPickedEdgeState());
    }

    public VisualizationViewer<V, E> getMaster() {
        return this.master;
    }

    static class ViewLens<V, E>
    implements VisualizationServer.Paintable {
        VisualizationViewer<V, E> master;
        VisualizationViewer<V, E> vv;

        public ViewLens(VisualizationViewer<V, E> vv, VisualizationViewer<V, E> master) {
            this.vv = vv;
            this.master = master;
        }

        @Override
        public void paint(Graphics g) {
            MutableTransformer masterViewTransformer = this.master.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW);
            MutableTransformer masterLayoutTransformer = this.master.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT);
            MutableTransformer vvLayoutTransformer = this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT);
            Shape lens = this.master.getBounds();
            lens = masterViewTransformer.inverseTransform(lens);
            lens = masterLayoutTransformer.inverseTransform(lens);
            lens = vvLayoutTransformer.transform(lens);
            Graphics2D g2d = (Graphics2D)g;
            Color old = g.getColor();
            Color lensColor = this.master.getBackground();
            this.vv.setBackground(lensColor.darker());
            g.setColor(lensColor);
            g2d.fill(lens);
            g.setColor(Color.gray);
            g2d.draw(lens);
            g.setColor(old);
        }

        @Override
        public boolean useTransform() {
            return true;
        }
    }
}

