/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.util.Relaxer;
import edu.uci.ics.jung.algorithms.layout.util.VisRunner;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.layout.ObservableCachingLayout;
import edu.uci.ics.jung.visualization.util.ChangeEventSupport;
import edu.uci.ics.jung.visualization.util.DefaultChangeEventSupport;
import java.awt.Dimension;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefaultVisualizationModel<V, E>
implements VisualizationModel<V, E>,
ChangeEventSupport {
    ChangeEventSupport changeSupport = new DefaultChangeEventSupport(this);
    protected Relaxer relaxer;
    protected Layout<V, E> layout;
    protected ChangeListener changeListener;

    public DefaultVisualizationModel(Layout<V, E> layout) {
        this(layout, null);
    }

    public DefaultVisualizationModel(Layout<V, E> layout, Dimension d) {
        if (this.changeListener == null) {
            this.changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DefaultVisualizationModel.this.fireStateChanged();
                }
            };
        }
        this.setGraphLayout(layout, d);
    }

    @Override
    public void setGraphLayout(Layout<V, E> layout, Dimension viewSize) {
        Dimension layoutSize;
        if (this.layout != null && this.layout instanceof ChangeEventSupport) {
            ((ChangeEventSupport)this.layout).removeChangeListener(this.changeListener);
        }
        this.layout = layout instanceof ChangeEventSupport ? layout : new ObservableCachingLayout<V, E>(layout);
        ((ChangeEventSupport)this.layout).addChangeListener(this.changeListener);
        if (viewSize == null) {
            viewSize = new Dimension(600, 600);
        }
        if ((layoutSize = layout.getSize()) == null) {
            layout.setSize(viewSize);
        }
        if (this.relaxer != null) {
            this.relaxer.stop();
            this.relaxer = null;
        }
        if (layout instanceof IterativeContext) {
            layout.initialize();
            if (this.relaxer == null) {
                this.relaxer = new VisRunner((IterativeContext)this.layout);
                this.relaxer.prerelax();
                this.relaxer.relax();
            }
        }
        this.fireStateChanged();
    }

    @Override
    public void setGraphLayout(Layout<V, E> layout) {
        this.setGraphLayout(layout, null);
    }

    @Override
    public Layout<V, E> getGraphLayout() {
        return this.layout;
    }

    @Override
    public Relaxer getRelaxer() {
        return this.relaxer;
    }

    public void setRelaxer(VisRunner relaxer) {
        this.relaxer = relaxer;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public ChangeListener[] getChangeListeners() {
        return this.changeSupport.getChangeListeners();
    }

    @Override
    public void fireStateChanged() {
        this.changeSupport.fireStateChanged();
    }
}

