/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.generic;

import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.disassemble.DisassemblerMessageListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;

public class iOS_Analyzer
extends FileFormatAnalyzer {
    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, final MessageLog log) throws Exception {
        DisassemblerMessageListener listener = new DisassemblerMessageListener(){

            public void disassembleMessageReported(String msg) {
                log.appendMsg(msg);
            }
        };
        Address imageBase = program.getImageBase();
        AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager((Program)program);
        Disassembler disassembler = Disassembler.getDisassembler((Program)program, (TaskMonitor)monitor, (DisassemblerMessageListener)listener);
        disassembler.disassemble(imageBase.add(0L), null, false);
        manager.disassemble(imageBase.add(0L));
        disassembler.disassemble(imageBase.add(4L), null, false);
        disassembler.disassemble(imageBase.add(8L), null, false);
        disassembler.disassemble(imageBase.add(12L), null, false);
        disassembler.disassemble(imageBase.add(16L), null, false);
        disassembler.disassemble(imageBase.add(20L), null, false);
        disassembler.disassemble(imageBase.add(24L), null, false);
        disassembler.disassemble(imageBase.add(28L), null, false);
        disassembler.disassemble(imageBase.add(32L), (AddressSetView)new AddressSet(imageBase.add(32L)), false);
        disassembler.disassemble(imageBase.add(64L), null, false);
        disassembler.disassemble(imageBase.add(116L), null, false);
        this.createData(program, imageBase.add(512L), (DataType)new StringDataType());
        this.createData(program, imageBase.add(576L), (DataType)new StringDataType());
        this.createData(program, imageBase.add(640L), (DataType)new StringDataType());
        long offset = 812L;
        while (!monitor.isCancelled() && offset <= 1512L) {
            disassembler.disassemble(imageBase.add(offset), null);
            Function function = this.createFunction(program, imageBase.add(offset));
            if (function == null) break;
            offset = function.getBody().getMaxAddress().getOffset() + 1L - imageBase.getOffset();
        }
        log.appendMsg("You should now run the iOS_ThumbFunctionFinder script!");
        return true;
    }

    public boolean canAnalyze(Program program) {
        return false;
    }

    @Override
    public AnalyzerType getAnalysisType() {
        return AnalyzerType.BYTE_ANALYZER;
    }

    public boolean getDefaultEnablement(Program program) {
        return this.canAnalyze(program);
    }

    public String getDescription() {
        return "Performs initial analysis for iBoot, LLB, iBSS, and iBEC files";
    }

    public String getName() {
        return "iOS Analyzer for iBoot, LLB, iBSS, and iBEC files";
    }

    @Override
    public AnalysisPriority getPriority() {
        return AnalysisPriority.FORMAT_ANALYSIS;
    }

    public boolean isPrototype() {
        return false;
    }
}

